/* rgi.h was originally generated by the autoSql program, which also 
 * generated rgi.c and rgi.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef RGI_H
#define RGI_H

struct rgi
/* range graph input structure */
    {
    struct rgi *next;  /* Next in singly linked list. */
    char *a;	/* First node */
    char *b;	/* Second node */
    int minDistance;	/* Minimum distance between nodes */
    int maxDistance;	/* Maximum distance between nodes */
    };

void rgiStaticLoad(char **row, struct rgi *ret);
/* Load a row from rgi table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rgi *rgiLoad(char **row);
/* Load a rgi from row fetched with select * from rgi
 * from database.  Dispose of this with rgiFree(). */

struct rgi *rgiCommaIn(char **pS, struct rgi *ret);
/* Create a rgi out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rgi */

void rgiFree(struct rgi **pEl);
/* Free a single dynamically allocated rgi such as created
 * with rgiLoad(). */

void rgiFreeList(struct rgi **pList);
/* Free a list of dynamically allocated rgi's */

void rgiOutput(struct rgi *el, FILE *f, char sep, char lastSep);
/* Print out rgi.  Separate fields with sep. Follow last field with lastSep. */

#define rgiTabOut(el,f) rgiOutput(el,f,'\t','\n');
/* Print out rgi as a line in a tab-separated file. */

#define rgiCommaOut(el,f) rgiOutput(el,f,',',',');
/* Print out rgi as a comma separated list including final comma. */

#endif /* RGI_H */

