# `i18n`
The `i18n` function is used to retrieve messages from a locale-specific `ResourceBundle`.
Every `PebbleTemplate` is assigned a default locale from the `PebbleEngine`. At the point of evaluation, this
locale can be changed with an argument to the `evaluate(...)` method of the individual template.

The `i18n` function wraps around `ResourceBundle.getBundle(name, locale).getObject(key)`.
The first argument to the `i18n` function is the name of the bundle and the second argument is the key
within the bundle.

```twig
{{ i18n("messages","greeting") }}
```

The above example assumes you have `messages.properties` on your classpath and that that file contains
a key by the name of `greeting`. If the locale of that template was `es_US` for example, it would look for a
`message_es_US.properties` file instead.

Going a little further, you can use variables within your message and pass a list of params to this
function which will replace your variables using `MessageFormat`:
```twig
{# greeting.someone=Hello, {0} #}
{{ i18n("messages","greeting", "Jacob") }}

{# output: Hello, Jacob #}
```

## Arguments
- bundle
- key
- params