/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.json.JsonParser;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"CONTROL_CHARS", "", "", "SPECIAL_CHARS", "", "getSPECIAL_CHARS", "()Ljava/util/Map;", "escape", "", "unescape", "commons"})
@SourceDebugExtension(value={"SMAP\nJsonSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSupport.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonSupportKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1549#3:104\n1620#3,3:105\n*S KotlinDebug\n*F\n+ 1 JsonSupport.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonSupportKt\n*L\n56#1:104\n56#1:105,3\n*E\n"})
public final class JsonSupportKt {
    @NotNull
    private static final Map<Character, Character> SPECIAL_CHARS;
    @NotNull
    private static final Set<Character> CONTROL_CHARS;

    @NotNull
    public static final Map<Character, Character> getSPECIAL_CHARS() {
        return SPECIAL_CHARS;
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        Intrinsics.checkNotNullParameter((Object)$this$escape, (String)"<this>");
        Ref.ObjectRef output = new Ref.ObjectRef();
        Ref.IntRef i = new Ref.IntRef();
        while (i.element < $this$escape.length()) {
            char ch = $this$escape.charAt(i.element);
            if (ch == '\\') {
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, "\\\\");
            } else if (ch == '\"') {
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, "\\\"");
            } else if (ch == '\n') {
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, "\\n");
            } else if (ch == '\r') {
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, "\\r");
            } else if (ch == '\t') {
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, "\\t");
            } else if (CONTROL_CHARS.contains(Character.valueOf(ch))) {
                StringBuilder stringBuilder = new StringBuilder().append("\\u");
                String string = Integer.toString(ch, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                JsonSupportKt.escape$appendOutput((Ref.ObjectRef<StringBuilder>)output, $this$escape, i, stringBuilder.append(StringsKt.padStart((String)string, (int)4, (char)'0')).toString());
            } else {
                StringBuilder stringBuilder = (StringBuilder)output.element;
                if (stringBuilder != null) {
                    stringBuilder.append(ch);
                }
            }
            int n = i.element;
            i.element = n + 1;
        }
        StringBuilder stringBuilder = (StringBuilder)output.element;
        String string = stringBuilder != null ? stringBuilder.toString() : null;
        if (string == null) {
            string = $this$escape;
        }
        return string;
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$unescape, (String)"<this>");
        StringBuilder output = null;
        int start2 = 1;
        int end = $this$unescape.length() - 1;
        int i = 0;
        i = start2;
        while (i < end) {
            char ch = $this$unescape.charAt(i);
            if (ch == '\\') {
                Character c;
                Character c2;
                char escapedChar;
                Character c3;
                StringBuilder stringBuilder = output;
                if (stringBuilder == null) {
                    String string3 = $this$unescape.substring(start2, i);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    stringBuilder = output = new StringBuilder(string3);
                }
                if (SPECIAL_CHARS.containsKey(c3 = Character.valueOf(escapedChar = $this$unescape.charAt(++i)))) {
                    Character it = c2 = SPECIAL_CHARS.get(Character.valueOf(escapedChar));
                    boolean bl = false;
                    ++i;
                    c = c2;
                } else if (escapedChar == 'u') {
                    String string4 = $this$unescape.substring(i + 1, i + 5);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    c2 = Character.valueOf((char)Integer.parseInt(string4, CharsKt.checkRadix((int)16)));
                    char it = c2.charValue();
                    boolean bl = false;
                    i += 5;
                    c = c2;
                } else {
                    throw new JsonParser.JsonException("Invalid escape character: " + escapedChar);
                }
                Character it = c;
                boolean bl = false;
                output.append(it);
                continue;
            }
            StringBuilder stringBuilder = output;
            if (stringBuilder != null) {
                stringBuilder.append(ch);
            }
            int n = i;
            i = n + 1;
        }
        StringBuilder stringBuilder = output;
        String string5 = string2 = stringBuilder != null ? stringBuilder.toString() : null;
        if (string2 == null) {
            String string6 = $this$unescape.substring(start2, end);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        } else {
            string = string2;
        }
        return string;
    }

    private static final void escape$appendOutput(Ref.ObjectRef<StringBuilder> output, String $this_escape, Ref.IntRef i, String str) {
        StringBuilder stringBuilder = (StringBuilder)output.element;
        if (stringBuilder == null) {
            String string = $this_escape.substring(0, i.element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            stringBuilder = new StringBuilder(string);
        }
        output.element = stringBuilder.append(str);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)Character.valueOf('\"')), TuplesKt.to((Object)Character.valueOf('\\'), (Object)Character.valueOf('\\')), TuplesKt.to((Object)Character.valueOf('/'), (Object)Character.valueOf('/')), TuplesKt.to((Object)Character.valueOf('b'), (Object)Character.valueOf('\b')), TuplesKt.to((Object)Character.valueOf('f'), (Object)Character.valueOf('\f')), TuplesKt.to((Object)Character.valueOf('n'), (Object)Character.valueOf('\n')), TuplesKt.to((Object)Character.valueOf('r'), (Object)Character.valueOf('\r')), TuplesKt.to((Object)Character.valueOf('t'), (Object)Character.valueOf('\t'))};
        SPECIAL_CHARS = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)32);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p0;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)p0));
        }
        CONTROL_CHARS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

