/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.provider.PseudoSelectorsCompletionProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;
import java.util.Set;
import org.intellij.plugins.postcss.psi.PostCssCustomMedia;
import org.intellij.plugins.postcss.psi.PostCssPsiUtil;
import org.intellij.plugins.postcss.psi.stubs.PostCssCustomMediaIndex;
import org.intellij.plugins.postcss.references.PostCssCustomMediaReference;
import org.intellij.plugins.postcss.references.PostCssCustomSelectorReference;
import org.jetbrains.annotations.NotNull;

public class PostCssCompletionContributor
extends CompletionContributor {
    public PostCssCompletionContributor() {
        this.extend(CompletionType.BASIC, PostCssCompletionContributor.customSelector(), (CompletionProvider)new PseudoSelectorsCompletionProvider());
    }

    @NotNull
    private static ElementPattern<? extends PsiElement> customSelector() {
        PsiElementPattern psiElementPattern = PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withReference(PostCssCustomSelectorReference.class);
        if (psiElementPattern == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(0);
        }
        return psiElementPattern;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result.isStopped()) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (!PostCssPsiUtil.isInsidePostCss(position)) {
            return;
        }
        PsiElementPattern.Capture isIdent = PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT);
        boolean isCustomMedia = ((PsiElementPattern.Capture)isIdent.withReference(PostCssCustomMediaReference.class)).accepts((Object)position);
        if (isCustomMedia) {
            PostCssCompletionContributor.addVariantsForCustomMedia(parameters, result);
        }
    }

    private static void addVariantsForCustomMedia(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)parameters.getOriginalFile(), (PsiElement)position, (boolean)false);
        for (String name : StubIndex.getInstance().getAllKeys(PostCssCustomMediaIndex.KEY, project)) {
            if (name.isEmpty()) continue;
            for (PostCssCustomMedia element : StubIndex.getElements(PostCssCustomMediaIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, PostCssCustomMedia.class)) {
                result.addElement(PostCssCompletionContributor.createCustomElementLookup(element, importedFiles));
            }
        }
    }

    @NotNull
    private static LookupElement createCustomElementLookup(@NotNull CssNamedElement element, @NotNull Set<VirtualFile> importedFiles) {
        if (element == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(5);
        }
        if (importedFiles == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(6);
        }
        int priority = 10 + (importedFiles.contains(element.getContainingFile().getVirtualFile()) ? 1 : 0);
        ItemPresentation itemPresentation = Objects.requireNonNull(element.getPresentation());
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)("--" + element.getName()), (PsiElement)element).withPresentableText(Objects.requireNonNull(itemPresentation.getPresentableText())).withIcon(itemPresentation.getIcon(false)).withTypeText(itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            PostCssCompletionContributor.$$$reportNull$$$0(7);
        }
        return lookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/postcss/completion/PostCssCompletionContributor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "customSelector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/postcss/completion/PostCssCompletionContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomElementLookup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForCustomMedia";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomElementLookup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

