/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import com.github.javafaker.service.FakerIDN;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Company {
    private final Faker faker;

    protected Company(Faker faker) {
        this.faker = faker;
    }

    public String name() {
        return this.faker.fakeValuesService().resolve("company.name", this, this.faker);
    }

    public String suffix() {
        return this.faker.fakeValuesService().resolve("company.suffix", this, this.faker);
    }

    public String industry() {
        return this.faker.fakeValuesService().resolve("company.industry", this, this.faker);
    }

    public String profession() {
        return this.faker.fakeValuesService().resolve("company.profession", this, this.faker);
    }

    public String buzzword() {
        List buzzwordLists = (List)this.faker.fakeValuesService().fetchObject("company.buzzwords");
        ArrayList buzzwords = new ArrayList();
        for (List buzzwordList : buzzwordLists) {
            buzzwords.addAll(buzzwordList);
        }
        return (String)buzzwords.get(this.faker.random().nextInt(buzzwords.size()));
    }

    public String catchPhrase() {
        List catchPhraseLists = (List)this.faker.fakeValuesService().fetchObject("company.buzzwords");
        return this.joinSampleOfEachList(catchPhraseLists, " ");
    }

    public String bs() {
        List buzzwordLists = (List)this.faker.fakeValuesService().fetchObject("company.bs");
        return this.joinSampleOfEachList(buzzwordLists, " ");
    }

    public String logo() {
        int number = this.faker.random().nextInt(13) + 1;
        return "https://pigment.github.io/fake-logos/logos/medium/color/" + number + ".png";
    }

    public String url() {
        return StringUtils.join((Object[])new String[]{"www", ".", FakerIDN.toASCII(this.domainName()), ".", this.domainSuffix()});
    }

    private String domainName() {
        return StringUtils.deleteWhitespace((String)this.name().toLowerCase().replaceAll(",", "").replaceAll("'", ""));
    }

    private String domainSuffix() {
        return this.faker.fakeValuesService().resolve("internet.domain_suffix", this, this.faker);
    }

    private String joinSampleOfEachList(List<List<String>> listOfLists, String separator) {
        ArrayList<String> words = new ArrayList<String>();
        for (List<String> list2 : listOfLists) {
            words.add(list2.get(this.faker.random().nextInt(list2.size())));
        }
        return StringUtils.join(words, (String)separator);
    }
}

