/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.examples.server.HttpClientExamplesServerKt;
import com.intellij.httpClient.examples.server.WebSocketRepeatMessage;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/examples/server/WebSocketClientHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "<init>", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "disconnected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "getMessageServer", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/WebSocketClientHandler\n+ 2 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,611:1\n430#2,2:612\n433#2,2:616\n58#3:614\n51#3:615\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/WebSocketClientHandler\n*L\n88#1:612,2\n88#1:616,2\n88#1:614\n88#1:615\n*E\n"})
final class WebSocketClientHandler
extends WebSocketHandshakeHandler {
    @NotNull
    private final ObjectMapper mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples/ws", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.isAccessible(request) && HttpClientExampleServerManager.Companion.getInstance().isRequestScheduled();
    }

    public void disconnected(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
    }

    @NotNull
    protected MessageServer getMessageServer() {
        return (arg_0, arg_1) -> WebSocketClientHandler.getMessageServer$lambda$2(this, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMessageServer$lambda$2(WebSocketClientHandler this$0, Client client, CharSequence message) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(client instanceof WebSocketClient)) {
            return;
        }
        ObjectMapper objectMapper = this$0.mapper;
        CharSequence json$iv = message;
        boolean $i$f$fromJson = false;
        try {
            void $this$readValue$iv$iv;
            void $this$fromJson$iv;
            void var7_7 = $this$fromJson$iv;
            String content$iv$iv = ((Object)json$iv).toString();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<WebSocketRepeatMessage>(){});
        }
        catch (JacksonException e$iv) {
            JacksonException it = e$iv;
            boolean bl = false;
            HttpClientExamplesServerKt.access$send((WebSocketClient)client, "{\"error\": \"malformed JSON\"}");
            return;
        }
        WebSocketRepeatMessage webSocketRepeatMessage = (WebSocketRepeatMessage)object;
        String messageToRepeat = webSocketRepeatMessage.component1();
        Integer repeat = webSocketRepeatMessage.component2();
        char[] cArray = new char[]{'\n', '\\', '\"'};
        String string = StringUtil.escapeChars((String)messageToRepeat, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
        String escapedMessage = string;
        Integer n = repeat;
        int n2 = n != null ? n : 1;
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl = false;
            HttpClientExamplesServerKt.access$send((WebSocketClient)client, "{\"message\": \"" + escapedMessage + "\"}");
        }
    }
}

