/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/highlighting/HttpRequestAdditionalSyntaxHighlighterPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "getInfos", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpRequestBlock;", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "<init>", "(Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;Lcom/intellij/openapi/editor/Document;Lkotlin/jvm/functions/Function1;)V", "results", "", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "intellij.restClient"})
final class HttpRequestAdditionalSyntaxHighlighterPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final HttpRequestPsiFile file;
    @NotNull
    private final Function1<HttpRequestBlock, List<HighlightInfo>> getInfos;
    @NotNull
    private final List<HighlightInfo> results;

    public HttpRequestAdditionalSyntaxHighlighterPass(@NotNull HttpRequestPsiFile file, @NotNull Document document, @NotNull Function1<? super HttpRequestBlock, ? extends List<? extends HighlightInfo>> getInfos) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(getInfos, (String)"getInfos");
        super(file.getProject(), document);
        this.file = file;
        this.getInfos = getInfos;
        this.results = new ArrayList();
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        HttpRequestBlock[] httpRequestBlockArray = HttpRequestPsiUtils.getRequestBlocks((PsiFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestBlockArray, (String)"getRequestBlocks(...)");
        for (HttpRequestBlock requestBlock : ArraysKt.asSequence((Object[])httpRequestBlockArray)) {
            progress.checkCanceled();
            Collection collection = this.results;
            Intrinsics.checkNotNull((Object)requestBlock);
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)this.getInfos.invoke((Object)requestBlock)));
        }
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)this.results, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }
}

