/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.auth.digest;

import com.intellij.httpClient.postman.HttpUrl;
import com.intellij.httpClient.postman.converter.PostmanEnvironmentConverterKt;
import com.intellij.httpClient.postman.converter.auth.HttpClientAuth;
import com.intellij.httpClient.postman.converter.auth.PostmanAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.AlgorithmType;
import com.intellij.httpClient.postman.converter.auth.digest.DigestScriptProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.HeaderAttribute;
import com.intellij.httpClient.postman.converter.auth.digest.HeaderAttributes;
import com.intellij.httpClient.postman.converter.auth.digest.QopType;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpScript;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuthAttribute;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0014H\u0002\u001a.\u0010\u0015\u001a\u00020\u00142\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a2\u0010\u0017\u001a\u00020\u00182\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u00012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0001H\u0002\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"ALGORITHM", "", "REALM", "NONCE", "URI", "QOP", "OPAQUE", "NONCE_COUNT", "CLIENT_NONCE", "METHOD", "RESPONSE", "getDigestAuth", "Lcom/intellij/httpClient/postman/converter/auth/HttpClientAuth;", "attributes", "", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanAuthAttribute;", "method", "url", "Lcom/intellij/httpClient/postman/HttpUrl;", "buildHeaderValue", "Lcom/intellij/httpClient/postman/converter/auth/digest/HeaderAttributes;", "buildHeaderAttributes", "", "retrieveOrAsEnvVariable", "Lcom/intellij/httpClient/postman/converter/auth/digest/HeaderAttribute;", "key", "headerKeyName", "toAlgorithmType", "Lcom/intellij/httpClient/postman/converter/auth/digest/AlgorithmType;", "toQopType", "Lcom/intellij/httpClient/postman/converter/auth/digest/QopType;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nDigestAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestAuthProvider.kt\ncom/intellij/httpClient/postman/converter/auth/digest/DigestAuthProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1498#2:155\n1528#2,3:156\n1531#2,3:166\n1246#2,4:171\n381#3,7:159\n462#3:169\n412#3:170\n1#4:175\n*S KotlinDebug\n*F\n+ 1 DigestAuthProvider.kt\ncom/intellij/httpClient/postman/converter/auth/digest/DigestAuthProviderKt\n*L\n26#1:155\n26#1:156,3\n26#1:166,3\n27#1:171,4\n26#1:159,7\n27#1:169\n27#1:170\n*E\n"})
public final class DigestAuthProviderKt {
    @NotNull
    private static final String ALGORITHM = "algorithm";
    @NotNull
    private static final String REALM = "realm";
    @NotNull
    private static final String NONCE = "nonce";
    @NotNull
    private static final String URI = "uri";
    @NotNull
    private static final String QOP = "qop";
    @NotNull
    private static final String OPAQUE = "opaque";
    @NotNull
    private static final String NONCE_COUNT = "nonceCount";
    @NotNull
    private static final String CLIENT_NONCE = "clientNonce";
    @NotNull
    private static final String METHOD = "method";
    @NotNull
    private static final String RESPONSE = "response";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpClientAuth getDigestAuth(@NotNull List<PostmanAuthAttribute> attributes, @NotNull String method, @NotNull HttpUrl url) {
        Object object;
        String headerValue;
        block8: {
            String algorithmName;
            block7: {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Object object2;
                Object value$iv$iv$iv;
                Object key$iv$iv;
                Object it;
                void $this$groupByTo$iv$iv;
                Map $this$groupBy$iv;
                Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
                Intrinsics.checkNotNullParameter((Object)method, (String)METHOD);
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Iterable iterable = attributes;
                boolean $i$f$groupBy = false;
                void var6_6 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    void it2;
                    Object object3;
                    it = (PostmanAuthAttribute)element$iv$iv;
                    boolean $i$a$-groupBy-DigestAuthProviderKt$getDigestAuth$attributesByName$32 = false;
                    key$iv$iv = it.getKey();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object3;
                    PostmanAuthAttribute $i$a$-groupBy-DigestAuthProviderKt$getDigestAuth$attributesByName$32 = (PostmanAuthAttribute)element$iv$iv;
                    object2 = list$iv$iv;
                    boolean bl = false;
                    Object object4 = it2.getValue();
                    object2.add(object4 instanceof String ? (String)object4 : null);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$mapValues = false;
                $this$groupByTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it3;
                    void it$iv$iv;
                    key$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    object2 = map2;
                    boolean bl2 = false;
                    String string = (String)CollectionsKt.firstOrNull((List)((List)it3.getValue()));
                    object2.put(k, string);
                }
                Map attributesByName = destination$iv$iv;
                HeaderAttributes headerAttributes = DigestAuthProviderKt.buildHeaderAttributes(attributesByName, method, url);
                headerValue = DigestAuthProviderKt.buildHeaderValue(headerAttributes);
                algorithmName = headerAttributes.getAlgorithm().getValue();
                AlgorithmType algorithmType = DigestAuthProviderKt.toAlgorithmType(algorithmName);
                object = algorithmType;
                if (object == null) break block7;
                it = object;
                boolean bl = false;
                HttpScript httpScript = DigestScriptProviderKt.buildPreScript(headerAttributes, (AlgorithmType)((Object)it));
                object = httpScript;
                if (httpScript != null) break block8;
            }
            object = new HttpScript(CollectionsKt.listOf((Object)("algorithm=" + algorithmName + " is not supported")), false, false);
        }
        Object preScript = object;
        return new HttpClientAuth.HeaderAuth(PostmanAuthProviderKt.generateAuthHeader(headerValue, (HttpScript)preScript), null);
    }

    private static final String buildHeaderValue(HeaderAttributes attributes) {
        HeaderAttribute qop = attributes.getQop();
        List headers2 = new ArrayList();
        headers2.add(attributes.getUsername());
        headers2.add(attributes.getRealm());
        headers2.add(attributes.getNonce());
        headers2.add(attributes.getDigestURI());
        headers2.add(attributes.getAlgorithm());
        QopType qopType = DigestAuthProviderKt.toQopType(qop);
        if (qopType == QopType.AUTH || qopType == QopType.AUTH_INT) {
            headers2.add(attributes.getQop());
            headers2.add(attributes.getNonceCount());
            headers2.add(attributes.getClientNonce());
        }
        headers2.add(attributes.getResponse());
        if (((CharSequence)attributes.getOpaque().getValue()).length() > 0) {
            headers2.add(attributes.getOpaque());
        }
        return CollectionsKt.joinToString$default((Iterable)headers2, (CharSequence)", ", (CharSequence)"Digest ", null, (int)0, null, DigestAuthProviderKt::buildHeaderValue$lambda$4, (int)28, null);
    }

    private static final HeaderAttributes buildHeaderAttributes(Map<String, String> attributes, String method, HttpUrl url) {
        Object object;
        String fullUrl = url.toFullUrl(false);
        try {
            String path = new URL(fullUrl).getPath();
            Intrinsics.checkNotNull((Object)path);
            object = url.copy(path).toFullUrl(false);
        }
        catch (Exception e) {
            object = fullUrl;
        }
        String path = object;
        object = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, "username", null, 4, null);
        HeaderAttribute headerAttribute = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, "password", null, 4, null);
        HeaderAttribute headerAttribute2 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, REALM, null, 4, null);
        HeaderAttribute headerAttribute3 = new HeaderAttribute(METHOD, method);
        HeaderAttribute headerAttribute4 = new HeaderAttribute(URI, path);
        HeaderAttribute headerAttribute5 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, NONCE, null, 4, null);
        HeaderAttribute headerAttribute6 = DigestAuthProviderKt.retrieveOrAsEnvVariable(attributes, NONCE_COUNT, "nc");
        HeaderAttribute headerAttribute7 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, QOP, null, 4, null);
        HeaderAttribute headerAttribute8 = DigestAuthProviderKt.retrieveOrAsEnvVariable(attributes, CLIENT_NONCE, "cnonce");
        HeaderAttribute headerAttribute9 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, OPAQUE, null, 4, null);
        HeaderAttribute headerAttribute10 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, ALGORITHM, null, 4, null);
        HeaderAttribute headerAttribute11 = DigestAuthProviderKt.retrieveOrAsEnvVariable$default(attributes, RESPONSE, null, 4, null);
        return new HeaderAttributes((HeaderAttribute)object, headerAttribute, headerAttribute2, headerAttribute3, headerAttribute4, headerAttribute5, headerAttribute7, headerAttribute10, headerAttribute6, headerAttribute8, headerAttribute9, headerAttribute11);
    }

    private static final HeaderAttribute retrieveOrAsEnvVariable(Map<String, String> attributes, String key, String headerKeyName) {
        String string;
        String attributeValue;
        String string2 = attributes.get(key);
        if (string2 == null) {
            string2 = attributeValue = PostmanEnvironmentConverterKt.toEnvVariable(key);
        }
        if ((string = headerKeyName) == null) {
            string = key;
        }
        String keyName = string;
        return new HeaderAttribute(keyName, attributeValue);
    }

    static /* synthetic */ HeaderAttribute retrieveOrAsEnvVariable$default(Map map2, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return DigestAuthProviderKt.retrieveOrAsEnvVariable(map2, string, string2);
    }

    private static final AlgorithmType toAlgorithmType(String $this$toAlgorithmType) {
        return switch ($this$toAlgorithmType) {
            case "SHA-256" -> AlgorithmType.SHA256;
            case "MD5" -> AlgorithmType.MD5;
            case "MD5-sess" -> AlgorithmType.MD5_SESS;
            case "SHA-256-sess" -> AlgorithmType.SHA256_SESS;
            default -> null;
        };
    }

    @Nullable
    public static final QopType toQopType(@NotNull HeaderAttribute $this$toQopType) {
        Intrinsics.checkNotNullParameter((Object)$this$toQopType, (String)"<this>");
        String string = $this$toQopType.getValue();
        return Intrinsics.areEqual((Object)string, (Object)"auth") ? QopType.AUTH : (Intrinsics.areEqual((Object)string, (Object)"auth-int") ? QopType.AUTH_INT : null);
    }

    private static final CharSequence buildHeaderValue$lambda$4(HeaderAttribute it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }
}

