/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ArrayIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayIteratorPrototypeBuiltins();

    protected ArrayIteratorPrototypeBuiltins() {
        super(JSArray.ITERATOR_PROTOTYPE_NAME, ArrayIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return ArrayIteratorPrototypeBuiltinsFactory.ArrayIteratorNextNodeGen.create(context, builtin, ArrayIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayIteratorPrototype implements BuiltinEnum<ArrayIteratorPrototype>
    {
        next(0);

        private final int length;

        private ArrayIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class ArrayIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private HasHiddenKeyCacheNode isArrayIteratorNode = HasHiddenKeyCacheNode.create(JSArray.ARRAY_ITERATION_KIND_ID);
        @Node.Child
        private PropertyGetNode getIteratedObjectNode;
        @Node.Child
        private PropertyGetNode getNextIndexNode;
        @Node.Child
        private PropertyGetNode getIterationKindNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;

        public ArrayIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratedObjectNode = PropertyGetNode.createGetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.getNextIndexNode = PropertyGetNode.createGetHidden(JSRuntime.ITERATOR_NEXT_INDEX, context);
            this.getIterationKindNode = PropertyGetNode.createGetHidden(JSArray.ARRAY_ITERATION_KIND_ID, context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSRuntime.ITERATOR_NEXT_INDEX, context);
        }

        @Specialization(guards={"isArrayIterator(iterator)"})
        protected JSDynamicObject doArrayIterator(VirtualFrame frame, JSDynamicObject iterator, @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResultObjectNode, @Cached(value="create(getContext())") JSGetLengthNode getLengthNode, @Cached(value="create(getContext())") ReadElementNode readElementNode, @Cached(inline=true) LongToIntOrDoubleNode toJSIndex, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile useAfterCloseBranch, @Cached InlinedConditionProfile isTypedArrayProfile) {
            Object result2;
            long length2;
            Object array = this.getIteratedObjectNode.getValue(iterator);
            if (array == Undefined.instance) {
                useAfterCloseBranch.enter(this);
                return createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            long index = this.getNextIndex(iterator);
            int itemKind = this.getIterationKind(iterator);
            if (isTypedArrayProfile.profile(this, JSArrayBufferView.isJSArrayBufferView(array))) {
                JSTypedArrayObject typedArray = (JSTypedArrayObject)array;
                if (JSArrayBufferView.hasDetachedBuffer(typedArray, this.getContext())) {
                    errorBranch.enter(this);
                    throw Errors.createTypeError("Cannot perform Array Iterator.prototype.next on a detached ArrayBuffer");
                }
                length2 = JSArrayBufferView.typedArrayGetLength(typedArray);
            } else {
                length2 = getLengthNode.executeLong(array);
            }
            if (index >= length2) {
                this.setIteratedObjectNode.setValue(iterator, Undefined.instance);
                return createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            this.setNextIndexNode.setValue(iterator, index + 1L);
            if (itemKind == 1) {
                return createIterResultObjectNode.execute(frame, toJSIndex.execute(this, index), false);
            }
            Object elementValue = readElementNode.executeWithTargetAndIndex(array, index);
            if (itemKind == 2) {
                result2 = elementValue;
            } else {
                assert (itemKind == 3);
                result2 = JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{toJSIndex.execute(this, index), elementValue});
            }
            return createIterResultObjectNode.execute(frame, result2, false);
        }

        @Fallback
        protected JSDynamicObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not an Array Iterator");
        }

        protected final boolean isArrayIterator(Object thisObj) {
            return this.isArrayIteratorNode.executeHasHiddenKey(thisObj);
        }

        private long getNextIndex(JSDynamicObject iterator) {
            try {
                return this.getNextIndexNode.getValueLong(iterator);
            }
            catch (UnexpectedResultException e) {
                throw Errors.shouldNotReachHere();
            }
        }

        private int getIterationKind(JSDynamicObject iterator) {
            try {
                return this.getIterationKindNode.getValueInt(iterator);
            }
            catch (UnexpectedResultException e) {
                throw Errors.shouldNotReachHere();
            }
        }
    }
}

