/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.ForInIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.HasOnlyShapePropertiesNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.ForInIterator;
import java.util.List;

public final class ForInIteratorPrototypeBuiltins
extends JSBuiltinsContainer.Switch {
    public static final JSBuiltinsContainer BUILTINS = new ForInIteratorPrototypeBuiltins();

    protected ForInIteratorPrototypeBuiltins() {
        super(JSFunction.FOR_IN_ITERATOR_PROTOYPE_NAME);
        this.defineFunction(Strings.NEXT, 0);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
        if (Strings.equals(Strings.NEXT, builtin.getName())) {
            return ForInIteratorPrototypeBuiltinsFactory.ForInIteratorPrototypeNextNodeGen.create(context, builtin, ForInIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
        }
        return null;
    }

    public static abstract class ForInIteratorPrototypeNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private PropertyGetNode getIteratorNode;
        @Node.Child
        private GetPrototypeNode getPrototypeNode;
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode;
        private static final Object DONE = null;
        private static final int MAX_PROTO_DEPTH = 1000;

        public ForInIteratorPrototypeNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
            this.getIteratorNode = PropertyGetNode.createGetHidden(JSRuntime.FOR_IN_ITERATOR_ID, context);
            this.getPrototypeNode = GetPrototypeNode.create();
            this.getOwnPropertyNode = JSGetOwnPropertyNode.create();
        }

        @Specialization
        public JSDynamicObject next(VirtualFrame frame, Object target, @Cached InlinedConditionProfile valuesProfile, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile growProfile, @Cached InlinedConditionProfile fastOwnKeysProfile, @Cached InlinedConditionProfile sameShapeProfile, @Cached ListGetNode listGet, @Cached ListSizeNode listSize, @Cached HasOnlyShapePropertiesNode hasOnlyShapePropertiesNode) {
            boolean done;
            Object iteratorValue = this.getIteratorNode.getValue(target);
            if (iteratorValue == Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorIncompatibleReceiver(target);
            }
            ForInIterator state = (ForInIterator)iteratorValue;
            Object nextValue = this.findNext(state, errorBranch, growProfile, fastOwnKeysProfile, sameShapeProfile, listGet, listSize, hasOnlyShapePropertiesNode);
            boolean bl = done = nextValue == DONE;
            if (done) {
                nextValue = Undefined.instance;
            } else if (valuesProfile.profile(this, state.iterateValues)) {
                nextValue = JSObject.get(state.object, nextValue);
            } else assert (JSGuards.isString(nextValue));
            return this.createIterResultObjectNode.execute(frame, nextValue, done);
        }

        private Object findNext(ForInIterator state, InlinedBranchProfile errorBranch, InlinedBranchProfile growProfile, InlinedConditionProfile fastOwnKeysProfile, InlinedConditionProfile sameShapeProfile, ListGetNode listGet, ListSizeNode listSize, HasOnlyShapePropertiesNode hasOnlyShapePropertiesNode) {
            while (true) {
                JSDynamicObject object = state.object;
                if (!state.objectWasVisited) {
                    int size;
                    List<Object> list2;
                    boolean fastOwnKeys;
                    JSClass jsclass = JSObject.getJSClass(object);
                    Shape objectShape = object.getShape();
                    if (fastOwnKeysProfile.profile(this, hasOnlyShapePropertiesNode.execute(object, jsclass))) {
                        fastOwnKeys = true;
                        list2 = JSShape.getPropertiesIfHasEnumerablePropertyNames(objectShape);
                        size = list2.size();
                    } else {
                        fastOwnKeys = false;
                        list2 = jsclass.ownPropertyKeys(object);
                        size = listSize.execute(list2);
                    }
                    state.objectShape = objectShape;
                    state.remainingKeys = list2;
                    state.remainingKeysSize = size;
                    state.remainingKeysIndex = 0;
                    state.fastOwnKeys = fastOwnKeys;
                    state.objectWasVisited = true;
                }
                assert (state.remainingKeysSize == state.remainingKeys.size());
                while (state.remainingKeysIndex < state.remainingKeysSize) {
                    PropertyDescriptor desc;
                    Object next;
                    Object key;
                    if (!JSGuards.isString(key = ForInIteratorPrototypeNextNode.getKey(next = listGet.execute(state.remainingKeys, state.remainingKeysIndex++))) || state.isVisitedKey(key)) continue;
                    if (fastOwnKeysProfile.profile(this, state.fastOwnKeys && next instanceof Property)) {
                        if (sameShapeProfile.profile(this, state.objectShape == object.getShape())) {
                            if (!JSProperty.isEnumerable((Property)next)) continue;
                            return key;
                        }
                        ForInIteratorPrototypeNextNode.addPreviouslyVisitedKeys(state);
                        state.fastOwnKeys = false;
                    }
                    if ((desc = this.getOwnPropertyNode.execute(object, key)) == null) continue;
                    state.addVisitedKey(key);
                    if (!desc.getEnumerable()) continue;
                    return key;
                }
                JSDynamicObject proto = this.getPrototypeNode.execute(object);
                if (ForInIteratorPrototypeNextNode.tryFastForwardImmutablePrototype(proto, hasOnlyShapePropertiesNode)) {
                    proto = Null.instance;
                }
                state.object = proto;
                state.objectWasVisited = false;
                if (proto == Null.instance) {
                    return DONE;
                }
                if (fastOwnKeysProfile.profile(this, state.fastOwnKeys)) {
                    state.addVisitedShape(state.objectShape, this, growProfile);
                    continue;
                }
                if (++state.protoDepth > 1000) break;
            }
            errorBranch.enter(this);
            throw Errors.createRangeErrorStackOverflow();
        }

        private static Object getKey(Object next) {
            return next instanceof Property ? ((Property)next).getKey() : next;
        }

        @CompilerDirectives.TruffleBoundary
        private static void addPreviouslyVisitedKeys(ForInIterator state) {
            for (int i = 0; i < state.remainingKeysIndex - 1; ++i) {
                state.addVisitedKey(ForInIteratorPrototypeNextNode.getKey(state.remainingKeys.get(i)));
            }
        }

        private static boolean tryFastForwardImmutablePrototype(JSDynamicObject proto, HasOnlyShapePropertiesNode hasOnlyShapePropertiesNode) {
            if (proto == Null.instance) {
                return false;
            }
            JSClass jsclass = JSObject.getJSClass(proto);
            if (jsclass == JSObjectPrototype.INSTANCE && hasOnlyShapePropertiesNode.execute(proto, jsclass) && JSShape.getEnumerablePropertyNames(proto.getShape()).isEmpty()) {
                assert (JSObject.getPrototype(proto) == Null.instance);
                return true;
            }
            return false;
        }
    }

    public static enum EnumerateIteratorPrototype implements BuiltinEnum<EnumerateIteratorPrototype>
    {
        next(0);

        private final int length;

        private EnumerateIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

