/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.polyglot.PolyglotInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotToHostNode;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

@GenerateInline(value=false)
abstract class PolyglotExecuteNode
extends Node {
    private static final Object[] EMPTY = new Object[0];

    PolyglotExecuteNode() {
    }

    public final Object execute(PolyglotLanguageContext languageContext, Object function, Object functionArgsObject) {
        return this.execute(languageContext, function, functionArgsObject, Object.class, (Type)((Object)Object.class), Object.class, null);
    }

    public final Object execute(PolyglotLanguageContext languageContext, Object function, Object functionArgsObject, Class<?> resultClass, Type resultType, Class<?> paramClass, Type paramType) {
        Object[] argsArray = paramType != null && paramClass.isArray() ? (functionArgsObject == null ? EMPTY : (paramClass.getComponentType().isPrimitive() && !(functionArgsObject instanceof Object[]) ? PolyglotExecuteNode.copyToObjectArray(paramClass.cast(functionArgsObject)) : (Object[])functionArgsObject)) : (paramType == null && functionArgsObject == null ? EMPTY : (paramType == null && functionArgsObject instanceof Object[] ? (Object[])functionArgsObject : new Object[]{functionArgsObject}));
        return this.executeImpl(languageContext, function, argsArray, resultClass, resultType);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] copyToObjectArray(Object functionArgs) {
        assert (functionArgs.getClass().isArray());
        int length2 = Array.getLength(functionArgs);
        Object[] copy = new Object[length2];
        for (int i = 0; i < length2; ++i) {
            copy[i] = Array.get(functionArgs, 0);
        }
        return copy;
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3, Class<?> var4, Type var5);

    @Specialization(limit="5")
    static Object doCached(PolyglotLanguageContext languageContext, Object function, Object[] argsArray, Class<?> resultClass, Type resultType, @Bind(value="this") Node node, @CachedLibrary(value="function") InteropLibrary interop, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuests, @Cached PolyglotToHostNode toHost, @Cached InlinedConditionProfile executableCondition, @Cached InlinedConditionProfile instantiableCondition, @Cached InlinedBranchProfile unsupportedError, @Cached InlinedBranchProfile arityError, @Cached InlinedBranchProfile unsupportedArgumentError) {
        Object result2;
        block8: {
            Object[] functionArgs = toGuests.execute(node, languageContext, argsArray);
            boolean executable = executableCondition.profile(node, interop.isExecutable(function));
            try {
                if (executable) {
                    result2 = interop.execute(function, functionArgs);
                    break block8;
                }
                if (instantiableCondition.profile(node, interop.isInstantiable(function))) {
                    result2 = interop.instantiate(function, functionArgs);
                    break block8;
                }
                throw PolyglotInteropErrors.executeUnsupported(languageContext, function);
            }
            catch (UnsupportedTypeException e) {
                unsupportedArgumentError.enter(node);
                if (executable) {
                    throw PolyglotInteropErrors.invalidExecuteArgumentType(languageContext, function, functionArgs);
                }
                throw PolyglotInteropErrors.invalidInstantiateArgumentType(languageContext, function, functionArgs);
            }
            catch (ArityException e) {
                arityError.enter(node);
                if (executable) {
                    throw PolyglotInteropErrors.invalidExecuteArity(languageContext, function, functionArgs, e.getExpectedMinArity(), e.getExpectedMaxArity(), e.getActualArity());
                }
                throw PolyglotInteropErrors.invalidInstantiateArity(languageContext, function, functionArgs, e.getExpectedMinArity(), e.getExpectedMaxArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                unsupportedError.enter(node);
                throw PolyglotInteropErrors.executeUnsupported(languageContext, function);
            }
        }
        return toHost.execute(node, languageContext, result2, resultClass, resultType);
    }
}

