/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringNodeGen;

@GenerateUncached
public abstract class ExpectStringNode
extends Node {
    public abstract TruffleString execute(Object var1, TruffleString.Encoding var2);

    @Specialization
    static TruffleString doString(String input, TruffleString.Encoding encoding, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute(input, encoding);
    }

    @Specialization
    static TruffleString doTString(TruffleString input, TruffleString.Encoding encoding) {
        return input;
    }

    @Specialization(guards={"inputs.isString(input)"}, limit="2")
    static TruffleString doBoxedString(Object input, TruffleString.Encoding encoding, @CachedLibrary(value="input") InteropLibrary inputs) {
        try {
            return inputs.asTruffleString(input);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere("unexpected string type passed to TRegex: " + input.getClass());
        }
    }

    public static ExpectStringNode create() {
        return ExpectStringNodeGen.create();
    }
}

