/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.codeInsight;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.codeInsight.DbtModelReferenceBase;
import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.tags.Jinja2FunctionCall;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.FileSearchUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dbt/codeInsight/DbtModelRefReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "DbtModelRefReference", "Companion", "intellij.dbt"})
public final class DbtModelRefReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PatternCondition<Jinja2FunctionCall> isReferenceFunction = (PatternCondition)new PatternCondition<Jinja2FunctionCall>(){

        public boolean accepts(Jinja2FunctionCall expression, ProcessingContext context) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            PsiElement psiElement = expression.getCallee();
            return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)"ref");
        }
    };
    @NotNull
    private static final String REF_FUNCTION_NAME = "ref";
    @NotNull
    private static final String MODELS_DIR = "models";
    @NotNull
    private static final String SEEDS_DIR = "seeds";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element.getContainingFile()));
        if (module == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Module module2 = module;
        if (!DbtUtils.Companion.isDbtModule(module2)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Jinja2StringLiteral jinja2StringLiteral = (Jinja2StringLiteral)PsiTreeUtil.findChildOfType((PsiElement)element, Jinja2StringLiteral.class);
        if (jinja2StringLiteral == null) {
            return new PsiReference[0];
        }
        Jinja2StringLiteral modelNameStringLiteral = jinja2StringLiteral;
        PsiReference[] psiReferenceArray = new PsiReference[]{new DbtModelRefReference((Jinja2FunctionCall)element, modelNameStringLiteral)};
        return psiReferenceArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dbt/codeInsight/DbtModelRefReferenceProvider$Companion;", "", "<init>", "()V", "isReferenceFunction", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/jinja/tags/Jinja2FunctionCall;", "()Lcom/intellij/patterns/PatternCondition;", "getValueRangeInStringLiteral", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/annotations/NotNull;", "length", "", "REF_FUNCTION_NAME", "", "MODELS_DIR", "SEEDS_DIR", "intellij.dbt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PatternCondition<Jinja2FunctionCall> isReferenceFunction() {
            return isReferenceFunction;
        }

        private final TextRange getValueRangeInStringLiteral(int length) {
            TextRange textRange = TextRange.from((int)Math.min(5, length - 1), (int)Math.max(0, length - 2));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
            return textRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dbt/codeInsight/DbtModelRefReferenceProvider$DbtModelRefReference;", "Lcom/intellij/dbt/codeInsight/DbtModelReferenceBase;", "Lcom/intellij/jinja/tags/Jinja2FunctionCall;", "element", "modelNameStringLiteral", "Lcom/intellij/jinja/psi/Jinja2StringLiteral;", "<init>", "(Lcom/intellij/jinja/tags/Jinja2FunctionCall;Lcom/intellij/jinja/psi/Jinja2StringLiteral;)V", "isSoft", "", "findFileInDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "dir", "referenceModelFileName", "", "resolveInner", "Lcom/intellij/psi/PsiElement;", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.dbt"})
    @SourceDebugExtension(value={"SMAP\nDbtModelRefReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtModelRefReferenceProvider.kt\ncom/intellij/dbt/codeInsight/DbtModelRefReferenceProvider$DbtModelRefReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n774#2:91\n865#2,2:92\n1557#2:94\n1628#2,3:95\n1557#2:98\n1628#2,3:99\n1557#2:102\n1628#2,3:103\n1557#2:106\n1628#2,3:107\n37#3,2:110\n*S KotlinDebug\n*F\n+ 1 DbtModelRefReferenceProvider.kt\ncom/intellij/dbt/codeInsight/DbtModelRefReferenceProvider$DbtModelRefReference\n*L\n65#1:91\n65#1:92,2\n65#1:94\n65#1:95,3\n65#1:98\n65#1:99,3\n68#1:102\n68#1:103,3\n68#1:106\n68#1:107,3\n72#1:110,2\n*E\n"})
    public static final class DbtModelRefReference
    extends DbtModelReferenceBase<Jinja2FunctionCall> {
        @NotNull
        private final Jinja2StringLiteral modelNameStringLiteral;

        public DbtModelRefReference(@NotNull Jinja2FunctionCall element, @NotNull Jinja2StringLiteral modelNameStringLiteral) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)modelNameStringLiteral, (String)"modelNameStringLiteral");
            super((PsiElement)element, Companion.getValueRangeInStringLiteral(modelNameStringLiteral.getTextLength()));
            this.modelNameStringLiteral = modelNameStringLiteral;
        }

        public boolean isSoft() {
            return true;
        }

        private final VirtualFile findFileInDirectory(VirtualFile dir, String referenceModelFileName) {
            return (VirtualFile)FileSearchUtil.findFileRecursively((VirtualFile)dir, (String)referenceModelFileName, (int)Registry.Companion.intValue("dbt.models.max.depth.level", 10), (long)1000L).findFirst();
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String referenceModelFileName = this.modelNameStringLiteral.getStringValue() + ".sql";
            String referenceSeedModelFileName = this.modelNameStringLiteral.getStringValue() + ".csv";
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            VirtualFile virtualFile = DbtUtils.Companion.getDbtDirectory(module2);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile dbtDirectory = virtualFile;
            VirtualFile modelsDir = VirtualFileUtil.findDirectory((VirtualFile)dbtDirectory, (String)DbtModelRefReferenceProvider.MODELS_DIR);
            VirtualFile seedsDir = VirtualFileUtil.findDirectory((VirtualFile)dbtDirectory, (String)DbtModelRefReferenceProvider.SEEDS_DIR);
            VirtualFile virtualFile2 = this.findFileInDirectory(modelsDir, referenceModelFileName);
            if (virtualFile2 == null && (virtualFile2 = this.findFileInDirectory(seedsDir, referenceSeedModelFileName)) == null) {
                return null;
            }
            VirtualFile referenceModelFile = virtualFile2;
            Project project = ((Jinja2FunctionCall)this.getElement()).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return (PsiElement)VirtualFileUtil.findPsiFile((VirtualFile)referenceModelFile, (Project)project);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object[] getVariants() {
            Iterable $this$mapTo$iv$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Object it;
            Iterable $this$filterTo$iv$iv;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Module module2 = module;
            Iterable $this$filter$iv = DbtUtils.Companion.getAllModels(module2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)((Jinja2FunctionCall)this.getElement()).getContainingFile().getOriginalFile().getVirtualFile()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getNameWithoutExtension());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it).withTypeText(DbtBundle.message("dbt.completion.model.suffix", new Object[0])));
            }
            List allModelExceptCurrentFile = (List)destination$iv$iv;
            Iterable $this$map$iv2 = DbtUtils.Companion.getAllSeeds(module2);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                VirtualFile bl = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it2.getNameWithoutExtension());
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it2 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it2).withTypeText(DbtBundle.message("dbt.completion.seed.suffix", new Object[0])));
            }
            List seedLookupItems = (List)destination$iv$iv2;
            Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)allModelExceptCurrentFile, (Iterable)seedLookupItems);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Object[0]);
        }
    }
}

