/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.json.JsonUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonQualifiedNameProvider
implements QualifiedNameProvider {
    @Nullable
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        if (element == null) {
            JsonQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            JsonQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        return JsonQualifiedNameProvider.generateQualifiedName(element, JsonQualifiedNameKind.Qualified);
    }

    public static String generateQualifiedName(PsiElement element, JsonQualifiedNameKind qualifiedNameKind) {
        if (!(element instanceof JsonElement)) {
            return null;
        }
        JsonElement parentProperty = (JsonElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        StringBuilder builder = new StringBuilder();
        while (parentProperty != null) {
            if (parentProperty instanceof JsonProperty) {
                JsonProperty jsonProperty = (JsonProperty)parentProperty;
                String name = jsonProperty.getName();
                if (qualifiedNameKind == JsonQualifiedNameKind.JsonPointer) {
                    name = JsonPointerUtil.escapeForJsonPointer(name);
                }
                builder.insert(0, name);
                builder.insert(0, qualifiedNameKind == JsonQualifiedNameKind.JsonPointer ? "/" : ".");
            } else {
                int index = JsonUtil.getArrayIndexOfItem((PsiElement)(element instanceof JsonProperty ? element.getParent() : element));
                if (index == -1) {
                    return null;
                }
                builder.insert(0, qualifiedNameKind == JsonQualifiedNameKind.JsonPointer ? "/" + index : "[" + index + "]");
            }
            element = parentProperty;
            parentProperty = (JsonElement)PsiTreeUtil.getParentOfType((PsiElement)parentProperty, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        }
        if (builder.length() == 0) {
            return null;
        }
        if (builder.charAt(0) == '[') {
            builder.insert(0, "$");
        }
        return StringUtil.trimStart((String)builder.toString(), (String)".");
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            JsonQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JsonQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/navigation/JsonQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

