/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.statistics.MergeResultSource;
import com.intellij.diff.util.ThreeSide;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.JupyterLineNumberConverterSetter;
import com.intellij.jupyter.diff.util.JupyterTextMergeRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterMergeThreesideViewer;", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/ContentDiffRequest;", "mergeContext", "Lcom/intellij/diff/merge/MergeContext;", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "mergeViewer", "Lcom/intellij/diff/merge/TextMergeViewer;", "<init>", "(Lcom/intellij/diff/DiffContext;Lcom/intellij/diff/requests/ContentDiffRequest;Lcom/intellij/diff/merge/MergeContext;Lcom/intellij/diff/merge/TextMergeRequest;Lcom/intellij/diff/merge/TextMergeViewer;)V", "rediff", "", "trySync", "", "doFinishMerge", "result", "Lcom/intellij/diff/merge/MergeResult;", "source", "Lcom/intellij/diff/statistics/MergeResultSource;", "propagateChangesToJson", "paintEditor", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nJupyterMergeViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMergeViewer.kt\ncom/intellij/jupyter/diff/util/JupyterMergeThreesideViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1863#2,2:76\n*S KotlinDebug\n*F\n+ 1 JupyterMergeViewer.kt\ncom/intellij/jupyter/diff/util/JupyterMergeThreesideViewer\n*L\n40#1:76,2\n*E\n"})
public final class JupyterMergeThreesideViewer
extends MergeThreesideViewer {
    public JupyterMergeThreesideViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull MergeContext mergeContext, @NotNull TextMergeRequest mergeRequest, @NotNull TextMergeViewer mergeViewer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        Intrinsics.checkNotNullParameter((Object)mergeViewer, (String)"mergeViewer");
        super(context, request, mergeContext, mergeRequest, mergeViewer);
        this.myFoldingModel.setEnabled(false);
    }

    public void rediff(boolean trySync) {
        List list = this.getEditors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEditors(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx it = (EditorEx)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.paintEditor(it);
        }
        super.rediff(trySync);
    }

    protected void doFinishMerge(@NotNull MergeResult result, @NotNull MergeResultSource source) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (result != MergeResult.CANCEL) {
            this.propagateChangesToJson();
        }
        super.doFinishMerge(result, source);
    }

    private final void propagateChangesToJson() {
        TextMergeRequest textMergeRequest = this.myMergeRequest;
        Intrinsics.checkNotNullExpressionValue((Object)textMergeRequest, (String)"myMergeRequest");
        TextMergeRequest mergeRequest = textMergeRequest;
        JupyterTextMergeRequest cfr_ignored_0 = (JupyterTextMergeRequest)mergeRequest;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(((JupyterTextMergeRequest)mergeRequest).getJsonOutputContent().getDocument());
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.find(file);
        Intrinsics.checkNotNull((Object)backedNotebookVirtualFile);
        BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
        ActionsKt.runWriteAction(() -> JupyterMergeThreesideViewer.propagateChangesToJson$lambda$1(notebookVirtualFile));
        FileDocumentManager.getInstance().reloadFromDisk(((JupyterTextMergeRequest)mergeRequest).getJsonOutputContent().getDocument(), ((JupyterTextMergeRequest)mergeRequest).getProject());
    }

    private final void paintEditor(EditorEx editor) {
        JupyterLineNumberConverterSetter.Companion.getInstance().setConverterToEditor((Editor)editor);
        EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutterComponent = editorGutterComponentEx;
        gutterComponent.setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.SHOW);
        if (this.getEditorSide((Editor)editor) == ThreeSide.BASE) {
            gutterComponent.reserveRightFreePaintersAreaWidth((Disposable)this, 20);
        }
        gutterComponent.setPaintBackground(true);
        gutterComponent.revalidate();
    }

    private static final Unit propagateChangesToJson$lambda$1(BackedNotebookVirtualFile $notebookVirtualFile) {
        $notebookVirtualFile.flush();
        $notebookVirtualFile.getFile().refresh(false, false);
        return Unit.INSTANCE;
    }
}

