/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.database.settings.BytesLimitPerValueForm;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCopyProvider
implements CopyProvider {
    private final DataGrid myGrid;

    public GridCopyProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCopyProvider.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            GridCopyProvider.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(2);
        }
        DataExtractor extractor = this.createExtractor();
        String data = GridUtil.extractSelectedValuesForCopy(this.myGrid, extractor);
        boolean htmlNeeded = extractor.getFileExtension().contains("htm");
        Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
        CopyPasteManager.getInstance().setContents(this.createData((Transferable)content));
        if (this.truncatedDataCopied()) {
            this.showTruncatedDataCopiedWarning();
        }
        GridUtil.activeGridListener().onExtractToClipboardAction(this.myGrid);
    }

    private void showTruncatedDataCopiedWarning() {
        Pair<RelativePoint, Balloon.Position> position = GridUtil.getBestPositionForBalloon(this.myGrid);
        DataGridSettings settings = GridUtil.getSettings(this.myGrid);
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DataGridBundle.message((String)"popup.content.truncated.data.copied", (Object[])new Object[]{settings == null ? 0 : 1}), MessageType.WARNING, (HyperlinkListener)(settings == null ? null : new ChangeLimitHyperlinkListener(this.myGrid, settings))).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).setHideOnLinkClick(true).createBalloon();
        balloon.show((RelativePoint)position.first, (Balloon.Position)position.second);
    }

    private boolean truncatedDataCopied() {
        ModelIndexSet columnIndexes;
        GridModel model2;
        List columns;
        List<GridRow> rows2 = GridUtil.getSelectedGridRows(this.myGrid);
        return ContainerUtil.find(rows2, arg_0 -> GridCopyProvider.lambda$truncatedDataCopied$1(columns = (model2 = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumns(columnIndexes = this.myGrid.getSelectionModel().getSelectedColumns()), arg_0)) != null;
    }

    private static boolean isTruncated(@Nullable Object value) {
        return value instanceof LobInfo && ((LobInfo)value).isTruncated();
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(3);
        }
        return !this.myGrid.isEditing() && !this.myGrid.isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    private DataExtractor createExtractor() {
        ExtractorConfig config;
        SelectionModel selectionModel = this.myGrid.getSelectionModel();
        if (selectionModel.getSelectedRowCount() == 1 && selectionModel.getSelectedColumnCount() == 1) {
            DataExtractor dataExtractor = GridExtractorsUtilCore.getSingleValueExtractor((ObjectFormatter)this.myGrid.getObjectFormatter(), GridUtil.getConfigProvider(this.myGrid));
            if (dataExtractor == null) {
                GridCopyProvider.$$$reportNull$$$0(5);
            }
            return dataExtractor;
        }
        DataExtractorFactory extractorFactory = DataExtractorFactories.getExtractorFactory((CoreGrid)this.myGrid, GridUtil::suggestPlugin);
        DataExtractor extractor = extractorFactory.createExtractor(config = ExtractorsHelper.getInstance((CoreGrid)this.myGrid).createExtractorConfig((CoreGrid)this.myGrid, this.myGrid.getObjectFormatter()));
        extractor = extractor != null ? extractor : DataExtractorFactories.getDefault((CsvFormatsSettings)CsvSettings.getSettings()).createExtractor(config);
        DataExtractor dataExtractor = Objects.requireNonNull(extractor);
        if (dataExtractor == null) {
            GridCopyProvider.$$$reportNull$$$0(6);
        }
        return dataExtractor;
    }

    @NotNull
    private Transferable createData(@NotNull Transferable content) {
        if (content == null) {
            GridCopyProvider.$$$reportNull$$$0(7);
        }
        SelectionModel model2 = this.myGrid.getSelectionModel();
        ViewIndexSet rows2 = model2.getSelectedRows().toView((CoreGrid)this.myGrid);
        ViewIndexSet columns = model2.getSelectedColumns().toView((CoreGrid)this.myGrid);
        if (rows2.size() == 0 || columns.size() == 0) {
            Transferable transferable = content;
            if (transferable == null) {
                GridCopyProvider.$$$reportNull$$$0(8);
            }
            return transferable;
        }
        GridModel dataModel = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int minRow = GridUtil.min(rows2);
        int minColumn = GridUtil.min(columns);
        GridHelper helper = GridHelper.get(this.myGrid);
        ArrayList<DataTypeConversion.Builder> result = new ArrayList<DataTypeConversion.Builder>();
        for (ViewIndex row : rows2.asIterable()) {
            for (ViewIndex columnIdx : columns.asIterable()) {
                Object value = dataModel.getValueAt(row.toModel((CoreGrid)this.myGrid), columnIdx.toModel((CoreGrid)this.myGrid));
                GridColumn column = (GridColumn)this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx.toModel((CoreGrid)this.myGrid));
                result.add(helper.createDataTypeConversionBuilder().value(value instanceof ReservedCellValue ? null : value).firstColumn(Objects.requireNonNull(column)).firstRowIdx(row.asInteger()).firstColumnIdx(columnIdx.asInteger()).firstGrid((CoreGrid)this.myGrid));
            }
        }
        return new GridTransferableData(result, content, minRow, minColumn, rows2.size());
    }

    private static /* synthetic */ boolean lambda$truncatedDataCopied$1(List columns, GridRow row) {
        return ContainerUtil.find((Iterable)columns, column -> GridCopyProvider.isTruncated(column.getValue(row))) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridCopyProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridCopyProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class ChangeLimitHyperlinkListener
    implements HyperlinkListener {
        private final DataGrid myGrid;
        private final DataGridSettings mySettings;

        public ChangeLimitHyperlinkListener(@NotNull DataGrid grid, @NotNull DataGridSettings settings) {
            if (grid == null) {
                ChangeLimitHyperlinkListener.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ChangeLimitHyperlinkListener.$$$reportNull$$$0(1);
            }
            this.myGrid = grid;
            this.mySettings = settings;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "change_limit".equals(e.getDescription())) {
                new ChangeBytesLimitPerValueDialogWrapper(this.myGrid.getProject(), this.myGrid, this.mySettings).show();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/GridCopyProvider$ChangeLimitHyperlinkListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ChangeBytesLimitPerValueDialogWrapper
    extends DialogWrapper {
        private final BytesLimitPerValueForm myForm;
        private final DataGrid myGrid;
        private final DataGridSettings mySettings;
        private final ApplyAction myApplyAction;

        protected ChangeBytesLimitPerValueDialogWrapper(@Nullable Project project, @NotNull DataGrid grid, @NotNull DataGridSettings settings) {
            if (grid == null) {
                ChangeBytesLimitPerValueDialogWrapper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ChangeBytesLimitPerValueDialogWrapper.$$$reportNull$$$0(1);
            }
            super(project, (Component)grid.getPanel().getComponent(), false, DialogWrapper.IdeModalityType.IDE);
            this.myForm = new BytesLimitPerValueForm();
            this.myApplyAction = new ApplyAction();
            this.myGrid = grid;
            this.mySettings = settings;
            this.setTitle(DataGridBundle.message((String)"dialog.title.change.bytes.limit", (Object[])new Object[0]));
            this.setOKButtonText(DataGridBundle.message((String)"dialog.ok.text.set.and.reload", (Object[])new Object[0]));
            this.initListeners();
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myForm.getField();
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myApplyAction};
            if (actionArray == null) {
                ChangeBytesLimitPerValueDialogWrapper.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private void initListeners() {
            this.myForm.getField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateActions();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateActions();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateActions();
                }
            });
        }

        private void updateActions() {
            this.getOKAction().setEnabled(this.isOKActionEnabled());
            this.myApplyAction.setEnabled(this.isOKActionEnabled() && this.myForm.isModified(this.mySettings));
        }

        public boolean isOKActionEnabled() {
            try {
                this.myForm.getField().validateContent();
                return true;
            }
            catch (ConfigurationException ignored) {
                return false;
            }
        }

        @NotNull
        protected JComponent createCenterPanel() {
            this.myForm.reset(this.mySettings);
            JPanel jPanel = this.myForm.getPanel();
            if (jPanel == null) {
                ChangeBytesLimitPerValueDialogWrapper.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        protected void doOKAction() {
            super.doOKAction();
            this.myForm.apply(this.mySettings);
            this.mySettings.fireChanged();
            GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid));
            this.myGrid.getDataHookup().getLoader().reloadCurrentPage(source);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/GridCopyProvider$ChangeBytesLimitPerValueDialogWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/GridCopyProvider$ChangeBytesLimitPerValueDialogWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCenterPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        private class ApplyAction
        extends DialogWrapper.DialogWrapperAction {
            ApplyAction() {
                super((DialogWrapper)ChangeBytesLimitPerValueDialogWrapper.this, DataGridBundle.message((String)"action.ApplyAction.text", (Object[])new Object[0]));
            }

            protected void doAction(ActionEvent e) {
                ChangeBytesLimitPerValueDialogWrapper.this.myForm.apply(ChangeBytesLimitPerValueDialogWrapper.this.mySettings);
                ChangeBytesLimitPerValueDialogWrapper.this.mySettings.fireChanged();
                ChangeBytesLimitPerValueDialogWrapper.this.updateActions();
            }
        }
    }
}

