/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DefaultTemporalEditorFactory;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.ui.basic.BasicCalendarPaneUI;
import com.michaelbaranov.microba.calendar.ui.basic.CalendarGridPanel;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.sql.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDateEditorFactory
extends DefaultTemporalEditorFactory {
    private static final Logger LOG = Logger.getInstance(DefaultDateEditorFactory.class);

    @Override
    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(2);
        }
        GridColumn c = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column));
        Formatter formatter = (Formatter)FormatterCreator.get((CoreGrid)grid).create(FormatterCreator.getDateKey((GridColumn)c, null, (FormatsCache)FormatsCache.get((CoreGrid)grid)));
        if (formatter == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(3);
        }
        return formatter;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(5);
        }
        if (column == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(6);
        }
        return GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column) == 91 ? 1 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(9);
        }
        GridCellEditorFactory.ValueParser parser = super.getValueParser(grid, rowIdx, columnIdx);
        GridCellEditorFactory.ValueParser valueParser = (text, document) -> {
            Object v = parser.parse(text, document);
            return v instanceof java.util.Date ? new Date(((java.util.Date)v).getTime()) : v;
        };
        if (valueParser == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(10);
        }
        return valueParser;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<GridRow> row, final @NotNull ModelIndex<GridColumn> column, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(11);
        }
        if (grid == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(12);
        }
        if (format == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(13);
        }
        if (row == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(14);
        }
        if (column == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(15);
        }
        if (valueParser == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(16);
        }
        if (valueFormatter == null) {
            DefaultDateEditorFactory.$$$reportNull$$$0(17);
        }
        return new FormatBasedGridCellEditor.WithBrowseButton<CalendarPane, java.util.Date>(project, grid, format, nullValue, initiator, row, column, java.util.Date.class, provider, valueParser, valueFormatter, (GridCellEditorFactory)this){

            @Override
            protected void configurePopup(@NotNull JBPopup popup, @NotNull CalendarPane component) {
                if (popup == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (component == null) {
                    1.$$$reportNull$$$0(1);
                }
                component.addActionListener(e -> {
                    if (popup.isDisposed()) {
                        return;
                    }
                    this.processDate(component, this.onAccept(popup), () -> component.requestFocus());
                });
            }

            @Override
            protected java.util.Date getValue(CalendarPane component) {
                return component.getDate() == null ? new java.util.Date() : component.getDate();
            }

            @Override
            @NotNull
            protected CalendarPane getPopupComponent() {
                java.util.Date date = DataGridFormattersUtilCore.getDateFrom((Object)this.getValue(), (CoreGrid)grid, (ModelIndex)column, (FormatsCache)FormatsCache.get((CoreGrid)grid), (FormatterCreator)FormatterCreator.get((CoreGrid)grid));
                java.util.Date initialDate = DataGridFormattersUtilCore.getBoundedValue((Object)date, (ModelIndex)column, (CoreGrid)grid);
                return new MyCalendarPane(initialDate, this.getNullValue() != null);
            }

            @Override
            @NotNull
            protected JComponent getPreferredFocusedComponent(@NotNull CalendarPane popupComponent) {
                if (popupComponent == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (popupComponent.getComponentCount() != 5) {
                    LOG.warn("Unexpected number of components on calendar pane. Expected 5, actual: " + popupComponent.getComponentCount() + ". Initial focus won't be set to month combobox.");
                    CalendarPane calendarPane = popupComponent;
                    if (calendarPane == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return calendarPane;
                }
                JPanel calendarPanel = (JPanel)ObjectUtils.tryCast((Object)popupComponent.getComponent(0), JPanel.class);
                if (calendarPanel == null) {
                    LOG.warn("ModernCalendarPanel is not found on calendar pane. Initial focus won't be set to month combobox.");
                    CalendarPane calendarPane = popupComponent;
                    if (calendarPane == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return calendarPane;
                }
                JComponent jComponent = Objects.requireNonNull((JComponent)ObjectUtils.tryCast((Object)calendarPanel.getComponent(0), JComponent.class));
                if (jComponent == null) {
                    1.$$$reportNull$$$0(5);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "popup";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "popupComponent";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreferredFocusedComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "configurePopup";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getPreferredFocusedComponent";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatInner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFormatInner";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10 -> new IllegalStateException(string);
        };
    }

    private static class MyCalendarPane
    extends CalendarPane {
        private boolean mySettingDate;

        MyCalendarPane(java.util.Date initialDate, boolean showNoneButton) {
            super(initialDate, 0, Locale.getDefault(), DataGridFormattersUtilCore.getDefaultTimeZone());
            this.setFocusLostBehavior(3);
            this.setShowNoneButton(showNoneButton);
            this.setShowNumberOfWeek(true);
            this.setShowTodayButton(true);
            this.setStripTime(false);
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            this.setPaintBorderForFocusedButtons();
        }

        private void setPaintBorderForFocusedButtons() {
            JPanel auxPanel = (JPanel)ObjectUtils.tryCast((Object)this.getComponent(4), JPanel.class);
            if (auxPanel == null) {
                LOG.warn("AuxPanel is not found on calendar pane. Focused buttons won't be highlighted");
                return;
            }
            JButton todayButton = (JButton)ObjectUtils.tryCast((Object)auxPanel.getComponent(0), JButton.class);
            JButton noneButton = (JButton)ObjectUtils.tryCast((Object)auxPanel.getComponent(1), JButton.class);
            if (todayButton == null || noneButton == null) {
                return;
            }
            MyCalendarPane.setPaintBorderForFocusedButtons(todayButton);
            MyCalendarPane.setPaintBorderForFocusedButtons(noneButton);
        }

        private static void setPaintBorderForFocusedButtons(final @NotNull JButton button) {
            if (button == null) {
                MyCalendarPane.$$$reportNull$$$0(0);
            }
            button.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    button.setBorderPainted(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    button.setBorderPainted(false);
                }
            });
        }

        public void updateUI() {
            this.setUI((ComponentUI)new BasicCalendarPaneUI(){

                protected void createNestedComponents() {
                    super.createNestedComponents();
                    CalendarGridPanel gridComponent = this.gridPanel;
                    ActionMap actionMap = gridComponent.getActionMap();
                    actionMap.put("##microba.commit##", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                this.commit();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.invalidate();
        }

        public void setDate(java.util.Date date) throws PropertyVetoException {
            if (this.mySettingDate) {
                super.setDate(date);
            } else {
                this.doSetDate(date);
            }
        }

        private void doSetDate(java.util.Date date) throws PropertyVetoException {
            this.mySettingDate = true;
            try {
                boolean dateChanged = !Comparing.equal((Object)date, (Object)this.getDate());
                super.setDate(date);
                if (!dateChanged) {
                    this.fireActionEvent();
                }
            }
            finally {
                this.mySettingDate = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$MyCalendarPane", "setPaintBorderForFocusedButtons"));
        }
    }
}

