/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.gateway.protocolHandlers.LinuxProtocolHandler;
import com.jetbrains.gateway.protocolHandlers.WindowsProtocolHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/gateway/GatewayInitializer;", "", "<init>", "()V", "isFirstRun", "", "Companion", "intellij.gateway"})
public final class GatewayInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GatewayInitializer() {
        if (Companion.isAvailable() && this.isFirstRun()) {
            if (SystemInfo.isWindows) {
                WindowsProtocolHandler.INSTANCE.install();
            }
            if (SystemInfo.isLinux) {
                LinuxProtocolHandler.INSTANCE.install();
            }
        }
    }

    private final boolean isFirstRun() {
        String prevRunBuild = PropertiesComponent.getInstance().getValue("gateway.last.run");
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String currentRunBuild = string;
        if (!Intrinsics.areEqual((Object)prevRunBuild, (Object)currentRunBuild)) {
            PropertiesComponent.getInstance().setValue("gateway.last.run", currentRunBuild);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/GatewayInitializer$Companion;", "", "<init>", "()V", "isAvailable", "", "intellij.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable() {
            CharSequence charSequence;
            return !ApplicationManager.getApplication().isHeadlessEnvironment() && !PluginManagerCore.isRunningFromSources() && ((charSequence = (CharSequence)System.getProperty("idea.parent.product")) == null || charSequence.length() == 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

