/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.execution.ExecutionResult;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxScriptManager;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.SourcesResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.rpc.RequestPromise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/firefox/FirefoxDebugProcess;", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "doInitBreakpoints", "", "isRemoveAllBreakpointsOnStop", "", "isVmStepOutCorrect", "intellij.javascript.firefox.connector"})
public final class FirefoxDebugProcess
extends JavaScriptDebugProcess<VmConnection<?>> {
    public FirefoxDebugProcess(@NotNull XDebugSession session, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<?> connection, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        super(session, finder, connection, executionResult);
    }

    public void doInitBreakpoints() {
        Vm vm = this.getMainVm();
        Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type com.jetbrains.firefox.FirefoxVm");
        FirefoxVm vm2 = (FirefoxVm)vm;
        String string = vm2.getThreadActor();
        Intrinsics.checkNotNull((Object)string);
        String threadActor = string;
        vm2.getCommandProcessor().attachToThreadAndExecute(threadActor, (Function0<Unit>)((Function0)() -> FirefoxDebugProcess.doInitBreakpoints$lambda$5(vm2, threadActor, this)));
    }

    protected boolean isRemoveAllBreakpointsOnStop() {
        return false;
    }

    protected boolean isVmStepOutCorrect() {
        return false;
    }

    private static final Unit doInitBreakpoints$lambda$5$lambda$1$lambda$0(FirefoxDebugProcess this$0) {
        this$0.getSession().initBreakpoints();
        return Unit.INSTANCE;
    }

    private static final Unit doInitBreakpoints$lambda$5$lambda$1(FirefoxVm $vm, String $threadActor, FirefoxDebugProcess this$0, SourcesResult it) {
        FirefoxScriptManager scriptManager = $vm.getScriptManager();
        for (Source script : it.sources()) {
            scriptManager.addScript(script);
        }
        ActionsKt.runReadAction(() -> FirefoxDebugProcess.doInitBreakpoints$lambda$5$lambda$1$lambda$0(this$0));
        $vm.getCommandProcessor().forcedReleaseThread($threadActor);
        return Unit.INSTANCE;
    }

    private static final Unit doInitBreakpoints$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit doInitBreakpoints$lambda$5$lambda$3(FirefoxVm $vm, String $threadActor, Throwable it) {
        $vm.getCommandProcessor().forcedReleaseThread($threadActor);
        return Unit.INSTANCE;
    }

    private static final void doInitBreakpoints$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit doInitBreakpoints$lambda$5(FirefoxVm $vm, String $threadActor, FirefoxDebugProcess this$0) {
        $vm.getCommandProcessor().setForcedPause(true);
        FirefoxRequest<SourcesResult> message = FirefoxRequest.Companion.sources($threadActor);
        RequestPromise callback = new RequestPromise(message.getMethodName());
        callback.then(arg_0 -> FirefoxDebugProcess.doInitBreakpoints$lambda$5$lambda$2(arg_0 -> FirefoxDebugProcess.doInitBreakpoints$lambda$5$lambda$1($vm, $threadActor, this$0, arg_0), arg_0)).onError(arg_0 -> FirefoxDebugProcess.doInitBreakpoints$lambda$5$lambda$4(arg_0 -> FirefoxDebugProcess.doInitBreakpoints$lambda$5$lambda$3($vm, $threadActor, arg_0), arg_0));
        $vm.getCommandProcessor().doSendFromPaused(message, $threadActor, callback);
        return Unit.INSTANCE;
    }
}

