/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.jetbrains.firefox.FirefoxObject;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.rdp.Grip;
import com.jetbrains.firefox.rdp.PropertyDescriptor;
import com.jetbrains.firefox.rdp.PropertyResult;
import com.jetbrains.firefox.rdp.PrototypeAndPropertiesResult;
import com.jetbrains.firefox.rdp.PrototypeResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.ObjectValueBaseKt;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J2\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/jetbrains/firefox/FirefoxObject;", "Lorg/jetbrains/debugger/values/ObjectValueBase;", "Lcom/jetbrains/firefox/FirefoxValueManager;", "type", "Lorg/jetbrains/debugger/values/ValueType;", "valueData", "Lcom/jetbrains/firefox/rdp/Grip;", "valueManager", "<init>", "(Lorg/jetbrains/debugger/values/ValueType;Lcom/jetbrains/firefox/rdp/Grip;Lcom/jetbrains/firefox/FirefoxValueManager;)V", "className", "", "getClassName", "()Ljava/lang/String;", "valueString", "getValueString", "actor", "getActor", "ownPropertiesLength", "", "preloadedProperties", "", "Lorg/jetbrains/debugger/Variable;", "childrenManager", "Lorg/jetbrains/debugger/VariablesHost;", "getChildrenManager", "()Lorg/jetbrains/debugger/VariablesHost;", "hasProperties", "Lcom/intellij/util/ThreeState;", "valueToString", "preview", "Lcom/jetbrains/firefox/rdp/Grip$Preview;", "getProperties", "Lorg/jetbrains/concurrency/Promise;", "names", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "obsolescent", "Lorg/jetbrains/concurrency/Obsolescent;", "intellij.javascript.firefox.connector"})
public class FirefoxObject
extends ObjectValueBase<FirefoxValueManager> {
    @Nullable
    private final String className;
    @Nullable
    private final String valueString;
    @NotNull
    private final String actor;
    private final int ownPropertiesLength;
    @Nullable
    private List<? extends Variable> preloadedProperties;
    @NotNull
    private final VariablesHost<FirefoxValueManager> childrenManager;

    public FirefoxObject(@NotNull ValueType type, @NotNull Grip valueData, @NotNull FirefoxValueManager valueManager) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)valueData, (String)"valueData");
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        super(type);
        this.className = valueData.className();
        this.valueString = this.valueToString(valueData, valueData.preview());
        String string = valueData.actor();
        Intrinsics.checkNotNull((Object)string);
        this.actor = string;
        this.childrenManager = (VariablesHost)new VariablesHost<FirefoxValueManager>(valueManager, this){
            final /* synthetic */ FirefoxValueManager $valueManager;
            final /* synthetic */ FirefoxObject this$0;
            {
                this.$valueManager = $valueManager;
                this.this$0 = $receiver;
                super((ValueManager)$valueManager);
            }

            protected Promise<List<Variable>> load() {
                if (FirefoxObject.access$getPreloadedProperties$p(this.this$0) == null) {
                    Promise promise = this.$valueManager.getVm().getCommandProcessor().send(FirefoxRequest.Companion.getPrototypeAndProperties(this.this$0.getActor())).then(arg_0 -> childrenManager.1.load$lambda$1(arg_0 -> childrenManager.1.load$lambda$0(this.$valueManager, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
                    return promise;
                }
                Promise promise = this.$valueManager.getVm().getCommandProcessor().send(FirefoxRequest.Companion.getPrototype(this.this$0.getActor())).then(arg_0 -> childrenManager.1.load$lambda$3(arg_0 -> childrenManager.1.load$lambda$2(this.this$0, this.$valueManager, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
                return promise;
            }

            private static final List load$lambda$0(FirefoxValueManager $valueManager, PrototypeAndPropertiesResult it) {
                List<Variable> properties = $valueManager.createProperties(it.ownProperties(), it.prototype(), it.safeGetterValues());
                $valueManager.promoteRecentlyAddedActorsToThreadLifetime();
                return properties;
            }

            private static final List load$lambda$1(Function1 $tmp0, Object p0) {
                return (List)$tmp0.invoke(p0);
            }

            private static final List load$lambda$2(FirefoxObject this$0, FirefoxValueManager $valueManager, PrototypeResult it) {
                List list;
                List list2 = FirefoxObject.access$getPreloadedProperties$p(this$0);
                Intrinsics.checkNotNull((Object)list2);
                List list3 = list2;
                FirefoxObject.access$setPreloadedProperties$p(this$0, null);
                VariableImpl protoVariable = $valueManager.createProtoVariable(it.prototype());
                if (list3.isEmpty()) {
                    list = CollectionsKt.listOf((Object)protoVariable);
                } else {
                    list3 = new ArrayList<E>(list3);
                    ((ArrayList)list3).add(protoVariable);
                    $valueManager.promoteRecentlyAddedActorsToThreadLifetime();
                    list = list3;
                }
                return list;
            }

            private static final List load$lambda$3(Function1 $tmp0, Object p0) {
                return (List)$tmp0.invoke(p0);
            }
        };
        Grip.Preview preview = valueData.preview();
        if (preview == null) {
            this.ownPropertiesLength = -1;
        } else {
            this.ownPropertiesLength = preview.ownPropertiesLength();
            Map<String, PropertyDescriptor> ownPropertiesPreview = preview.ownProperties();
            Map<String, PropertyDescriptor> map = ownPropertiesPreview;
            if (!(map == null || map.isEmpty()) && ownPropertiesPreview.size() <= this.ownPropertiesLength) {
                this.preloadedProperties = valueManager.createProperties(ownPropertiesPreview, null, preview.safeGetterValues());
            }
        }
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    @Nullable
    public String getValueString() {
        return this.valueString;
    }

    @NotNull
    public final String getActor() {
        return this.actor;
    }

    @NotNull
    protected VariablesHost<FirefoxValueManager> getChildrenManager() {
        return this.childrenManager;
    }

    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState;
        if (this.ownPropertiesLength == -1) {
            threeState = ThreeState.UNSURE;
        } else {
            ThreeState threeState2 = ThreeState.fromBoolean((this.ownPropertiesLength != 0 ? 1 : 0) != 0);
            threeState = threeState2;
            Intrinsics.checkNotNullExpressionValue((Object)threeState2, (String)"fromBoolean(...)");
        }
        return threeState;
    }

    private final String valueToString(Grip valueData, Grip.Preview preview) {
        if (valueData.displayString() != null) {
            String string = valueData.displayString();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        if (preview != null) {
            if (preview.timestamp() != -1L) {
                return new Date(preview.timestamp()).toString();
            }
            if (preview.kind() == Grip.Preview.Kind.ERROR) {
                String string = preview.name();
                Intrinsics.checkNotNull((Object)string);
                return string + ": " + preview.message();
            }
        }
        return valueData.className();
    }

    @NotNull
    public Promise<List<Variable>> getProperties(@NotNull List<String> names, @NotNull EvaluateContext evaluateContext, @NotNull Obsolescent obsolescent) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        Intrinsics.checkNotNullParameter((Object)obsolescent, (String)"obsolescent");
        if (this.getChildrenManager().getState() != null) {
            return super.getProperties(names, evaluateContext, obsolescent);
        }
        if (this.preloadedProperties != null) {
            List<? extends Variable> list = this.preloadedProperties;
            Intrinsics.checkNotNull(list);
            return ObjectValueBaseKt.getSpecifiedProperties(list, names, (EvaluateContext)evaluateContext);
        }
        SmartList list = new SmartList();
        SmartList promises = new SmartList();
        for (String name : names) {
            promises.add((Object)((FirefoxValueManager)this.getChildrenManager().valueManager).getVm().getCommandProcessor().send(FirefoxRequest.Companion.getProperty(this.actor, name)).onSuccess(arg_0 -> FirefoxObject.getProperties$lambda$1(arg_0 -> FirefoxObject.getProperties$lambda$0(list, this, name, arg_0), arg_0)));
        }
        Promise promise = Promises.all$default((Collection)((Collection)promises), (Object)list, (boolean)false, (int)2, null).onSuccess(arg_0 -> FirefoxObject.getProperties$lambda$3(arg_0 -> FirefoxObject.getProperties$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    private static final Unit getProperties$lambda$0(SmartList $list, FirefoxObject this$0, String $name, PropertyResult it) {
        PropertyDescriptor descriptor;
        PropertyResult propertyResult = it;
        PropertyDescriptor propertyDescriptor = descriptor = propertyResult != null ? propertyResult.descriptor() : null;
        if (descriptor != null) {
            if (descriptor.get() != null) {
                return Unit.INSTANCE;
            }
            $list.add((Object)((FirefoxValueManager)this$0.getChildrenManager().valueManager).createProperty($name, descriptor, null));
        }
        return Unit.INSTANCE;
    }

    private static final void getProperties$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getProperties$lambda$2(FirefoxObject this$0, List it) {
        ((FirefoxValueManager)this$0.getChildrenManager().valueManager).promoteRecentlyAddedActorsToThreadLifetime();
        return Unit.INSTANCE;
    }

    private static final void getProperties$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getPreloadedProperties$p(FirefoxObject $this) {
        return $this.preloadedProperties;
    }

    public static final /* synthetic */ void access$setPreloadedProperties$p(FirefoxObject $this, List list) {
        $this.preloadedProperties = list;
    }
}

