/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.util.MultiMap;
import com.intellij.docker.agent.util.ParametersListParser;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NormalizedCommandLine {
    private final MultiMap<Option, String> myGrouped = new MultiMap();
    private final Set<Option> myOneValuePerLineOptions = new HashSet<Option>();
    private final Set<Option> myOptionsWithEqualsSeparator = new HashSet<Option>();

    public void forceNameEqualsValueFormat(Option option) {
        this.myOptionsWithEqualsSeparator.add(option);
    }

    public void registerOneValue(Option option, String value) {
        this.myGrouped.putValue(option, NormalizedCommandLine.encodeSpaces(value));
    }

    public void registerOneValue(Option option, int value) {
        this.myGrouped.putValue(option, String.valueOf(value));
    }

    public void registerOneValue(Option option, long value) {
        this.myGrouped.putValue(option, String.valueOf(value));
    }

    public void registerOneValue(Option option, boolean value) {
        if (option.hasOptionalArg() && value) {
            this.myGrouped.putValue(option, "");
        } else {
            this.myGrouped.putValue(option, String.valueOf(value));
        }
    }

    public void registerMany(Option option, String[] value) {
        for (String next : value) {
            this.myGrouped.putValue(option, NormalizedCommandLine.encodeSpaces(next));
        }
    }

    protected void preferOneValuePerLine(Option option) {
        this.myOneValuePerLineOptions.add(option);
    }

    public List<String> groupByOptions() {
        return this.groupByOptions(option -> true);
    }

    public List<String> groupByOptions(Predicate<Option> optionsFilter) {
        LinkedList<String> result2 = new LinkedList<String>();
        for (Map.Entry<Option, Collection<String>> entry : this.myGrouped.getEntries()) {
            Option nextOption = entry.getKey();
            if (!optionsFilter.test(nextOption)) continue;
            String optionKey = nextOption.getOpt() == null ? "--" + nextOption.getLongOpt() : "-" + nextOption.getOpt();
            String keyValueSeparator = this.myOptionsWithEqualsSeparator.contains(nextOption) ? "=" : " ";
            List pieces = entry.getValue().stream().map(val -> optionKey + keyValueSeparator + val).map(String::trim).collect(Collectors.toList());
            if (this.myOneValuePerLineOptions.contains(nextOption)) {
                result2.addAll(pieces);
                continue;
            }
            result2.add(String.join((CharSequence)" ", pieces));
        }
        return result2;
    }

    @NotNull
    private static String encodeSpaces(String value) {
        if (value == null) {
            String string = String.valueOf(null);
            if (string == null) {
                NormalizedCommandLine.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (value.contains(" ")) {
            return NormalizedCommandLine.escape(value);
        }
        String string = value;
        if (string == null) {
            NormalizedCommandLine.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String escape(@NotNull CharSequence argument) {
        if (argument == null) {
            NormalizedCommandLine.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder(argument);
        NormalizedCommandLine.escapeQuotes(builder);
        if (builder.length() == 0 || NormalizedCommandLine.containsWhitespaces(builder) || builder.indexOf("|") >= 0) {
            int numTrailingBackslashes = builder.length() - NormalizedCommandLine.trimTrailing(builder).length();
            builder.insert(0, '\"');
            builder.append('\"');
            builder.append("\\".repeat(Math.max(0, numTrailingBackslashes)));
        }
        String string = builder.toString();
        if (string == null) {
            NormalizedCommandLine.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            NormalizedCommandLine.$$$reportNull$$$0(4);
        }
        int idx = 0;
        while ((idx = buf.indexOf("\"", idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    private static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static StringBuilder trimTrailing(@NotNull StringBuilder builder) {
        int index;
        if (builder == null) {
            NormalizedCommandLine.$$$reportNull$$$0(5);
        }
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == '\\'; --index) {
        }
        builder.setLength(index + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            NormalizedCommandLine.$$$reportNull$$$0(6);
        }
        return stringBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/cli/model/NormalizedCommandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeSpaces";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/cli/model/NormalizedCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static class LabelListPrinter
    extends CliParserBase.LabelListHandler<NormalizedCommandLine> {
        public LabelListPrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleLabelsMap(Map<String, String> parsedMap) {
            parsedMap.forEach((key, value) -> {
                String text = value == null || value.length() == 0 ? key : key + "=" + value;
                ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), text);
            });
        }
    }

    public static class MemoryOptionPrinter
    extends CliParserBase.MemoryOptionHandler<NormalizedCommandLine> {
        public MemoryOptionPrinter(Option option) {
            super(option, null);
        }

        @Override
        protected void handleEachValue(String value) {
            this.parseMemory(value);
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static class MappedListPrinter
    extends CliParserBase.MappedListHandler<NormalizedCommandLine, String> {
        public MappedListPrinter(Option option) {
            super(option, String.class, Function.identity(), (cmd, strings) -> cmd.registerMany(option, (String[])strings));
        }
    }

    public static class StringListPrinter
    extends CliParserBase.StringListHandler<NormalizedCommandLine> {
        public StringListPrinter(Option option) {
            this(option, false);
        }

        public StringListPrinter(Option option, boolean preferSeparateLine) {
            super(option, (cmd, strings) -> {
                cmd.registerMany(option, (String[])strings);
                if (preferSeparateLine) {
                    cmd.preferOneValuePerLine(option);
                }
            });
        }
    }

    public static class BooleanValuePrinter
    extends CliParserBase.BooleanOptionHandler<NormalizedCommandLine> {
        public BooleanValuePrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleBooleanValue(boolean value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static class DoubleValuePrinter
    extends CliParserBase.DoubleOptionHandler<NormalizedCommandLine> {
        private static final DecimalFormat FORMAT = new DecimalFormat("#.######");

        public DoubleValuePrinter(Option option) {
            super(option, (cmd, value) -> cmd.registerOneValue(option, FORMAT.format(value)));
        }
    }

    public static class LongValuePrinter
    extends CliParserBase.LongOptionHandler<NormalizedCommandLine> {
        public LongValuePrinter(Option option) {
            super(option, (? super CMD cmd, ? super Long value) -> cmd.registerOneValue(option, (long)value));
        }
    }

    public static class IntegerValuePrinter
    extends CliParserBase.IntegerOptionHandler<NormalizedCommandLine> {
        public IntegerValuePrinter(Option option) {
            super(option, (? super CMD cmd, ? super Integer value) -> cmd.registerOneValue(option, (int)value));
        }
    }

    public static class SingleValuePrinter
    extends CliParserBase.SingleValueHandler<NormalizedCommandLine> {
        public SingleValuePrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleEachValue(String value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static interface CliValidator {
        public List<CliParserBase.OptionHandler<NormalizedCommandLine>> getHandlers();

        @NotNull
        default public NormalizedCommandLine tryValidateCliOptions(@NotNull String optionsLine) throws ParseException {
            if (optionsLine == null) {
                CliValidator.$$$reportNull$$$0(0);
            }
            NormalizedCommandLine normalizedCommandLine = this.tryValidateCliOptions(ParametersListParser.INSTANCE.parseToArray(optionsLine));
            if (normalizedCommandLine == null) {
                CliValidator.$$$reportNull$$$0(1);
            }
            return normalizedCommandLine;
        }

        @NotNull
        public NormalizedCommandLine tryValidateCliOptions(String @NotNull [] var1) throws ParseException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionsLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/cli/model/NormalizedCommandLine$CliValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/cli/model/NormalizedCommandLine$CliValidator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryValidateCliOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "tryValidateCliOptions";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

