/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.docker.composeFile.ComposeFileKeyReference;
import com.intellij.docker.composeFile.ComposeFileReferenceResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0006H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/composeFile/model/NetworkReferenceField;", "Lorg/jetbrains/yaml/meta/model/Field;", "name", "", "type", "Lkotlin/Function0;", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "newField", "getReferenceFromKey", "Lcom/intellij/psi/PsiReference;", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getKeyLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "ownerClass", "insertedScalar", "Lcom/intellij/psi/PsiElement;", "intellij.clouds.docker.compose"})
public final class NetworkReferenceField
extends Field {
    @NotNull
    private final Function0<YamlMetaType> type;

    public NetworkReferenceField(@NotNull String name2, @NotNull Function0<? extends YamlMetaType> type) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(name2, (YamlMetaType)type.invoke());
        this.type = type;
        this.withAnyName();
    }

    @NotNull
    protected Field newField(@NotNull YamlMetaType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new NetworkReferenceField(string, this.type);
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        if (keyValue.getKey() == null) {
            return null;
        }
        return new ComposeFileKeyReference((PsiElement)keyValue, ComposeFileReferenceResolver.NETWORKS);
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaType ownerClass, @NotNull PsiElement insertedScalar) {
        Intrinsics.checkNotNullParameter((Object)ownerClass, (String)"ownerClass");
        Intrinsics.checkNotNullParameter((Object)insertedScalar, (String)"insertedScalar");
        YAMLDocument yAMLDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)insertedScalar, YAMLDocument.class);
        if (yAMLDocument == null) {
            return CollectionsKt.emptyList();
        }
        YAMLDocument document = yAMLDocument;
        Predicate<YAMLKeyValue> filter2 = ComposeFileReferenceResolver.SKIP_ANCESTOR(insertedScalar);
        List<LookupElementBuilder> list2 = ComposeFileReferenceResolver.NETWORKS.createValueLookups(document, filter2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"createValueLookups(...)");
        return list2;
    }
}

