/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.configuration.wizard;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.remote.DockerRemoteUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.target.configuration.wizard.OutputConsumer;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0001\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u0010*\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"execInContainer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/execution/process/ProcessOutput;", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "command", "", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "CR", "", "LF", "CRLF", "normalizeNewLines", "s", "info", "", "message", "warn", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerTargetIntrospectableUtil")
@SourceDebugExtension(value={"SMAP\nDockerTargetIntrospectableUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerTargetIntrospectableUtil.kt\ncom/intellij/docker/remote/run/target/configuration/wizard/DockerTargetIntrospectableUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n37#2,2:90\n24#3:92\n*S KotlinDebug\n*F\n+ 1 DockerTargetIntrospectableUtil.kt\ncom/intellij/docker/remote/run/target/configuration/wizard/DockerTargetIntrospectableUtil\n*L\n27#1:90,2\n33#1:92\n*E\n"})
public final class DockerTargetIntrospectableUtil {
    private static final char CR = '\r';
    private static final char LF = '\n';
    @NotNull
    private static final String CRLF = "\r\n";

    @NotNull
    public static final CompletableFuture<ProcessOutput> execInContainer(@NotNull RemoteDockerApplicationRuntime $this$execInContainer, @NotNull List<String> command, @NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)$this$execInContainer, (String)"<this>");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        String script = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        OutputConsumer stdoutConsumer = new OutputConsumer(ttySink);
        OutputConsumer stderrConsumer = new OutputConsumer(ttySink);
        DockerTargetIntrospectableUtil.info(ttySink, "#" + script);
        DockerAgentContainer dockerAgentContainer = $this$execInContainer.getAgentContainer();
        Intrinsics.checkNotNullExpressionValue((Object)dockerAgentContainer, (String)"getAgentContainer(...)");
        Collection $this$toTypedArray$iv = command;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        CompletionStage completionStage = ((CompletableFuture)DockerRemoteUtilsKt.execCommand$default(dockerAgentContainer, Arrays.copyOf(stringArray, stringArray.length), false, null, null, null, stdoutConsumer, stderrConsumer, 28, null).whenComplete((arg_0, arg_1) -> DockerTargetIntrospectableUtil.execInContainer$lambda$1((arg_0, arg_1) -> DockerTargetIntrospectableUtil.execInContainer$lambda$0($this$execInContainer, ttySink, arg_0, arg_1), arg_0, arg_1))).thenApply(arg_0 -> DockerTargetIntrospectableUtil.execInContainer$lambda$3(arg_0 -> DockerTargetIntrospectableUtil.execInContainer$lambda$2(ttySink, stdoutConsumer, stderrConsumer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NlsSafe
    @NotNull
    public static final String normalizeNewLines(@NotNull String s) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder $this$normalizeNewLines_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int curIndex = 0;
        while (curIndex < s.length()) {
            int nextLFIndex = StringsKt.indexOf$default((CharSequence)s, (char)'\n', (int)curIndex, (boolean)false, (int)4, null);
            if (nextLFIndex == -1) {
                String string = s.substring(curIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$normalizeNewLines_u24lambda_u244.append(string);
                break;
            }
            if (nextLFIndex > 0 && ((CharSequence)s).charAt(nextLFIndex - 1) == '\r') {
                String string = s.substring(curIndex, nextLFIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$normalizeNewLines_u24lambda_u244.append(string);
                curIndex = nextLFIndex + 1;
                continue;
            }
            String string = s.substring(curIndex, nextLFIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$normalizeNewLines_u24lambda_u244.append(string);
            $this$normalizeNewLines_u24lambda_u244.append(CRLF);
            curIndex = nextLFIndex + 1;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final void info(@NotNull TtySink $this$info, @Nls @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$info, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$info.coloredTtyPrintln(message, TtySink.Colors.BLUE);
    }

    public static final void warn(@NotNull TtySink $this$warn, @Nls @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$warn.coloredTtyPrintln(message, TtySink.Colors.ORANGE);
    }

    private static final Unit execInContainer$lambda$0(RemoteDockerApplicationRuntime $this_execInContainer, TtySink $ttySink, Integer n, Throwable e) {
        if (e != null) {
            RemoteDockerApplicationRuntime $this$thisLogger$iv = $this_execInContainer;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RemoteDockerApplicationRuntime.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Docker exec command failed", e);
            Object[] objectArray = new Object[]{e.getLocalizedMessage()};
            String string = DockerBundle.message("DockerTargetIntrospectable.failed.to.execute.command.in.running.container", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            DockerTargetIntrospectableUtil.warn($ttySink, string);
        }
        return Unit.INSTANCE;
    }

    private static final void execInContainer$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final ProcessOutput execInContainer$lambda$2(TtySink $ttySink, OutputConsumer $stdoutConsumer, OutputConsumer $stderrConsumer, Integer it) {
        Object[] objectArray = new Object[]{it};
        String string = IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DockerTargetIntrospectableUtil.info($ttySink, string);
        String string2 = $stdoutConsumer.getOutput();
        String string3 = $stderrConsumer.getOutput();
        Intrinsics.checkNotNull((Object)it);
        return new ProcessOutput(string2, string3, it.intValue(), false, false);
    }

    private static final ProcessOutput execInContainer$lambda$3(Function1 $tmp0, Object p0) {
        return (ProcessOutput)$tmp0.invoke(p0);
    }
}

