/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.docker.DockerAgentConnector;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.agent.impl.DockerResult;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentProgressTaskExecutor;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntimesManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0001<B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u000e\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001eH\u0002J\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0002\u0010\"J\u0011\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 \u00a2\u0006\u0002\u0010%J\u0011\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 \u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010*\u001a\u00020\u001cJ\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 2\b\u0010+\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u0004\u0018\u00010'2\u0006\u0010.\u001a\u00020\u001cJ\u0010\u0010/\u001a\u0004\u0018\u00010'2\u0006\u00100\u001a\u00020\u001cJ\u0010\u00101\u001a\u0004\u0018\u00010'2\u0006\u00102\u001a\u00020\u001cJ\u000e\u00103\u001a\u0002042\u0006\u00102\u001a\u00020\u001cJ\u001a\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000207060\u00122\u0006\u00102\u001a\u00020\u001cJ\u001a\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000207060\u00122\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002042\u0006\u00102\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006="}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "", "account", "Lcom/intellij/docker/DockerCloudConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/DockerCloudConfiguration;Lcom/intellij/openapi/project/Project;)V", "getAccount", "()Lcom/intellij/docker/DockerCloudConfiguration;", "getProject", "()Lcom/intellij/openapi/project/Project;", "myAgent", "Lcom/intellij/docker/agent/DockerAgent;", "agent", "getAgent", "()Lcom/intellij/docker/agent/DockerAgent;", "connect", "Ljava/util/concurrent/CompletableFuture;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "connect$intellij_clouds_docker", "cli", "Lcom/intellij/docker/agent/cli/DockerCli;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findContainerByNameOrId", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "containerNameOrId", "", "createNameOrId2ContainerMapping", "Lcom/intellij/util/Function;", "getVolumes", "", "Lcom/intellij/docker/agent/DockerAgentVolume;", "()[Lcom/intellij/docker/agent/DockerAgentVolume;", "getContainers", "Lcom/intellij/docker/agent/DockerAgentContainer;", "()[Lcom/intellij/docker/agent/DockerAgentContainer;", "getImages", "Lcom/intellij/docker/agent/DockerAgentImage;", "()[Lcom/intellij/docker/agent/DockerAgentImage;", "findContainer", "id", "label", "(Ljava/lang/String;)[Lcom/intellij/docker/agent/DockerAgentImage;", "findImageByNameOrId", "nameOrId", "findImageByIdPrefix", "sha256id", "findImageByName", "imageName", "pullImage", "", "asyncPullImage", "Ljava/util/concurrent/BlockingQueue;", "", "asyncBuildImage", "config", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "doPullImage", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nRemoteDockerRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n12574#2,2:233\n*S KotlinDebug\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime\n*L\n97#1:233,2\n*E\n"})
public final class RemoteDockerRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerCloudConfiguration account;
    @Nullable
    private final Project project;
    @Nullable
    private DockerAgent myAgent;
    @NotNull
    private static final Logger LOG;

    public RemoteDockerRuntime(@NotNull DockerCloudConfiguration account, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        this.account = account;
        this.project = project;
        this.myAgent = DockerAgent.Companion.createInstance(DockerMainCoroutineScopeHolder.createChildScope$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, false, 3, null));
    }

    @NotNull
    public final DockerCloudConfiguration getAccount() {
        return this.account;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DockerAgent getAgent() {
        DockerAgent dockerAgent = this.myAgent;
        if (dockerAgent == null) {
            throw new RuntimeException("Not connected");
        }
        return dockerAgent;
    }

    @NotNull
    public final CompletableFuture<RemoteDockerRuntime> connect$intellij_clouds_docker(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return FutureKt.future$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RemoteDockerRuntime>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = new DockerAgentConnector(this.this$0.getAccount(), this.this$0.getAgent()).connect((Continuation<? super Unit>)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return this.this$0;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return this.this$0;
                        }
                        catch (CancellationException ce) {
                            throw ce;
                        }
                        catch (Exception e) {
                            throw new ServerRuntimeException((Throwable)e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RemoteDockerRuntime> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object cli(@NotNull Continuation<? super DockerCli> $completion) {
        return this.getAgent().getCliFacade().docker($completion);
    }

    @Nullable
    public final RemoteDockerApplicationRuntime findContainerByNameOrId(@NotNull String containerNameOrId) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)containerNameOrId, (String)"containerNameOrId");
        return (RemoteDockerApplicationRuntime)this.createNameOrId2ContainerMapping().fun((Object)containerNameOrId);
    }

    private final Function<String, RemoteDockerApplicationRuntime> createNameOrId2ContainerMapping() {
        DockerAgentContainer[] containers2 = this.getContainers();
        return arg_0 -> RemoteDockerRuntime.createNameOrId2ContainerMapping$lambda$1(containers2, this, arg_0);
    }

    @NotNull
    public final DockerAgentVolume[] getVolumes() {
        return (DockerAgentVolume[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerAgentVolume[]>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAgent().obtainVolumes((Continuation<? super DockerResult<DockerAgentVolume[]>>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (DockerAgentVolume[])((DockerResult)v0).onFailure((Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, access$logWarnOrErrorIfTestMode(com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime$Companion java.lang.Throwable ), (Ljava/lang/Throwable;)V)((Companion)RemoteDockerRuntime.Companion)).getOrNull()) == null) {
                            v1 = new DockerAgentVolume[]{};
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DockerAgentVolume[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final DockerAgentContainer[] getContainers() {
        return (DockerAgentContainer[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerAgentContainer[]>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAgent().obtainContainers((Continuation<? super DockerResult<DockerAgentContainer[]>>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (DockerAgentContainer[])((DockerResult)v0).onFailure((Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, access$logWarnOrErrorIfTestMode(com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime$Companion java.lang.Throwable ), (Ljava/lang/Throwable;)V)((Companion)RemoteDockerRuntime.Companion)).getOrNull()) == null) {
                            v1 = new DockerAgentContainer[]{};
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DockerAgentContainer[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final DockerAgentImage[] getImages() {
        return this.getImages(null);
    }

    @Nullable
    public final DockerAgentContainer findContainer(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (DockerAgentContainer)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerAgentContainer>, Object>(this, id, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getAgent().findContainer(this.$id, (Continuation<? super DockerResult<DockerAgentContainer>>)((Continuation)this));
                        if (object3 != object2) return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0)).getOrNull();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0)).getOrNull();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DockerAgentContainer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final DockerAgentImage[] getImages(@Nullable String label2) {
        DockerAgentImage[] dockerAgentImageArray = (DockerAgentImage[])((DockerResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerResult<DockerAgentImage[]>>, Object>(this, label2, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            final /* synthetic */ String $label;
            {
                this.this$0 = $receiver;
                this.$label = $label;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DockerAgent.obtainImages$default(this.this$0.getAgent(), this.$label, false, (Continuation)this, 2, null);
                        if (object3 != object2) return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0));
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DockerResult<DockerAgentImage[]>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).getOrNull();
        if (dockerAgentImageArray == null) {
            dockerAgentImageArray = new DockerAgentImage[]{};
        }
        return dockerAgentImageArray;
    }

    @Nullable
    public final DockerAgentImage findImageByNameOrId(@NotNull String nameOrId) {
        Intrinsics.checkNotNullParameter((Object)nameOrId, (String)"nameOrId");
        return StringsKt.startsWith$default((String)nameOrId, (String)"sha256:", (boolean)false, (int)2, null) ? this.findImageByIdPrefix(nameOrId) : this.findImageByName(nameOrId);
    }

    @Nullable
    public final DockerAgentImage findImageByIdPrefix(@NotNull String sha256id) {
        Intrinsics.checkNotNullParameter((Object)sha256id, (String)"sha256id");
        int minimalLookupLength = 6;
        String string = StringUtil.trimStart((String)sha256id, (String)"sha256:");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(...)");
        String lookup = string;
        if (lookup.length() < minimalLookupLength) {
            return null;
        }
        for (DockerAgentImage next : this.getImages()) {
            String actualId;
            String nextId = next.getImageId();
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)nextId, (String)"sha256:"), (String)"trimStart(...)");
            if (!StringsKt.startsWith$default((String)actualId, (String)lookup, (boolean)false, (int)2, null)) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public final DockerAgentImage findImageByName(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        for (DockerAgentImage next : this.getImages()) {
            for (String imageTag : next.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag, (CharSequence)imageName)) continue;
                return next;
            }
        }
        return null;
    }

    public final void pullImage(@NotNull String imageName) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        LOG.debug("Pull image {" + imageName + "}");
        try {
            this.doPullImage(imageName);
            LOG.debug("Docker image {" + imageName + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName + "}", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        if (this.project == null) {
            throw new NullPointerException();
        }
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.Companion.forImageName(imageName);
        return this.getAgent().asyncPullImage(repositoryConfig);
    }

    @NotNull
    public final CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (this.project == null) {
            throw new NullPointerException();
        }
        return this.getAgent().createImageBuilder().asyncBuildImage(config2);
    }

    private final void doPullImage(String imageName) throws ServerRuntimeException {
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.Companion.forImageName(imageName);
        DockerAgentProgressTaskExecutor dockerAgentProgressTaskExecutor = DockerAgentProgressTaskExecutor.Companion.getInstance();
        Object[] objectArray = new Object[]{imageName};
        String string = DockerBundle.message("RemoteDockerRuntime.progress.title.pulling.image", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        dockerAgentProgressTaskExecutor.performSync(string, (Function2<? super DockerAgentProgressCallback, ? super Continuation<? super OngoingProcess>, ? extends Object>)((Function2)new Function2<DockerAgentProgressCallback, Continuation<? super OngoingProcess>, Object>(this, repositoryConfig, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ RemoteDockerRuntime this$0;
            final /* synthetic */ DockerAgentRepositoryConfig $repositoryConfig;
            {
                this.this$0 = $receiver;
                this.$repositoryConfig = $repositoryConfig;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DockerAgentProgressCallback it = (DockerAgentProgressCallback)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.getAgent().pullImageWithProgressCallback(this.$repositoryConfig, it, (Continuation<? super OngoingProcess>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DockerAgentProgressCallback p1, Continuation<? super OngoingProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final RemoteDockerApplicationRuntime createNameOrId2ContainerMapping$lambda$1(DockerAgentContainer[] $containers, RemoteDockerRuntime this$0, String containerNameOrId) {
        Intrinsics.checkNotNullParameter((Object)containerNameOrId, (String)"containerNameOrId");
        for (DockerAgentContainer next : $containers) {
            if (!StringUtil.equals((CharSequence)containerNameOrId, (CharSequence)next.getContainerId())) {
                boolean bl;
                block3: {
                    String[] $this$any$iv = next.getContainerNames();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)("/" + containerNameOrId), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
            }
            return RemoteDockerApplicationRuntime.create(this$0, next);
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config2, @Nullable Project project) throws ServerRuntimeException {
        return Companion.create(config2, project);
    }

    static {
        Logger logger = Logger.getInstance(RemoteDockerRuntime.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "logWarnOrErrorIfTestMode", "", "ex", "", "create", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "forImageName", "Lcom/intellij/docker/agent/DockerAgentRepositoryConfig;", "imageName", "", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nRemoteDockerRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void logWarnOrErrorIfTestMode(Throwable ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(ex);
            } else {
                LOG.warn(ex);
            }
        }

        @JvmStatic
        @NotNull
        public final RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config2, @Nullable Project project) throws ServerRuntimeException {
            RemoteDockerRuntime remoteDockerRuntime;
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            try {
                remoteDockerRuntime = RemoteDockerRuntimesManager.Companion.getInstance(project).createRuntime(config2).get();
            }
            catch (ExecutionException ex) {
                Throwable throwable = ex.getCause();
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                throw ex;
            }
            return remoteDockerRuntime;
        }

        private final DockerAgentRepositoryConfig forImageName(String imageName) {
            DockerRepoTag dockerRepoTag = DockerRepoTag.fromString(imageName);
            Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
            DockerRepoTag repoTag = dockerRepoTag;
            DockerAgentRepositoryConfig dockerAgentRepositoryConfig = repoTag.toAgentRepositoryConfig();
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentRepositoryConfig, (String)"toAgentRepositoryConfig(...)");
            return dockerAgentRepositoryConfig;
        }

        public static final /* synthetic */ void access$logWarnOrErrorIfTestMode(Companion $this, Throwable ex) {
            $this.logWarnOrErrorIfTestMode(ex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

