/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.stylelint.StylelintBundle;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StylelintPackage {
    private static final String UNDEFINED_VERSION = "<unknown>";
    private final Project myProject;
    private final NodePackage myPkg;
    private Ref<SemVer> myVersionRef;

    private StylelintPackage(@NotNull Project project, @NotNull NodePackage pkg) {
        if (project == null) {
            StylelintPackage.$$$reportNull$$$0(0);
        }
        if (pkg == null) {
            StylelintPackage.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPkg = pkg;
    }

    public void addMainEntryJsFile(@NotNull NodeTargetRun targetRun) throws ExecutionException {
        if (targetRun == null) {
            StylelintPackage.$$$reportNull$$$0(2);
        }
        if (this.myPkg instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)this.myPkg).addYarnRunToCommandLine(targetRun, null, false);
        } else {
            File file = this.myPkg.findBinFile("stylelint", "bin/stylelint.mjs");
            if (file == null) {
                throw new ExecutionException(StylelintBundle.message("specify.stylelint.package.correctly.dialog.message", new Object[0]));
            }
            targetRun.getCommandLineBuilder().addParameter(targetRun.requestUploadProjectRootAndGetPath(file.getAbsolutePath()));
        }
    }

    @NotNull
    public static StylelintPackage fromNodePackage(@NotNull Project project, @NotNull NodePackage pkg) {
        if (project == null) {
            StylelintPackage.$$$reportNull$$$0(3);
        }
        if (pkg == null) {
            StylelintPackage.$$$reportNull$$$0(4);
        }
        return new StylelintPackage(project, pkg);
    }

    @NotNull
    public NodePackage getPackage() {
        NodePackage nodePackage = this.myPkg;
        if (nodePackage == null) {
            StylelintPackage.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @NotNull
    public String getVersionStr() {
        SemVer version = this.getVersion();
        return version != null ? version.getRawVersion() : UNDEFINED_VERSION;
    }

    @Nullable
    public SemVer getVersion() {
        Ref versionRef = this.myVersionRef;
        if (versionRef == null) {
            this.myVersionRef = versionRef = Ref.create((Object)this.myPkg.getVersion(this.myProject));
        }
        return (SemVer)versionRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintPackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMainEntryJsFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromNodePackage";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

