/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.protocol;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.ViewableExKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\r\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdclient/protocol/PermittedModalitiesImpl;", "Lcom/intellij/openapi/application/ModalityStateListener;", "Lcom/jetbrains/rdclient/protocol/IPermittedModalities;", "application", "Lcom/intellij/openapi/application/Application;", "<init>", "(Lcom/intellij/openapi/application/Application;)V", "allowedModalities", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/intellij/openapi/application/ModalityState;", "currentModality", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "myListener", "com/jetbrains/rdclient/protocol/PermittedModalitiesImpl$myListener$1", "Lcom/jetbrains/rdclient/protocol/PermittedModalitiesImpl$myListener$1;", "viewPermittedModality", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "handler", "Lkotlin/Function2;", "assertNoHungModalities", "beforeModalityStateChanged", "entering", "", "modalEntity", "", "allowPumpProtocolUnderCurrentModality", "allowPumpProtocolForComponent", "component", "Ljava/awt/Component;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "pushModality", "added", "popModalityIfLast", "removed", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nPermittedModalitiesImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermittedModalitiesImpl.kt\ncom/jetbrains/rdclient/protocol/PermittedModalitiesImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n14#2:105\n*S KotlinDebug\n*F\n+ 1 PermittedModalitiesImpl.kt\ncom/jetbrains/rdclient/protocol/PermittedModalitiesImpl\n*L\n28#1:105\n*E\n"})
public final class PermittedModalitiesImpl
implements ModalityStateListener,
IPermittedModalities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final ViewableList<ModalityState> allowedModalities;
    @NotNull
    private final IPropertyView<ModalityState> currentModality;
    @NotNull
    private final myListener.1 myListener;
    @NotNull
    private static final Logger LOG;

    public PermittedModalitiesImpl(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
        this.allowedModalities = new ViewableList(null, 1, null);
        this.currentModality = PropertyCombinatorsKt.map((IPropertyView)ViewableExKt.viewableTail((IViewableList)((IViewableList)this.allowedModalities)), PermittedModalitiesImpl::currentModality$lambda$0);
        this.myListener = new Activatable(this){
            final /* synthetic */ PermittedModalitiesImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void showNotify() {
                this.this$0.allowPumpProtocolUnderCurrentModality();
            }
        };
        Disposable disposable = () -> PermittedModalitiesImpl._init_$lambda$1(this);
        LaterInvocator.addModalityStateListener((ModalityStateListener)this, (Disposable)disposable);
        Disposer.register((Disposable)((Disposable)this.application), (Disposable)disposable);
    }

    @Override
    public void viewPermittedModality(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super ModalityState, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.currentModality.view(lifetime, handler);
    }

    private final void assertNoHungModalities() {
        LOG.assertTrue(this.allowedModalities.size() == 0 && Intrinsics.areEqual((Object)this.currentModality.getValue(), (Object)ModalityState.nonModal()), (Object)"modality stack must be empty");
    }

    public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
        Intrinsics.checkNotNullParameter((Object)modalEntity, (String)"modalEntity");
        if (!entering) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.popModalityIfLast(modalityState);
        }
    }

    @Override
    public void allowPumpProtocolUnderCurrentModality() {
        if (!LaterInvocator.isInModalContext()) {
            return;
        }
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState current = modalityState;
        this.pushModality(current);
    }

    @Override
    public void allowPumpProtocolForComponent(@NotNull Component component, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        LOG.assertTrue(!Disposer.isDisposed((Disposable)parentDisposable), (Object)"!Disposer.isDisposed(parentDisposable)");
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ThreadingAssertions.assertEventDispatchThread();
            }
        });
        UiNotifyConnector.Once connector = UiNotifyConnector.Once.Companion.installOn(component, (Activatable)this.myListener);
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)connector));
    }

    private final void pushModality(ModalityState added) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.allowedModalities.contains((Object)added)) {
            return;
        }
        this.allowedModalities.add((Object)added);
    }

    private final void popModalityIfLast(ModalityState removed) {
        ThreadingAssertions.assertEventDispatchThread();
        ModalityState last = (ModalityState)CollectionsKt.lastOrNull((List)((List)this.allowedModalities));
        if (Intrinsics.areEqual((Object)last, (Object)removed)) {
            this.allowedModalities.remove(this.allowedModalities.size() - 1);
        }
    }

    private static final ModalityState currentModality$lambda$0(ModalityState it) {
        ModalityState modalityState = it;
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.nonModal();
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"nonModal(...)");
        }
        return modalityState;
    }

    private static final void _init_$lambda$1(PermittedModalitiesImpl this$0) {
        this$0.assertNoHungModalities();
        while (this$0.allowedModalities.size() > 0) {
            this$0.popModalityIfLast((ModalityState)CollectionsKt.last((List)((List)this$0.allowedModalities)));
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PermittedModalitiesImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/protocol/PermittedModalitiesImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "assertNoHungModalities", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void assertNoHungModalities() {
            PermittedModalitiesImpl permittedModalities = IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null);
            permittedModalities.assertNoHungModalities();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

