/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints;

import com.intellij.microservices.url.Authority;
import com.intellij.python.endpoints.HttpEndpointHandler;
import com.intellij.python.endpoints.HttpRouter;
import com.intellij.python.endpoints.HttpRouterProvider;
import com.intellij.python.endpoints.RenderedEndpoint;
import com.intellij.python.endpoints.RoutingTableRecord;
import com.intellij.python.endpoints.WebStructureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0012\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/python/endpoints/WebApplication;", "", "provider", "Lcom/intellij/python/endpoints/HttpRouterProvider;", "rootRouter", "Lcom/intellij/python/endpoints/HttpRouter;", "<init>", "(Lcom/intellij/python/endpoints/HttpRouterProvider;Lcom/intellij/python/endpoints/HttpRouter;)V", "getProvider", "()Lcom/intellij/python/endpoints/HttpRouterProvider;", "getRootRouter", "()Lcom/intellij/python/endpoints/HttpRouter;", "endpoints", "", "Lcom/intellij/python/endpoints/RenderedEndpoint;", "getEndpoints", "()Ljava/util/Collection;", "endpoints$delegate", "Lkotlin/Lazy;", "title", "", "getTitle", "()Ljava/lang/String;", "authorities", "", "Lcom/intellij/microservices/url/Authority$Exact;", "getAuthorities", "()Ljava/util/List;", "authorities$delegate", "renderEndpoints", "intellij.python.endpoints"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebStructure.kt\ncom/intellij/python/endpoints/WebApplication\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1863#2,2:244\n1863#2:246\n1755#2,3:247\n1864#2:251\n1#3:250\n*S KotlinDebug\n*F\n+ 1 WebStructure.kt\ncom/intellij/python/endpoints/WebApplication\n*L\n219#1:244,2\n223#1:246\n224#1:247,3\n223#1:251\n*E\n"})
public final class WebApplication {
    @NotNull
    private final HttpRouterProvider provider;
    @NotNull
    private final HttpRouter rootRouter;
    @NotNull
    private final Lazy endpoints$delegate;
    @NotNull
    private final Lazy authorities$delegate;

    public WebApplication(@NotNull HttpRouterProvider provider, @NotNull HttpRouter rootRouter) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)rootRouter, (String)"rootRouter");
        this.provider = provider;
        this.rootRouter = rootRouter;
        this.endpoints$delegate = LazyKt.lazy(() -> WebApplication.endpoints_delegate$lambda$0(this));
        this.authorities$delegate = LazyKt.lazy(() -> WebApplication.authorities_delegate$lambda$1(this));
    }

    @NotNull
    public final HttpRouterProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final HttpRouter getRootRouter() {
        return this.rootRouter;
    }

    @NotNull
    public final Collection<RenderedEndpoint> getEndpoints() {
        Lazy lazy = this.endpoints$delegate;
        return (Collection)lazy.getValue();
    }

    @NotNull
    public final String getTitle() {
        return this.rootRouter.getTitle();
    }

    @NotNull
    public final List<Authority.Exact> getAuthorities() {
        Lazy lazy = this.authorities$delegate;
        return (List)lazy.getValue();
    }

    private final List<RenderedEndpoint> renderEndpoints() {
        List endpoints = new ArrayList();
        RoutingTableRecord genesis = new RoutingTableRecord(null, "", this.rootRouter);
        ArrayDeque route = new ArrayDeque((Collection)CollectionsKt.listOf((Object)genesis));
        WebApplication.renderEndpoints$process(endpoints, this, "", this.rootRouter, (ArrayDeque<RoutingTableRecord>)route);
        Comparator comparator2 = new Comparator(){

            public final int compare(T a2, T b2) {
                RenderedEndpoint it = (RenderedEndpoint)a2;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath().getPresentation());
                it = (RenderedEndpoint)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath().getPresentation())));
            }
        };
        return CollectionsKt.sortedWith((Iterable)endpoints, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a2, T b2) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a2, b2);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    RenderedEndpoint it = (RenderedEndpoint)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)CollectionsKt.sorted((Iterable)it.getMethods()).toString());
                    it = (RenderedEndpoint)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)CollectionsKt.sorted((Iterable)it.getMethods()).toString())));
                }
                return n;
            }
        });
    }

    private static final List endpoints_delegate$lambda$0(WebApplication this$0) {
        return this$0.renderEndpoints();
    }

    private static final List authorities_delegate$lambda$1(WebApplication this$0) {
        return this$0.provider.getAuthorities(this$0.rootRouter);
    }

    private static final void renderEndpoints$process(List<RenderedEndpoint> endpoints, WebApplication this$0, String parentPath, HttpRouter httpRouter, ArrayDeque<RoutingTableRecord> route) {
        String nodeBasePath = parentPath + httpRouter.getPrefixPath();
        Iterable $this$forEach$iv = httpRouter.getEndpointHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpEndpointHandler handler2 = (HttpEndpointHandler)element$iv;
            boolean bl = false;
            ((Collection)endpoints).add(WebStructureKt.renderEndpoint(this$0.provider, this$0.getAuthorities(), nodeBasePath, (Collection)route, handler2));
        }
        $this$forEach$iv = httpRouter.getRoutingTable();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            boolean bl;
            RoutingTableRecord record;
            block6: {
                record = (RoutingTableRecord)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)route;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv2 = object.next();
                        RoutingTableRecord it = (RoutingTableRecord)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getNextRouter(), (Object)record.getNextRouter())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            Object it = object = record.getPath();
            boolean bl4 = false;
            Object object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
            if (object2 == null) {
                object2 = record.getNextRouter().getDefaultMountPath();
            }
            Object mountPath = object2;
            route.addLast((Object)record);
            WebApplication.renderEndpoints$process(endpoints, this$0, nodeBasePath + (String)mountPath, record.getNextRouter(), route);
            route.removeLast();
        }
    }
}

