/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.modelChoice;

import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceCardsUsageCollector;
import com.intellij.python.huggingFace.modelChoice.ui.HfModelSelectionDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/huggingFace/modelChoice/HfOpenModelSelectionWindowAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "isPythonOrJupyter", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFileExtension", "", "intellij.python.huggingFace"})
@ApiStatus.Internal
public final class HfOpenModelSelectionWindowAction
extends DumbAwareAction
implements JupyterEditorAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        HuggingFaceCardsUsageCollector.ActiveFileType activeFileType;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        String string = this.getFileExtension(editor2);
        if (Intrinsics.areEqual((Object)string, (Object)"py")) {
            activeFileType = HuggingFaceCardsUsageCollector.ActiveFileType.PY;
        } else if (Intrinsics.areEqual((Object)string, (Object)"ipynb")) {
            activeFileType = HuggingFaceCardsUsageCollector.ActiveFileType.IPYNB;
        } else {
            return;
        }
        HuggingFaceCardsUsageCollector.ActiveFileType fileExtensionForTracking = activeFileType;
        HfModelSelectionDialog dialog = new HfModelSelectionDialog(project2, fileExtensionForTracking);
        dialog.show();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!this.isPythonOrJupyter(editor)) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setEnabledAndVisible(Registry.Companion.is("hugging.face.model.selection", false));
        }
    }

    private final boolean isPythonOrJupyter(Editor editor) {
        String fileExtension = this.getFileExtension(editor);
        return Intrinsics.areEqual((Object)fileExtension, (Object)"py") || Intrinsics.areEqual((Object)fileExtension, (Object)"ipynb");
    }

    private final String getFileExtension(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiFile psi = psiFile;
        VirtualFile virtualFile = psi.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return virtualFile2.getExtension();
    }
}

