/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.python.pro.cython.parser.CythonTokenTypes;
import com.intellij.python.pro.cython.psi.CythonNameDecl;
import com.intellij.python.pro.cython.psi.CythonNamedElement;
import com.intellij.python.pro.cython.psi.CythonNamedParameter;
import com.intellij.python.pro.cython.psi.CythonPsiUtil;
import com.intellij.python.pro.cython.psi.CythonRecursiveElementVisitor;
import com.intellij.python.pro.cython.psi.CythonScopeOwner;
import com.intellij.python.pro.cython.psi.CythonSimpleBaseTypeDecl;
import com.intellij.python.pro.cython.psi.CythonVariable;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonStubElementTypes;
import com.intellij.python.pro.cython.types.CythonFunctionType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyParameterListImpl;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonFunction
extends PyFunctionImpl
implements CythonNamedElement,
CythonScopeOwner {
    private static final TokenSet CDEF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CythonTokenTypes.CDEF_KEYWORD, CythonTokenTypes.CPDEF_KEYWORD});

    public CythonFunction(ASTNode astNode) {
        super(astNode);
    }

    public CythonFunction(PyFunctionStub stub) {
        super(stub, CythonStubElementTypes.FUNCTION_DECLARATION);
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            CythonFunction.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = CythonPsiUtil.setName(this, name);
        if (psiElement == null) {
            CythonFunction.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Nullable
    public ASTNode getNameNode() {
        return CythonPsiUtil.getNameNode(this);
    }

    @NotNull
    public PyParameterList getParameterList() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            PyParameterList pyParameterList = super.getParameterList();
            if (pyParameterList == null) {
                CythonFunction.$$$reportNull$$$0(2);
            }
            return pyParameterList;
        }
        PyParameterList parameterList = this.getNameDecl().getParameterList();
        if (parameterList == null) {
            return new PyParameterListImpl((ASTNode)new DummyParameterList(PyElementTypes.PARAMETER_LIST, ""));
        }
        PyParameterList pyParameterList = parameterList;
        if (pyParameterList == null) {
            CythonFunction.$$$reportNull$$$0(3);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public CythonNameDecl getNameDecl() {
        CythonNameDecl decl = (CythonNameDecl)((Object)this.findChildByClass(CythonNameDecl.class));
        if (decl == null) assert (false) : "No name declaration in Cython function";
        CythonNameDecl cythonNameDecl = decl;
        if (cythonNameDecl == null) {
            CythonFunction.$$$reportNull$$$0(4);
        }
        return cythonNameDecl;
    }

    public PyAnnotation getAnnotation() {
        return (PyAnnotation)this.getNameDecl().getStubOrPsiChild((IStubElementType)PyStubElementTypes.ANNOTATION);
    }

    @Override
    public boolean isForwardDeclaration() {
        return this.getStatementList().getStatements().length == 0;
    }

    @Override
    public List<? extends CythonNamedElement> getCythonNamedElements() {
        final ArrayList<CythonNamedParameter> result2 = new ArrayList<CythonNamedParameter>();
        this.getStatementList().accept((PsiElementVisitor)new CythonRecursiveElementVisitor(){

            @Override
            public void visitCythonVariable(CythonVariable node) {
                result2.add(node);
            }
        });
        for (PyParameter param : this.getParameterList().getParameters()) {
            if (!(param instanceof CythonNamedParameter)) continue;
            result2.add((CythonNamedParameter)param);
        }
        return result2;
    }

    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            CythonFunction.$$$reportNull$$$0(5);
        }
        if (key == null) {
            CythonFunction.$$$reportNull$$$0(6);
        }
        return new CythonFunctionType(this);
    }

    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PsiElement psiElement;
        ASTNode hintNode;
        if (context == null) {
            CythonFunction.$$$reportNull$$$0(7);
        }
        if (key == null) {
            CythonFunction.$$$reportNull$$$0(8);
        }
        if ((hintNode = this.getNode().findChildByType((IElementType)CythonElementTypes.SIMPLE_BASE_TYPE_DECL)) != null && (psiElement = hintNode.getPsi()) instanceof CythonSimpleBaseTypeDecl) {
            CythonSimpleBaseTypeDecl hint = (CythonSimpleBaseTypeDecl)psiElement;
            return context.getType((PyTypedElement)hint);
        }
        return super.getReturnType(context, key);
    }

    public boolean isCythonLevel() {
        return this.findChildByType(CDEF_TOKENS) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/cython/psi/CythonFunction";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/cython/psi/CythonFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameDecl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class DummyParameterList
    extends LazyParseableElement {
        DummyParameterList(@NotNull IElementType type, CharSequence text2) {
            if (type == null) {
                DummyParameterList.$$$reportNull$$$0(0);
            }
            super(type, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/python/pro/cython/psi/CythonFunction$DummyParameterList", "<init>"));
        }
    }
}

