/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.localization;

import com.intellij.jinja.Jinja2TemplateUtil;
import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.util.DjangoTemplateUtil;
import com.jetbrains.localization.psi.impl.LocaleFile;
import com.jetbrains.localization.psi.impl.LocaleMsgid;
import com.jetbrains.localization.psi.impl.LocaleSection;
import java.util.HashSet;
import java.util.Set;

public final class LocaleLineMarkerUtils {
    private LocaleLineMarkerUtils() {
    }

    public static Set<LocaleMsgid> getReferences(PsiElement element) {
        HashSet<LocaleMsgid> result2 = new HashSet<LocaleMsgid>();
        TextRange textRange = LocaleLineMarkerUtils.getTextRange(element);
        String text2 = LocaleLineMarkerUtils.getLocaleText(element, textRange);
        if (text2 != null) {
            VirtualFile root;
            Set<String> variants = LocaleLineMarkerUtils.getVariants(text2);
            Project project = element.getProject();
            DjangoFacet facet = DjangoFacet.getInstance(element);
            if (facet != null && (root = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
                PsiDirectory rootDir = PsiManager.getInstance((Project)project).findDirectory(root);
                if (rootDir == null) {
                    return result2;
                }
                PsiDirectory localeDir = rootDir.findSubdirectory("locale");
                if (localeDir == null) {
                    return result2;
                }
                for (PsiDirectory subDirectory : localeDir.getSubdirectories()) {
                    for (PsiDirectory messageDir : subDirectory.getSubdirectories()) {
                        PsiFile file;
                        if (!"LC_MESSAGES".equals(messageDir.getName()) || !((file = messageDir.findFile("django.po")) instanceof LocaleFile)) continue;
                        for (LocaleSection section : ((LocaleFile)file).getSections()) {
                            for (LocaleMsgid id : section.getIds()) {
                                if (id == null || !variants.contains(id.toString())) continue;
                                result2.add(id);
                            }
                        }
                    }
                }
            }
        }
        return result2;
    }

    private static Set<String> getVariants(String toTransform) {
        HashSet<String> result2 = new HashSet<String>();
        char[] cArray = "sdbcoxXneEfFgG".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            result2.add(toTransform.replaceAll("\\{\\{ *([^ \n\r\t}{]+) *\\}\\}", "\\%\\($1\\)" + ch));
        }
        return result2;
    }

    public static TextRange getTextRange(PsiElement element) {
        DjangoTagElementImpl startTag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class, (boolean)false);
        if (startTag != null) {
            DjangoTagName parentTagName = Jinja2TemplateUtil.getTagNameElement(startTag);
            if (parentTagName != null && parentTagName.getTagName().equals("trans") && element instanceof Jinja2StringLiteral) {
                return element.getTextRange();
            }
            DjangoTagElementImpl endTag = DjangoTemplateUtil.findEndTag("plural", startTag);
            if (endTag == null) {
                endTag = DjangoTemplateUtil.findEndTag("endblocktrans", startTag);
            }
            if (endTag == null) {
                endTag = DjangoTemplateUtil.findEndTag("endblocktranslate", startTag);
            }
            if (endTag != null) {
                int endOffset = startTag.getTextRange().getEndOffset();
                return TextRange.create((int)endOffset, (int)endTag.getTextRange().getStartOffset());
            }
        }
        return null;
    }

    private static String getLocaleText(PsiElement element, TextRange textRange) {
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        String text2 = null;
        if (document != null && textRange != null) {
            text2 = element instanceof Jinja2StringLiteral ? ((Jinja2StringLiteral)element).getStringValue() : document.getText(textRange);
            text2 = (String)StringUtil.escaper((boolean)true, (String)"\"").fun((Object)text2);
        }
        return text2;
    }
}

