/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.ProfileReaderKt;
import com.intellij.python.profiler.ProfileSessionKt;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.PythonProfilerCustomizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"openSnapshotInEditor", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "pstatFile", "", "intellij.python.profiler"})
public final class OpenSnapshotKt {
    public static final void openSnapshotInEditor(@Nullable Sdk sdk, @NotNull Project project, @NotNull String pstatFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pstatFile, (String)"pstatFile");
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        ProfileStats profileStats = ProfileReaderKt.openProfile(sdk, pstatFile, virtualFileArray);
        if (profileStats != null) {
            ProfileSessionKt.openProfileResultsInEditor(project, profileStats, pstatFile, ProfileSessionKt.getIdentityFunction());
            for (PythonProfilerCustomizer ppc : (PythonProfilerCustomizer[])PythonProfilerCustomizer.Companion.getEP_NAME().getExtensions()) {
                ppc.postprocessProfile(project, profileStats);
            }
        }
    }
}

