/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.python.remoteInterpreter.PyHelpersUpload;
import com.intellij.python.remoteInterpreter.PyRemoteSocketToLocalHostProviderFactory;
import com.intellij.python.remoteInterpreter.PySshCommandLineStateUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteProcessHandlerUtil {
    @NotNull
    public static SshExecProcessWithHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws InterruptedException, ExecutionException {
        if (commandLine == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(0);
        }
        if (sdkAdditionalData == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(2);
        }
        pathMapper = PythonRemoteInterpreterManager.appendBasicMappings((Project)project, (PyRemotePathMapper)pathMapper, (RemoteSdkAdditionalData)sdkAdditionalData);
        RemoteCredentials credentials = sdkAdditionalData.getRemoteCredentials(project, true);
        final ListenableFuture<?> future = PyHelpersUpload.uploadAllHelpers(null, null, credentials, (RemoteSdkProperties)sdkAdditionalData, false);
        final Ref ref = new Ref(null);
        try {
            new Task.Modal(project, PythonRemoteInterpreterBundle.message("checking.remote.helpers.indicator.title", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        future.get(15L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new PythonRemoteInterpreterManager.PyHelpersNotReadyException((Throwable)e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onThrowable(@NotNull Throwable e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (e instanceof PythonRemoteInterpreterManager.PyHelpersNotReadyException) {
                        PythonRemoteInterpreterManager.PyHelpersNotReadyException notReadyException = (PythonRemoteInterpreterManager.PyHelpersNotReadyException)e;
                        ref.set((Object)notReadyException);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        }
        catch (RuntimeException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (!ref.isNull()) {
            throw (PythonRemoteInterpreterManager.PyHelpersNotReadyException)ref.get();
        }
        SshExecProcessWithHandler sshExecProcessWithHandler = PyRemoteProcessHandlerUtil.startRemoteProcess(project, credentials, (RemoteSdkProperties)sdkAdditionalData, commandLine, pathMapper, sdkAdditionalData.isRunAsRootViaSudo());
        if (sshExecProcessWithHandler == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(3);
        }
        return sshExecProcessWithHandler;
    }

    private static SshExecProcessWithHandler startRemoteProcess(@Nullable Project project, RemoteCredentials credentials, RemoteSdkProperties sdkProperties, GeneralCommandLine commandLine, PyRemotePathMapper pathMapper, boolean runAsRootViaSudo) throws RemoteSdkException {
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider = PyRemoteSocketToLocalHostProviderFactory.ssh(connectionBuilder, sdkProperties);
        PySshCommandLineStateUtil.patchCommandLineForSshSession(commandLine, sdkProperties, pathMapper, sshRemoteSocketProvider);
        commandLine.setExePath(sdkProperties.getInterpreterPath());
        final ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).withSudo((PasswordStringProvider)(runAsRootViaSudo ? new DialogSshSudoPasswordStringProvider(credentials) : null));
        final Ref processRef = new Ref();
        new Task.Modal(project, PythonRemoteInterpreterBundle.message("pycharm.starting.remote.process.dialog.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    processRef.set((Object)builder.start());
                }
                catch (RuntimeException err) {
                    processRef.set((Object)err);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil$2", "run"));
            }
        }.queue();
        Object object = processRef.get();
        if (object instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)object;
            throw re;
        }
        SshExecProcess process = (SshExecProcess)processRef.get();
        String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)sdkProperties);
        PyRemoteProcessHandler processHandler = PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process, (String)fullInterpreterPath, (GeneralCommandLine)commandLine, (PyRemotePathMapper)pathMapper, (PyRemoteSocketToLocalHostProvider)sshRemoteSocketProvider);
        PyRemoteInterpreterUtil.closeOnProcessTermination((ProcessHandler)processHandler, (Closeable)sshRemoteSocketProvider);
        return new SshExecProcessWithHandler(process, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class SshExecProcessWithHandler {
        private final SshExecProcess process;
        private final PyRemoteProcessHandler handler;

        public SshExecProcessWithHandler(@NotNull SshExecProcess process, @NotNull PyRemoteProcessHandler handler2) {
            if (process == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(1);
            }
            this.process = process;
            this.handler = handler2;
        }

        @NotNull
        public SshExecProcess getProcess() {
            SshExecProcess sshExecProcess = this.process;
            if (sshExecProcess == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(2);
            }
            return sshExecProcess;
        }

        @NotNull
        public PyRemoteProcessHandler getHandler() {
            PyRemoteProcessHandler pyRemoteProcessHandler = this.handler;
            if (pyRemoteProcessHandler == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(3);
            }
            return pyRemoteProcessHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil$SshExecProcessWithHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteProcessHandlerUtil$SshExecProcessWithHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcess";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

