/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.python.scientific.PySciProjectComponent;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.actions.CloseAllPlotsAction;
import com.intellij.python.scientific.actions.ClosePlotAction;
import com.intellij.python.scientific.actions.SaveAllPlotsAction;
import com.intellij.python.scientific.actions.SaveAsHtmlAction;
import com.intellij.python.scientific.actions.SaveAsImageAction;
import com.intellij.python.scientific.figures.DockableContentFigureFactory;
import com.intellij.python.scientific.figures.Figure;
import com.intellij.python.scientific.figures.PyPlotInfo;
import com.intellij.python.scientific.figures.WithDockableContent;
import com.intellij.python.scientific.figures.base.FigureBase;
import com.intellij.python.scientific.figures.base.FigureContentPanelBase;
import com.intellij.python.scientific.figures.image.ImageDockableContentFigureFactory;
import com.intellij.python.scientific.figures.image.ImageFigure;
import com.intellij.python.scientific.ui.PyPlotsTabs;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.python.psi.PyUtil;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003;<=B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\fH\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010,\u001a\u00020\fH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020!H\u0016J\u0010\u00102\u001a\u00020!2\u0006\u0010,\u001a\u00020\fH\u0002J\u0019\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b6J\u0006\u00107\u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00108\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006>"}, d2={"Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "interactivePlotCount", "", "tabToPlotInfo", "", "Lcom/intellij/ui/tabs/TabInfo;", "Lcom/intellij/python/scientific/figures/PyPlotInfo;", "tabs", "Lcom/intellij/ui/tabs/JBTabs;", "getTabs$intellij_python_scientific", "()Lcom/intellij/ui/tabs/JBTabs;", "myToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "myDockableContentFigureFactories", "", "Lcom/intellij/python/scientific/figures/DockableContentFigureFactory;", "value", "lastPlotIndex", "getLastPlotIndex", "()I", "myDockContainer", "Lcom/intellij/python/scientific/ui/PyPlotToolWindow$MyDockContainer;", "wasResized", "", "shouldResizeInInit", "init", "", "toolWindow", "addDockableContentFigureFactory", "factory", "addExternalImage", "image", "Ljava/awt/image/BufferedImage;", "addFigure", "figure", "Lcom/intellij/python/scientific/figures/base/FigureBase;", "addInteractivePlot", "tabInfo", "removeInteractivePlot", "findTabInfo", "searchKey", "", "dispose", "disposeTab", "getContentPanel", "Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase;", "project", "getContentPanel$intellij_python_scientific", "focusLastFigure", "selectedInfo", "getSelectedInfo", "()Lcom/intellij/ui/tabs/TabInfo;", "MyDragOutDelegate", "MyDockContainer", "Companion", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nPyPlotToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPlotToolWindow.kt\ncom/intellij/python/scientific/ui/PyPlotToolWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n1863#2,2:438\n*S KotlinDebug\n*F\n+ 1 PyPlotToolWindow.kt\ncom/intellij/python/scientific/ui/PyPlotToolWindow\n*L\n189#1:438,2\n*E\n"})
public final class PyPlotToolWindow
extends JPanel
implements DumbAware,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    private int interactivePlotCount;
    @NotNull
    private final Map<TabInfo, PyPlotInfo> tabToPlotInfo;
    @NotNull
    private final JBTabs tabs;
    @Nullable
    private ToolWindow myToolWindow;
    @NotNull
    private final List<DockableContentFigureFactory> myDockableContentFigureFactories;
    private int lastPlotIndex;
    @Nullable
    private MyDockContainer myDockContainer;
    private boolean wasResized;
    private boolean shouldResizeInInit;
    @NotNull
    private static final Logger LOG;
    public static final int PREVIEW_SIZE = 80;
    private static final int MAX_INTERACTIVE_PLOTS = 2;
    private static final int PREFERED_WIDTH = 750;
    private static final int PREFERED_HEIGHT = 550;

    public PyPlotToolWindow(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        super(new BorderLayout());
        this.myProject = myProject;
        this.tabToPlotInfo = new LinkedHashMap();
        this.myDockableContentFigureFactories = new ArrayList();
        this.tabs = (JBTabs)new PyPlotsTabs(this.myProject);
        ((PyPlotsTabs)this.tabs).getPresentation().setTabsPosition(JBTabsPosition.right);
        SaveAllPlotsAction saveAllAction = new SaveAllPlotsAction(this);
        CloseAllPlotsAction closeAllPlotsAction = new CloseAllPlotsAction(this);
        String[] stringArray = new String[]{"alt DELETE"};
        closeAllPlotsAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])stringArray), ((PyPlotsTabs)this.tabs).getComponent());
        AnAction[] anActionArray = new AnAction[]{new SaveAsImageAction(this), new SaveAsHtmlAction(this), Separator.create(), saveAllAction, closeAllPlotsAction};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ((PyPlotsTabs)this.tabs).setPopupGroup((ActionGroup)actionGroup, "popup", true);
        ((PyPlotsTabs)this.tabs).getPresentation().setTabDraggingEnabled(true);
        ((PyPlotsTabs)this.tabs).addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (newSelection == null) {
                    return;
                }
                this.addInteractivePlot(newSelection);
            }

            public void tabRemoved(TabInfo tabInfo) {
                Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
                this.disposeTab(tabInfo);
            }
        });
        ((PyPlotsTabs)this.tabs).getPresentation().setEmptyText(PyScientificBundle.message("plots.empty.window", new Object[0]));
        this.add(((PyPlotsTabs)this.tabs).getComponent());
        this.addDockableContentFigureFactory(new ImageDockableContentFigureFactory(this.myProject));
        anActionArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(39, 0), null)};
        DumbAwareAction.create(arg_0 -> PyPlotToolWindow._init_$lambda$1(arg_0 -> PyPlotToolWindow._init_$lambda$0(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet((Shortcut[])anActionArray), (JComponent)this.tabs);
        anActionArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(37, 0), null)};
        DumbAwareAction.create(arg_0 -> PyPlotToolWindow._init_$lambda$3(arg_0 -> PyPlotToolWindow._init_$lambda$2(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet((Shortcut[])anActionArray), (JComponent)this.tabs);
        DumbAwareAction.create(arg_0 -> PyPlotToolWindow._init_$lambda$5(arg_0 -> PyPlotToolWindow._init_$lambda$4(this, arg_0), arg_0)).registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.tabs);
    }

    @NotNull
    public final JBTabs getTabs$intellij_python_scientific() {
        return this.tabs;
    }

    public final int getLastPlotIndex() {
        return this.lastPlotIndex;
    }

    public final void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setHelpId("reference.toolWindows.PyDataView");
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content = contentFactory.createContent((JComponent)this, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        toolWindow.getContentManager().addContent(content2);
        this.myToolWindow = toolWindow;
        if (this.shouldResizeInInit && !this.wasResized) {
            ToolWindow toolWindow2 = this.myToolWindow;
            Intrinsics.checkNotNull((Object)toolWindow2);
            PyPlotToolWindow.Companion.resizeToolWindow(toolWindow2);
            this.shouldResizeInInit = false;
            this.wasResized = true;
        }
        if (this.myDockContainer == null) {
            this.myDockContainer = new MyDockContainer(toolWindow);
            DockManager dockManager = DockManager.getInstance((Project)this.myProject);
            MyDockContainer myDockContainer = this.myDockContainer;
            Intrinsics.checkNotNull((Object)myDockContainer);
            dockManager.register((DockContainer)myDockContainer, toolWindow.getDisposable());
        }
    }

    private final void addDockableContentFigureFactory(DockableContentFigureFactory factory2) {
        this.myDockableContentFigureFactories.add(factory2);
    }

    public final void addExternalImage(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ImageFigure figure = ImageFigure.Companion.createDefault(image, this.myProject, null);
        this.addFigure(figure);
        this.focusLastFigure();
    }

    public final void addFigure(@NotNull FigureBase figure) {
        Intrinsics.checkNotNullParameter((Object)figure, (String)"figure");
        TabInfo tabInfo = figure.getTabInfo();
        PyPlotInfo plotInfo = new PyPlotInfo(figure);
        if (this.myToolWindow == null) {
            this.shouldResizeInInit = true;
        } else if (!this.wasResized) {
            ToolWindow toolWindow = this.myToolWindow;
            Intrinsics.checkNotNull((Object)toolWindow);
            PyPlotToolWindow.Companion.resizeToolWindow(toolWindow);
            this.wasResized = true;
        }
        AnAction[] anActionArray = new AnAction[1];
        Intrinsics.checkNotNull((Object)tabInfo);
        anActionArray[0] = new ClosePlotAction(this, tabInfo);
        tabInfo.setTabLabelActions((ActionGroup)new DefaultActionGroup(anActionArray), "unknown");
        if (figure instanceof WithDockableContent) {
            tabInfo.setDragOutDelegate((TabInfo.DragOutDelegate)new MyDragOutDelegate((WithDockableContent)((Object)figure)));
        }
        Object searchKey = plotInfo.getSearchKey();
        ApplicationManager.getApplication().invokeLater(() -> PyPlotToolWindow.addFigure$lambda$7(searchKey, this, tabInfo, plotInfo));
    }

    private final void addInteractivePlot(TabInfo tabInfo) {
        PyPlotInfo plotInfo = this.tabToPlotInfo.get(tabInfo);
        if (plotInfo == null) {
            return;
        }
        if (!plotInfo.isInteractive()) {
            return;
        }
        if (!plotInfo.getWasSelected()) {
            ++this.interactivePlotCount;
            plotInfo.setWasSelected(true);
        } else if (plotInfo.isEditorHidden()) {
            this.tabToPlotInfo.remove(tabInfo);
            plotInfo.reinitComponent();
            this.tabToPlotInfo.put(tabInfo, plotInfo);
            ++this.interactivePlotCount;
        }
        if (this.interactivePlotCount > 2) {
            Iterator<Map.Entry<TabInfo, PyPlotInfo>> iterator2 = this.tabToPlotInfo.entrySet().iterator();
            while (iterator2.hasNext()) {
                PyPlotInfo targetToDispose = iterator2.next().getValue();
                if (targetToDispose.isEditorHidden()) continue;
                targetToDispose.disposeComponent();
                --this.interactivePlotCount;
                return;
            }
        }
    }

    private final void removeInteractivePlot(TabInfo tabInfo) {
        PyPlotInfo plotInfo = this.tabToPlotInfo.get(tabInfo);
        if (plotInfo != null && plotInfo.isInteractive() && !plotInfo.isEditorHidden()) {
            --this.interactivePlotCount;
        }
        this.tabToPlotInfo.remove(tabInfo);
    }

    private final TabInfo findTabInfo(Object searchKey) {
        for (Map.Entry<TabInfo, PyPlotInfo> entry : this.tabToPlotInfo.entrySet()) {
            TabInfo key = entry.getKey();
            PyPlotInfo value2 = entry.getValue();
            Object tabInfoSearchKey = value2.getSearchKey();
            if (tabInfoSearchKey == null || !Intrinsics.areEqual((Object)tabInfoSearchKey, (Object)searchKey)) continue;
            return key;
        }
        return null;
    }

    public void dispose() {
        Set infos = new HashSet(this.tabToPlotInfo.keySet());
        for (TabInfo info : infos) {
            this.disposeTab(info);
        }
    }

    private final void disposeTab(TabInfo tabInfo) {
        this.removeInteractivePlot(tabInfo);
        JComponent component2 = tabInfo.getComponent();
        if (component2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)component2));
        }
    }

    @Nullable
    public final FigureContentPanelBase getContentPanel$intellij_python_scientific(@Nullable Project project) {
        TabInfo info = this.tabs.getSelectedInfo();
        return Companion.getTabContent$intellij_python_scientific(project, info);
    }

    public final void focusLastFigure() {
        ClientAppSession clientAppSession = (ClientAppSession)CollectionsKt.singleOrNull((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER));
        ClientId.Companion.withClientId((ClientId)(clientAppSession != null ? clientAppSession.getClientId() : null), () -> PyPlotToolWindow.focusLastFigure$lambda$9(this));
    }

    @TestOnly
    @NotNull
    public final TabInfo getSelectedInfo() {
        TabInfo selected = this.tabs.getSelectedInfo();
        TabInfo tabInfo = this.tabs.getTabAt(0);
        Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"getTabAt(...)");
        TabInfo first2 = tabInfo;
        TabInfo tabInfo2 = selected;
        if (tabInfo2 == null) {
            tabInfo2 = first2;
        }
        return tabInfo2;
    }

    private static final Unit _init_$lambda$0(PyPlotToolWindow this$0, AnActionEvent it) {
        PyPlotsTabs pyPlotsTabs = (PyPlotsTabs)this$0.tabs;
        TabInfo tabInfo = ((PyPlotsTabs)this$0.tabs).getSelectedInfo();
        Intrinsics.checkNotNull((Object)tabInfo);
        int tabIndexToSelect = Math.min(pyPlotsTabs.getIndexOf(tabInfo) + 1, ((PyPlotsTabs)this$0.tabs).getTabCount() - 1);
        ((PyPlotsTabs)this$0.tabs).select(((PyPlotsTabs)this$0.tabs).getTabAt(tabIndexToSelect), false);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(PyPlotToolWindow this$0, AnActionEvent it) {
        PyPlotsTabs pyPlotsTabs = (PyPlotsTabs)this$0.tabs;
        TabInfo tabInfo = ((PyPlotsTabs)this$0.tabs).getSelectedInfo();
        Intrinsics.checkNotNull((Object)tabInfo);
        int tabIndexToSelect = Math.max(pyPlotsTabs.getIndexOf(tabInfo) - 1, 0);
        ((PyPlotsTabs)this$0.tabs).select(((PyPlotsTabs)this$0.tabs).getTabAt(tabIndexToSelect), false);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$4(PyPlotToolWindow this$0, AnActionEvent it) {
        ((PyPlotsTabs)this$0.tabs).removeTab(((PyPlotsTabs)this$0.tabs).getSelectedInfo());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addFigure$lambda$7(Object $searchKey, PyPlotToolWindow this$0, TabInfo $tabInfo, PyPlotInfo $plotInfo) {
        TabInfo toUpdate = null;
        if ($searchKey != null) {
            toUpdate = this$0.findTabInfo($searchKey);
        }
        this$0.tabToPlotInfo.put($tabInfo, $plotInfo);
        if (toUpdate == null) {
            this$0.tabs.addTab($tabInfo);
            ++this$0.lastPlotIndex;
            int maxPlotsCount = PySciProjectComponent.getInstance(this$0.myProject).getMaxPlotsCount();
            if (this$0.tabs.getTabCount() > maxPlotsCount) {
                List list2 = this$0.tabs.getTabs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
                List forRemove = CollectionsKt.take((Iterable)list2, (int)(this$0.tabs.getTabCount() - maxPlotsCount));
                Iterable $this$forEach$iv = forRemove;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TabInfo it = (TabInfo)element$iv;
                    boolean bl = false;
                    this$0.tabs.removeTab(it);
                }
            }
        } else {
            int tabIndex = this$0.tabs.getIndexOf(toUpdate);
            this$0.tabs.removeTab(toUpdate);
            TabInfo tabInfo = this$0.tabs.addTab($tabInfo, tabIndex);
            Intrinsics.checkNotNull((Object)tabInfo);
        }
        this$0.tabs.select($tabInfo, false);
    }

    private static final Unit focusLastFigure$lambda$9(PyPlotToolWindow this$0) {
        block1: {
            ThreadingAssertions.assertEventDispatchThread();
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.myProject).getToolWindow("Plots");
            if (toolWindow == null) {
                return Unit.INSTANCE;
            }
            ToolWindow window = toolWindow;
            window.setAvailable(true);
            window.show(null);
            Content content = window.getContentManager().getContent(1);
            if (content == null) break block1;
            Content plotsTab = content;
            boolean bl = false;
            window.getContentManager().setSelectedContent(plotsTab);
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final PyPlotToolWindow getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Logger logger2 = Logger.getInstance(PyPlotToolWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J#\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u0014J)\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u001f\u0010$\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/python/scientific/ui/PyPlotToolWindow$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREVIEW_SIZE", "", "MAX_INTERACTIVE_PLOTS", "PREFERED_WIDTH", "PREFERED_HEIGHT", "getInstance", "Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "getTabContent", "Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "getTabContent$intellij_python_scientific", "saveAsFile", "", "bytes", "", "format", "", "saveAsFile$intellij_python_scientific", "resizeToolWindow", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "stretch", "window", "isHorizontalStretching", "", "value", "notifyFinish", "path", "Ljava/nio/file/Path;", "notifyFinish$intellij_python_scientific", "intellij.python.scientific"})
    @SourceDebugExtension(value={"SMAP\nPyPlotToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPlotToolWindow.kt\ncom/intellij/python/scientific/ui/PyPlotToolWindow$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,437:1\n1#2:438\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PyPlotToolWindow getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(PyPlotToolWindow.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (PyPlotToolWindow)object;
        }

        @Nullable
        public final FigureContentPanelBase getTabContent$intellij_python_scientific(@Nullable Project project, @Nullable TabInfo info) {
            JComponent component2;
            TabInfo tabInfo = info;
            JComponent jComponent = component2 = tabInfo != null ? tabInfo.getComponent() : null;
            if (info != null && project != null && component2 instanceof FigureContentPanelBase) {
                return (FigureContentPanelBase)component2;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void saveAsFile$intellij_python_scientific(@Nullable byte[] bytes, @Nullable Project project, @NotNull String format2) {
            VirtualFile virtualFile;
            FileSaverDialog chooser;
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            if (bytes == null) {
                LOG.error("Can't obtain image content");
                return;
            }
            String[] stringArray = new String[]{format2};
            FileSaverDescriptor descriptor = new FileSaverDescriptor(PyScientificBundle.message("plots.select.file.to.save.plot", new Object[0]), "", stringArray);
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
            FileSaverDialog fileSaverDialog2 = chooser = fileSaverDialog;
            Object object = project;
            if (object != null && (object = object.getBasePath()) != null) {
                void it;
                Object object2 = object;
                FileSaverDialog fileSaverDialog3 = fileSaverDialog2;
                boolean bl = false;
                virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)it);
                fileSaverDialog2 = fileSaverDialog3;
            } else {
                virtualFile = null;
            }
            VirtualFileWrapper wrapper = fileSaverDialog2.save(virtualFile, "myplot");
            if (wrapper == null) {
                return;
            }
            PyUtil.runWithProgress((Project)project, (String)PyScientificBundle.message("python.sci.view.saving.as.file.action", new Object[0]), (boolean)false, (boolean)true, arg_0 -> Companion.saveAsFile$lambda$2(arg_0 -> Companion.saveAsFile$lambda$1(wrapper, bytes, arg_0), arg_0));
        }

        private final void resizeToolWindow(ToolWindow toolWindow) {
            if (toolWindow instanceof ToolWindowEx) {
                int current_width = toolWindow.getComponent().getWidth();
                int current_height = toolWindow.getComponent().getHeight();
                if (current_width < 750) {
                    this.stretch(toolWindow, true, 750 - current_width);
                }
                if (current_height < 550) {
                    this.stretch(toolWindow, false, 550 - current_height);
                }
            }
        }

        private final void stretch(ToolWindow window, boolean isHorizontalStretching, int value2) {
            ToolWindowAnchor toolWindowAnchor = window.getAnchor();
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"getAnchor(...)");
            ToolWindowAnchor anchor = toolWindowAnchor;
            if (isHorizontalStretching && !anchor.isHorizontal()) {
                boolean positive = !Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.LEFT);
                Intrinsics.checkNotNull((Object)window, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
                ((ToolWindowEx)window).stretchWidth(positive ? value2 : -value2);
            } else if (!isHorizontalStretching && anchor.isHorizontal()) {
                boolean positive = Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.TOP);
                Intrinsics.checkNotNull((Object)window, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
                ((ToolWindowEx)window).stretchHeight(positive ? value2 : -value2);
            }
        }

        public final void notifyFinish$intellij_python_scientific(@Nullable Project project, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Plots");
            String string = PyScientificBundle.message("notification.save.all.is.finished", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
            notificationGroup.createNotification(string, messageType).addAction((AnAction)NotificationAction.createSimple((String)RevealFileAction.getActionName(), () -> Companion.notifyFinish$lambda$3(path2))).notify(project);
        }

        private static final Unit saveAsFile$lambda$1(VirtualFileWrapper $wrapper, byte[] $bytes, ProgressIndicator it) {
            try {
                Files.write($wrapper.getFile().toPath(), $bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.warn("Failed to save image", (Throwable)e);
            }
            return Unit.INSTANCE;
        }

        private static final void saveAsFile$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void notifyFinish$lambda$3(Path $path) {
            RevealFileAction.openDirectory((Path)$path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/scientific/ui/PyPlotToolWindow$MyDockContainer;", "Lcom/intellij/ui/docking/DockContainer;", "myToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/python/scientific/ui/PyPlotToolWindow;Lcom/intellij/openapi/wm/ToolWindow;)V", "getAcceptArea", "Lcom/intellij/ui/awt/RelativeRectangle;", "getContentResponse", "Lcom/intellij/ui/docking/DockContainer$ContentResponse;", "content", "Lcom/intellij/ui/docking/DockableContent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "getContainerComponent", "Ljavax/swing/JComponent;", "add", "", "dropTarget", "isEmpty", "", "isDisposeWhenEmpty", "findApplicableFigureFactory", "Lcom/intellij/python/scientific/figures/DockableContentFigureFactory;", "intellij.python.scientific"})
    @SourceDebugExtension(value={"SMAP\nPyPlotToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPlotToolWindow.kt\ncom/intellij/python/scientific/ui/PyPlotToolWindow$MyDockContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,437:1\n1#2:438\n*E\n"})
    private final class MyDockContainer
    implements DockContainer {
        @NotNull
        private final ToolWindow myToolWindow;

        public MyDockContainer(ToolWindow myToolWindow) {
            Intrinsics.checkNotNullParameter((Object)myToolWindow, (String)"myToolWindow");
            this.myToolWindow = myToolWindow;
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent<?> content, @NotNull RelativePoint point2) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
            return this.findApplicableFigureFactory(content) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        }

        @NotNull
        public JComponent getContainerComponent() {
            JComponent jComponent = this.myToolWindow.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            return jComponent;
        }

        public void add(@NotNull DockableContent<?> content, @Nullable RelativePoint dropTarget) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            DockableContentFigureFactory dockableContentFigureFactory = this.findApplicableFigureFactory(content);
            Intrinsics.checkNotNull((Object)dockableContentFigureFactory);
            Figure figure = dockableContentFigureFactory.createFigure(content);
            Intrinsics.checkNotNullExpressionValue((Object)figure, (String)"createFigure(...)");
            Figure figure2 = figure;
            if (figure2 instanceof FigureBase) {
                PyPlotToolWindow.this.addFigure((FigureBase)figure2);
            }
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        private final DockableContentFigureFactory findApplicableFigureFactory(DockableContent<?> content) {
            Object v0;
            block1: {
                Iterable iterable = PyPlotToolWindow.this.myDockableContentFigureFactories;
                for (Object t : iterable) {
                    DockableContentFigureFactory factory2 = (DockableContentFigureFactory)t;
                    boolean bl = false;
                    if (!factory2.isApplicable(content)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/scientific/ui/PyPlotToolWindow$MyDragOutDelegate;", "Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "myContentFactory", "Lcom/intellij/python/scientific/figures/WithDockableContent;", "<init>", "(Lcom/intellij/python/scientific/ui/PyPlotToolWindow;Lcom/intellij/python/scientific/figures/WithDockableContent;)V", "session", "Lcom/intellij/ui/docking/DragSession;", "dragOutStarted", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "dockManager", "Lcom/intellij/ui/docking/DockManager;", "getDockManager", "()Lcom/intellij/ui/docking/DockManager;", "processDragOut", "event", "source", "dragOutFinished", "dragOutCancelled", "intellij.python.scientific"})
    private final class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        @NotNull
        private final WithDockableContent myContentFactory;
        @Nullable
        private DragSession session;

        public MyDragOutDelegate(WithDockableContent myContentFactory) {
            Intrinsics.checkNotNullParameter((Object)myContentFactory, (String)"myContentFactory");
            this.myContentFactory = myContentFactory;
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            TabInfo previousSelection = info.getPreviousSelection();
            info.setHidden(true);
            if (previousSelection != null) {
                PyPlotToolWindow.this.getTabs$intellij_python_scientific().select(previousSelection, true);
            }
            this.session = this.getDockManager().createDragSession(mouseEvent, this.myContentFactory.createDockableContent());
        }

        private final DockManager getDockManager() {
            DockManager dockManager = DockManager.getInstance((Project)PyPlotToolWindow.this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)dockManager, (String)"getInstance(...)");
            return dockManager;
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            DragSession dragSession = this.session;
            Intrinsics.checkNotNull((Object)dragSession);
            dragSession.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, @NotNull TabInfo source) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            PyPlotToolWindow.this.getTabs$intellij_python_scientific().removeTab(source);
            DragSession dragSession = this.session;
            Intrinsics.checkNotNull((Object)dragSession);
            dragSession.process(event);
            this.session = null;
        }

        public void dragOutCancelled(@NotNull TabInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            source.setHidden(false);
            if (this.session != null) {
                DragSession dragSession = this.session;
                Intrinsics.checkNotNull((Object)dragSession);
                dragSession.cancel();
            }
            this.session = null;
        }
    }
}

