/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.providers.PyPolarsBaseProvider;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterExpression;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPolarsDataFrameProvider;", "Lcom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getType", "()Lcom/intellij/scientific/tables/api/DSTableDataType;", "getSortingCommand", "", "tableVariable", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "getColumnVariableExpressionForFilterCommand", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "intellij.scientific.py.tables"})
public final class PyPolarsDataFrameProvider
extends PyPolarsBaseProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableDataType type;

    public PyPolarsDataFrameProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.type = DSTableDataType.POLARS_DATA_FRAME;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DSTableDataType getType() {
        return this.type;
    }

    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (sortKeys.isEmpty()) {
            return tableVariable;
        }
        String sortBy2 = CollectionsKt.joinToString$default((Iterable)sortKeys, (CharSequence)",", null, null, (int)0, null, arg_0 -> PyPolarsDataFrameProvider.getSortingCommand$lambda$0(columns, arg_0), (int)30, null);
        String sortOrder = CollectionsKt.joinToString$default((Iterable)sortKeys, (CharSequence)",", null, null, (int)0, null, PyPolarsDataFrameProvider::getSortingCommand$lambda$1, (int)30, null);
        return tableVariable + ".sort([" + sortBy2 + "], descending=[" + sortOrder + "])";
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        if (filters == null) {
            return tableVariable;
        }
        return tableVariable + ".filter(" + this.composeFilterCommand(tableVariable, filters) + ")";
    }

    @Override
    @NotNull
    public String getColumnVariableExpressionForFilterCommand(@NotNull String tableVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return "pl.col('" + filterExpression.getColumn().getName() + "')";
    }

    private static final CharSequence getSortingCommand$lambda$0(List $columns, RowSorter.SortKey sortKey) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        return "'" + $columns.get(sortKey.getColumn()) + "'";
    }

    private static final CharSequence getSortingCommand$lambda$1(RowSorter.SortKey sortKey) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        return sortKey.getSortOrder() == SortOrder.DESCENDING ? (CharSequence)"True" : (CharSequence)"False";
    }
}

