/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.Nullable;

public final class DjangoStringUtil {
    @Nullable
    public static String getStringValue(@Nullable PsiElement o) {
        if (o instanceof Jinja2StringLiteral) {
            return ((Jinja2StringLiteral)o).getStringValue();
        }
        return PyPsiUtils.getStringValue((PsiElement)o);
    }

    public static TextRange getTextRange(PsiElement element) {
        if (element instanceof Jinja2StringLiteral) {
            return TextRange.create((int)1, (int)(element.getText().length() - 1));
        }
        return PyPsiUtils.getStringValueTextRange((PsiElement)element);
    }

    public static boolean isAfterTagStart(String text2, int offsetInElement) {
        return DjangoStringUtil.isAfter(text2, offsetInElement, "{%");
    }

    private static boolean isAfter(String text2, int offsetInElement, String str) {
        int i;
        for (i = offsetInElement - 1; i >= 0 && StringUtil.isJavaIdentifier((String)text2.substring(i, offsetInElement)); --i) {
        }
        while (i >= 0 && Character.isWhitespace(text2.charAt(i))) {
            --i;
        }
        return i > 0 && i + 1 < text2.length() && str.equals(text2.substring(i - str.length() + 1, i + 1));
    }

    public static String findTagNamePrefix(String text2, int offsetInElement) {
        int i;
        for (i = offsetInElement - 1; i >= 0 && StringUtil.isJavaIdentifier((String)text2.substring(i, offsetInElement)); --i) {
        }
        int nameStart = i + 1;
        if (nameStart <= offsetInElement) {
            return text2.substring(nameStart, offsetInElement);
        }
        return "";
    }
}

