/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\u0011\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\rH\u0086\u0002J\u000e\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\rJ\u0013\u00101\u001a\u00020.2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u00103\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020.J\b\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0003J\u0010\u0010:\u001a\u0004\u0018\u00010\u00002\u0006\u0010;\u001a\u00020\u0000J\u000e\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020\u0000J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\rJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\b\u0010A\u001a\u00020BH\u0016J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012\u00a8\u0006E"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "x", "", "y", "w", "h", "(DDDD)V", "xRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yRange", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;)V", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dimension", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "bottom", "getBottom", "()D", "center", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getDimension", "height", "getHeight", "left", "getLeft", "getOrigin", "parts", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "getParts", "()Ljava/lang/Iterable;", "points", "", "getPoints", "()Ljava/util/List;", "right", "getRight", "top", "getTop", "width", "getWidth", "add", "v", "contains", "", "distance", "to", "equals", "other", "flip", "flipIf", "flipped", "hashCode", "", "inflate", "delta", "intersect", "r", "intersects", "rect", "shrinkToAspectRatio", "targetRatio", "subtract", "toString", "", "union", "Companion", "commons"})
public final class DoubleRectangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector origin;
    @NotNull
    private final DoubleVector dimension;

    public DoubleRectangle(@NotNull DoubleVector origin, @NotNull DoubleVector dimension) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.origin = origin;
        this.dimension = dimension;
    }

    @NotNull
    public final DoubleVector getOrigin() {
        return this.origin;
    }

    @NotNull
    public final DoubleVector getDimension() {
        return this.dimension;
    }

    @NotNull
    public final DoubleVector getCenter() {
        return this.origin.add(this.dimension.mul(0.5));
    }

    public final double getLeft() {
        return this.origin.getX();
    }

    public final double getRight() {
        return this.origin.getX() + this.dimension.getX();
    }

    public final double getTop() {
        return this.origin.getY();
    }

    public final double getBottom() {
        return this.origin.getY() + this.dimension.getY();
    }

    public final double getWidth() {
        return this.dimension.getX();
    }

    public final double getHeight() {
        return this.dimension.getY();
    }

    @NotNull
    public final Iterable<DoubleSegment> getParts() {
        ArrayList<DoubleSegment> result2 = new ArrayList<DoubleSegment>();
        result2.add(new DoubleSegment(this.origin, this.origin.add(new DoubleVector(this.dimension.getX(), 0.0))));
        result2.add(new DoubleSegment(this.origin, this.origin.add(new DoubleVector(0.0, this.dimension.getY()))));
        result2.add(new DoubleSegment(this.origin.add(this.dimension), this.origin.add(new DoubleVector(this.dimension.getX(), 0.0))));
        result2.add(new DoubleSegment(this.origin.add(this.dimension), this.origin.add(new DoubleVector(0.0, this.dimension.getY()))));
        return result2;
    }

    @NotNull
    public final List<DoubleVector> getPoints() {
        Object[] objectArray = new DoubleVector[]{this.origin, this.origin.add(new DoubleVector(this.dimension.getX(), 0.0)), this.origin.add(this.dimension), this.origin.add(new DoubleVector(0.0, this.dimension.getY())), this.origin};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public DoubleRectangle(double x2, double y2, double w, double h) {
        this(new DoubleVector(x2, y2), new DoubleVector(w, h));
    }

    public DoubleRectangle(@NotNull DoubleSpan xRange, @NotNull DoubleSpan yRange) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        this(xRange.getLowerEnd(), yRange.getLowerEnd(), xRange.getLength(), yRange.getLength());
    }

    @NotNull
    public final DoubleSpan xRange() {
        return new DoubleSpan(this.origin.getX(), this.origin.getX() + this.dimension.getX());
    }

    @NotNull
    public final DoubleSpan yRange() {
        return new DoubleSpan(this.origin.getY(), this.origin.getY() + this.dimension.getY());
    }

    public final boolean contains(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.origin.getX() <= v.getX() && this.origin.getX() + this.dimension.getX() >= v.getX() && this.origin.getY() <= v.getY() && this.origin.getY() + this.dimension.getY() >= v.getY();
    }

    @NotNull
    public final DoubleRectangle flip() {
        return new DoubleRectangle(this.origin.flip(), this.dimension.flip());
    }

    @NotNull
    public final DoubleRectangle flipIf(boolean flipped) {
        return flipped ? this.flip() : this;
    }

    @NotNull
    public final DoubleRectangle union(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        DoubleVector newOrigin = this.origin.min(rect2.origin);
        DoubleVector corner = this.origin.add(this.dimension);
        DoubleVector rectCorner = rect2.origin.add(rect2.dimension);
        DoubleVector newCorner = corner.max(rectCorner);
        DoubleVector newDimension = newCorner.subtract(newOrigin);
        return new DoubleRectangle(newOrigin, newDimension);
    }

    public final boolean intersects(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        DoubleVector t1 = this.origin;
        DoubleVector t2 = this.origin.add(this.dimension);
        DoubleVector r1 = rect2.origin;
        DoubleVector r2 = rect2.origin.add(rect2.dimension);
        return r2.getX() >= t1.getX() && t2.getX() >= r1.getX() && r2.getY() >= t1.getY() && t2.getY() >= r1.getY();
    }

    @Nullable
    public final DoubleRectangle intersect(@NotNull DoubleRectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        DoubleVector t1 = this.origin;
        DoubleVector t2 = this.origin.add(this.dimension);
        DoubleVector r1 = r.origin;
        DoubleVector r2 = r.origin.add(r.dimension);
        DoubleVector res1 = t1.max(r1);
        DoubleVector res2 = t2.min(r2);
        DoubleVector dim = res2.subtract(res1);
        return dim.getX() < 0.0 || dim.getY() < 0.0 ? null : new DoubleRectangle(res1, dim);
    }

    @NotNull
    public final DoubleRectangle add(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleRectangle(this.origin.add(v), this.dimension);
    }

    @NotNull
    public final DoubleRectangle subtract(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleRectangle(this.origin.subtract(v), this.dimension);
    }

    public final double distance(@NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double result2 = 0.0;
        boolean hasResult = false;
        for (DoubleSegment s : this.getParts()) {
            if (!hasResult) {
                result2 = s.distance(to);
                hasResult = true;
                continue;
            }
            double distance = s.distance(to);
            if (!(distance < result2)) continue;
            result2 = distance;
        }
        return result2;
    }

    @NotNull
    public final DoubleRectangle shrinkToAspectRatio(@NotNull DoubleVector targetRatio) {
        DoubleVector doubleVector;
        double scaling;
        Intrinsics.checkNotNullParameter((Object)targetRatio, (String)"targetRatio");
        if (!(targetRatio.getX() > 0.0 && targetRatio.getY() > 0.0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        double aspectRatio = targetRatio.getX() / targetRatio.getY();
        if (aspectRatio >= 1.0) {
            double newHeight = this.getWidth() / aspectRatio;
            scaling = newHeight > this.getHeight() ? this.getHeight() / newHeight : 1.0;
            doubleVector = new DoubleVector(this.getWidth() * scaling, newHeight * scaling);
        } else {
            double newWidth = this.getHeight() * aspectRatio;
            scaling = newWidth > this.getWidth() ? this.getWidth() / newWidth : 1.0;
            doubleVector = new DoubleVector(newWidth * scaling, this.getHeight() * scaling);
        }
        DoubleVector newSize = doubleVector;
        DoubleVector newOrigin = new DoubleVector(this.origin.getX() + (this.getWidth() - newSize.getX()) / (double)2, this.origin.getY() + (this.getHeight() - newSize.getY()) / (double)2);
        return new DoubleRectangle(newOrigin, newSize);
    }

    @NotNull
    public final DoubleRectangle inflate(double delta) {
        return new DoubleRectangle(this.origin.subtract(new DoubleVector(delta, delta)), this.dimension.add(new DoubleVector(delta * (double)2, delta * (double)2)));
    }

    public int hashCode() {
        return this.origin.hashCode() * 31 + this.dimension.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DoubleRectangle)) {
            return false;
        }
        DoubleRectangle r = (DoubleRectangle)other;
        return r.origin.equals(this.origin) && r.dimension.equals(this.dimension);
    }

    @NotNull
    public String toString() {
        return "[rect " + this.origin + ", " + this.dimension + ']';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J&\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle$Companion;", "", "()V", "LTRB", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "left", "", "top", "right", "bottom", "XYWH", "x", "y", "width", "height", "hvRange", "hRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vRange", "span", "leftTop", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rightBottom", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleRectangle span(@NotNull DoubleVector leftTop, @NotNull DoubleVector rightBottom) {
            Intrinsics.checkNotNullParameter((Object)leftTop, (String)"leftTop");
            Intrinsics.checkNotNullParameter((Object)rightBottom, (String)"rightBottom");
            double x0 = Math.min(leftTop.getX(), rightBottom.getX());
            double x1 = Math.max(leftTop.getX(), rightBottom.getX());
            double y0 = Math.min(leftTop.getY(), rightBottom.getY());
            double y1 = Math.max(leftTop.getY(), rightBottom.getY());
            return new DoubleRectangle(x0, y0, x1 - x0, y1 - y0);
        }

        @NotNull
        public final DoubleRectangle LTRB(@NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)top, (String)"top");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Intrinsics.checkNotNullParameter((Object)bottom, (String)"bottom");
            return new DoubleRectangle(left.doubleValue(), top.doubleValue(), right.doubleValue() - left.doubleValue(), bottom.doubleValue() - top.doubleValue());
        }

        @NotNull
        public final DoubleRectangle XYWH(@NotNull Number x2, @NotNull Number y2, @NotNull Number width2, @NotNull Number height) {
            Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
            Intrinsics.checkNotNullParameter((Object)width2, (String)"width");
            Intrinsics.checkNotNullParameter((Object)height, (String)"height");
            return new DoubleRectangle(x2.doubleValue(), y2.doubleValue(), width2.doubleValue(), height.doubleValue());
        }

        @NotNull
        public final DoubleRectangle hvRange(@NotNull DoubleSpan hRange, @NotNull DoubleSpan vRange) {
            Intrinsics.checkNotNullParameter((Object)hRange, (String)"hRange");
            Intrinsics.checkNotNullParameter((Object)vRange, (String)"vRange");
            return new DoubleRectangle(hRange.getLowerEnd(), vRange.getLowerEnd(), hRange.getLength(), vRange.getLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

