/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/DurationInterval;", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "myDuration", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "count", "", "(Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;I)V", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "range", "", "", "start", "end", "plot-base"})
public final class DurationInterval
extends TimeInterval {
    @NotNull
    private final Duration myDuration;

    public DurationInterval(@NotNull Duration myDuration, int count2) {
        Intrinsics.checkNotNullParameter((Object)myDuration, (String)"myDuration");
        super(count2);
        this.myDuration = myDuration;
        if (!this.myDuration.isPositive()) {
            throw new RuntimeException("Duration must be positive");
        }
    }

    @Override
    @NotNull
    public String getTickFormatPattern() {
        long duration = this.myDuration.getDuration();
        if (duration < Duration.Companion.getSECOND().getDuration()) {
            return "%S";
        }
        if (duration < Duration.Companion.getMINUTE().getDuration()) {
            return "%S";
        }
        if (duration < Duration.Companion.getHOUR().getDuration()) {
            return "%M";
        }
        if (duration < Duration.Companion.getDAY().getDuration()) {
            return "%H:%M";
        }
        if (duration < Duration.Companion.getWEEK().getDuration()) {
            return "%b %e";
        }
        return "%b %e";
    }

    @Override
    @NotNull
    public List<Double> range(double start2, double end) {
        double step2 = this.myDuration.getDuration() * (long)this.getCount();
        ArrayList<Double> result2 = new ArrayList<Double>();
        for (double tick = Math.ceil(start2 / step2) * step2; tick <= end; tick += step2) {
            result2.add(tick);
        }
        return result2;
    }
}

