/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.core.interact.DragFeedback;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.InteractionUtil;
import org.jetbrains.letsPlot.core.interact.MouseDragInteraction;
import org.jetbrains.letsPlot.core.interact.PanGeomFeedback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/interact/PanGeomFeedback;", "Lorg/jetbrains/letsPlot/core/interact/DragFeedback;", "onCompleted", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "(Lkotlin/jvm/functions/Function1;)V", "panningMode", "Lorg/jetbrains/letsPlot/core/interact/PanGeomFeedback$PanningMode;", "start", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "PanningMode", "plot-base"})
public final class PanGeomFeedback
implements DragFeedback {
    @NotNull
    private final Function1<DoubleRectangle, Unit> onCompleted;
    @Nullable
    private PanningMode panningMode;

    public PanGeomFeedback(@NotNull Function1<? super DoubleRectangle, Unit> onCompleted) {
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        this.onCompleted = onCompleted;
    }

    public /* synthetic */ PanGeomFeedback(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super DoubleRectangle, Unit>)function1);
    }

    @Override
    @NotNull
    public Disposable start(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        MouseDragInteraction interaction = new MouseDragInteraction(ctx2);
        interaction.loop((Function1<? super MouseDragInteraction, Unit>)((Function1)start.1.INSTANCE), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(this){
            final /* synthetic */ PanGeomFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction mouseDragInteraction) {
                block9: {
                    DoubleVector doubleVector;
                    Intrinsics.checkNotNullParameter((Object)mouseDragInteraction, (String)"<name for destructuring parameter 0>");
                    InteractionTarget target = mouseDragInteraction.component1();
                    DoubleVector dragFrom = mouseDragInteraction.component2();
                    DoubleVector dragTo = mouseDragInteraction.component3();
                    DoubleVector dragDelta = mouseDragInteraction.component4();
                    PanningMode panningMode = PanGeomFeedback.access$getPanningMode$p(this.this$0);
                    switch (panningMode == null ? -1 : start.WhenMappings.$EnumSwitchMapping$0[panningMode.ordinal()]) {
                        case 1: {
                            doubleVector = new DoubleVector(dragDelta.getX(), 0.0);
                            break;
                        }
                        case 2: {
                            doubleVector = new DoubleVector(0.0, dragDelta.getY());
                            break;
                        }
                        case 3: {
                            doubleVector = dragDelta;
                            break;
                        }
                        case -1: {
                            DoubleVector drag = dragTo.subtract(dragFrom);
                            if (drag.length() > 15.0) {
                                if (Math.abs(drag.getX()) < 7.0) {
                                    PanGeomFeedback.access$setPanningMode$p(this.this$0, PanningMode.VERTICAL);
                                    doubleVector = new DoubleVector(0.0, drag.getY());
                                    break;
                                }
                                if (Math.abs(drag.getY()) < 7.0) {
                                    PanGeomFeedback.access$setPanningMode$p(this.this$0, PanningMode.HORIZONTAL);
                                    doubleVector = new DoubleVector(drag.getX(), 0.0);
                                    break;
                                }
                                PanGeomFeedback.access$setPanningMode$p(this.this$0, PanningMode.FREE);
                                doubleVector = drag;
                                break;
                            }
                            doubleVector = null;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    DoubleVector doubleVector2 = doubleVector;
                    if (doubleVector2 == null) break block9;
                    DoubleVector delta = doubleVector2;
                    boolean bl = false;
                    DoubleRectangle viewport = InteractionUtil.viewportFromTransform$default(InteractionUtil.INSTANCE, target.getGeomBounds(), null, delta, 2, null);
                    target.applyViewport(viewport);
                }
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(this){
            final /* synthetic */ PanGeomFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                System.out.println((Object)"PanGeomFeedback complete.");
                InteractionTarget target = it.component1();
                DoubleVector dragDelta = it.component4();
                DoubleRectangle viewport = InteractionUtil.viewportFromTransform$default(InteractionUtil.INSTANCE, target.getGeomBounds(), null, dragDelta, 2, null);
                DoubleRectangle dataBounds = target.applyViewport(viewport);
                it.reset();
                PanGeomFeedback.access$setPanningMode$p(this.this$0, null);
                PanGeomFeedback.access$getOnCompleted$p(this.this$0).invoke((Object)dataBounds);
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)start.4.INSTANCE));
        return new Disposable(interaction){
            final /* synthetic */ MouseDragInteraction $interaction;
            {
                this.$interaction = $interaction;
            }

            public void dispose() {
                System.out.println((Object)"PanGeomFeedback dispose.");
                this.$interaction.dispose();
            }
        };
    }

    public PanGeomFeedback() {
        this(null, 1, null);
    }

    public static final /* synthetic */ PanningMode access$getPanningMode$p(PanGeomFeedback $this) {
        return $this.panningMode;
    }

    public static final /* synthetic */ void access$setPanningMode$p(PanGeomFeedback $this, PanningMode panningMode) {
        $this.panningMode = panningMode;
    }

    public static final /* synthetic */ Function1 access$getOnCompleted$p(PanGeomFeedback $this) {
        return $this.onCompleted;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/interact/PanGeomFeedback$PanningMode;", "", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "FREE", "plot-base"})
    private static final class PanningMode
    extends Enum<PanningMode> {
        public static final /* enum */ PanningMode HORIZONTAL = new PanningMode();
        public static final /* enum */ PanningMode VERTICAL = new PanningMode();
        public static final /* enum */ PanningMode FREE = new PanningMode();
        private static final /* synthetic */ PanningMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PanningMode[] values() {
            return (PanningMode[])$VALUES.clone();
        }

        public static PanningMode valueOf(String value2) {
            return Enum.valueOf(PanningMode.class, value2);
        }

        @NotNull
        public static EnumEntries<PanningMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = panningModeArray = new PanningMode[]{PanningMode.HORIZONTAL, PanningMode.VERTICAL, PanningMode.FREE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

