/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.InteractionUtil;
import org.jetbrains.letsPlot.core.interact.MouseWheelInteraction;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/interact/WheelZoomFeedback;", "Lorg/jetbrains/letsPlot/core/interact/ToolFeedback;", "onCompleted", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "(Lkotlin/jvm/functions/Function1;)V", "start", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "plot-base"})
public final class WheelZoomFeedback
implements ToolFeedback {
    @NotNull
    private final Function1<DoubleRectangle, Unit> onCompleted;

    public WheelZoomFeedback(@NotNull Function1<? super DoubleRectangle, Unit> onCompleted) {
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        this.onCompleted = onCompleted;
    }

    @NotNull
    public final Disposable start(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        MouseWheelInteraction interaction = new MouseWheelInteraction(ctx2);
        interaction.loop((Function1<? super MouseWheelInteraction, Unit>)((Function1)new Function1<MouseWheelInteraction, Unit>(this){
            final /* synthetic */ WheelZoomFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseWheelInteraction mouseWheelInteraction) {
                Intrinsics.checkNotNullParameter((Object)mouseWheelInteraction, (String)"<name for destructuring parameter 0>");
                InteractionTarget target = mouseWheelInteraction.component1();
                DoubleVector zoomOrigin = mouseWheelInteraction.component2();
                double zoomDelta = mouseWheelInteraction.component3();
                double zoomStep = Math.abs(zoomDelta) > 0.3 ? 0.08 : Math.abs(zoomDelta) / (double)10;
                double factor = zoomDelta < 0.0 ? 1.0 - zoomStep : 1.0 + zoomStep;
                DoubleRectangle viewport = InteractionUtil.INSTANCE.viewportFromScale(target.getGeomBounds(), factor, zoomOrigin);
                DoubleRectangle dataBounds = target.applyViewport(viewport);
                WheelZoomFeedback.access$getOnCompleted$p(this.this$0).invoke((Object)dataBounds);
            }
        }));
        return new Disposable(interaction){
            final /* synthetic */ MouseWheelInteraction $interaction;
            {
                this.$interaction = $interaction;
            }

            public void dispose() {
                System.out.println((Object)"WheelZoomFeedback dispose.");
                this.$interaction.dispose();
            }
        };
    }

    public static final /* synthetic */ Function1 access$getOnCompleted$p(WheelZoomFeedback $this) {
        return $this.onCompleted;
    }
}

