/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfo;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoFactory;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoImpl;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.QQStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J;\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000eH\u0016J*\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002J\u0012\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "distribution", "Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "distributionParameters", "", "", "(Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;Ljava/util/List;)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "sampleSeries", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "Distribution", "plot-base"})
@SourceDebugExtension(value={"SMAP\nQQStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQStat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n1549#2:88\n1620#2,3:89\n*S KotlinDebug\n*F\n+ 1 QQStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQStat\n*L\n39#1:77\n39#1:78,2\n39#1:80\n39#1:81,3\n40#1:84\n40#1:85,3\n42#1:88\n42#1:89,3\n*E\n"})
public final class QQStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Distribution distribution;
    @NotNull
    private final List<Double> distributionParameters;
    @NotNull
    private static final Distribution DEF_DISTRIBUTION = Distribution.NORM;
    @NotNull
    private static final List<Double> DEF_DISTRIBUTION_PARAMETERS = CollectionsKt.emptyList();
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public QQStat(@NotNull Distribution distribution, @NotNull List<Double> distributionParameters) {
        Intrinsics.checkNotNullParameter((Object)((Object)distribution), (String)"distribution");
        Intrinsics.checkNotNullParameter(distributionParameters, (String)"distributionParameters");
        super(DEF_MAPPING);
        this.distribution = distribution;
        this.distributionParameters = distributionParameters;
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf(Aes.Companion.getSAMPLE());
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getSAMPLE()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(data.getNumeric(TransformVar.INSTANCE.getSAMPLE()));
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getTHEORETICAL(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getTHEORETICAL())).putNumeric(Stats.INSTANCE.getSAMPLE(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getSAMPLE())).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> sampleSeries) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        int n;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        Double it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = sampleSeries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            double d;
            it = (Double)element$iv$iv;
            boolean bl = false;
            Double d2 = it;
            boolean bl2 = d2 != null ? !Double.isInfinite(d = d2.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            it = (Double)item$iv$iv2;
            collection = destination$iv$iv;
            n = 0;
            Double d = it;
            Intrinsics.checkNotNull((Object)d);
            collection.add(Double.valueOf(d));
        }
        List statSample = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, statSample.size());
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        item$iv$iv2 = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            void it2;
            int item$iv$iv3;
            n = item$iv$iv3 = ((IntIterator)item$iv$iv2).nextInt();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((double)it2 - 0.5) / (double)statSample.size());
        }
        List t = (List)destination$iv$iv2;
        Function1<Double, Double> quantileFunction = QQStatUtil.INSTANCE.getQuantileFunction(this.distribution, this.distributionParameters);
        Iterable $this$map$iv3 = t;
        boolean $i$f$map3 = false;
        Iterable $i$f$mapTo22 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            destination$iv$iv3.add(quantileFunction.invoke(item$iv$iv4));
        }
        List statTheoretical = (List)destination$iv$iv3;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getTHEORETICAL(), (Object)statTheoretical), TuplesKt.to((Object)Stats.INSTANCE.getSAMPLE(), (Object)statSample)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getTHEORETICAL()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getSAMPLE())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Companion;", "", "()V", "DEF_DISTRIBUTION", "Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "getDEF_DISTRIBUTION", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "DEF_DISTRIBUTION_PARAMETERS", "", "", "getDEF_DISTRIBUTION_PARAMETERS", "()Ljava/util/List;", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Distribution getDEF_DISTRIBUTION() {
            return DEF_DISTRIBUTION;
        }

        @NotNull
        public final List<Double> getDEF_DISTRIBUTION_PARAMETERS() {
            return DEF_DISTRIBUTION_PARAMETERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "", "(Ljava/lang/String;I)V", "NORM", "UNIFORM", "T", "GAMMA", "EXP", "CHI2", "Companion", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nQQStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution\n+ 2 EnumInfoFactory.kt\norg/jetbrains/letsPlot/core/commons/enums/EnumInfoFactory\n*L\n1#1,76:1\n14#2:77\n*S KotlinDebug\n*F\n+ 1 QQStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution\n*L\n55#1:77\n*E\n"})
    public static final class Distribution
    extends Enum<Distribution> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final EnumInfo<Distribution> ENUM_INFO;
        public static final /* enum */ Distribution NORM;
        public static final /* enum */ Distribution UNIFORM;
        public static final /* enum */ Distribution T;
        public static final /* enum */ Distribution GAMMA;
        public static final /* enum */ Distribution EXP;
        public static final /* enum */ Distribution CHI2;
        private static final /* synthetic */ Distribution[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Distribution[] values() {
            return (Distribution[])$VALUES.clone();
        }

        public static Distribution valueOf(String value2) {
            return Enum.valueOf(Distribution.class, value2);
        }

        @NotNull
        public static EnumEntries<Distribution> getEntries() {
            return $ENTRIES;
        }

        static {
            NORM = new Distribution();
            UNIFORM = new Distribution();
            T = new Distribution();
            GAMMA = new Distribution();
            EXP = new Distribution();
            CHI2 = new Distribution();
            $VALUES = distributionArray = new Distribution[]{Distribution.NORM, Distribution.UNIFORM, Distribution.T, Distribution.GAMMA, Distribution.EXP, Distribution.CHI2};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            EnumInfoFactory this_$iv = EnumInfoFactory.INSTANCE;
            boolean $i$f$createEnumInfo = false;
            ENUM_INFO = new EnumInfoImpl((Enum[])Distribution.values());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution$Companion;", "", "()V", "ENUM_INFO", "Lorg/jetbrains/letsPlot/core/commons/enums/EnumInfo;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "safeValueOf", "v", "", "plot-base"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Distribution safeValueOf(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Distribution distribution = (Distribution)((Object)ENUM_INFO.safeValueOf(v));
                if (distribution == null) {
                    throw new IllegalArgumentException("Unsupported distribution: '" + v + "'\nUse one of: norm, uniform, t, gamma, exp, chi2.");
                }
                return distribution;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

