/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.SomeFig;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.geom.LiveMapGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LiveMapProvider;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.render.svg.GroupComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.base.tooltip.NullGeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.ComponentTransientState;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.MarginalLayerUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.LayerTargetCollectorWithLocator;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 62\u00020\u0001:\u000267BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020,2\u0006\u0010\n\u001a\u00020.H\u0002J(\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\n\u001a\u00020.2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001bH\u0002J\b\u00105\u001a\u00020*H\u0014R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010%\u001a\u00060&R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "coreLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "marginalLayers", "tilesOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "tileLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "frameOfReference", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "marginalFrameByMargin", "", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;Ljava/util/Map;)V", "_targetLocators", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "Lkotlin/collections/ArrayList;", "clipGroup", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/GroupComponent;", "geomGroup", "geomInteractionGroup", "layerYOrientations", "", "getLayerYOrientations", "()Ljava/util/List;", "<set-?>", "Lorg/jetbrains/letsPlot/commons/values/SomeFig;", "liveMapFigure", "getLiveMapFigure", "()Lorg/jetbrains/letsPlot/commons/values/SomeFig;", "targetLocators", "getTargetLocators", "transientState", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile$TransientState;", "getTransientState", "()Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile$TransientState;", "addFacetLabBackground", "", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "facetTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "addFacetLabels", "geomBounds", "addLabelElement", "label", "", "isColumnLabel", "buildComponent", "Companion", "TransientState", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotTile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotTile.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotTile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1549#2:246\n1620#2,3:247\n288#2,2:250\n1549#2:252\n1620#2,3:253\n1855#2,2:257\n1#3:256\n*S KotlinDebug\n*F\n+ 1 PlotTile.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotTile\n*L\n59#1:246\n59#1:247,3\n87#1:250,2\n132#1:252\n132#1:253,3\n138#1:257,2\n*E\n"})
public final class PlotTile
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GeomLayer> coreLayers;
    @NotNull
    private final List<GeomLayer> marginalLayers;
    @NotNull
    private final DoubleVector tilesOrigin;
    @NotNull
    private final TileLayoutInfo tileLayoutInfo;
    @NotNull
    private final Theme theme;
    @NotNull
    private final FrameOfReference frameOfReference;
    @NotNull
    private final Map<MarginSide, FrameOfReference> marginalFrameByMargin;
    @NotNull
    private final GroupComponent clipGroup;
    @NotNull
    private final GroupComponent geomGroup;
    @NotNull
    private final GroupComponent geomInteractionGroup;
    @NotNull
    private final TransientState transientState;
    @NotNull
    private final ArrayList<GeomTargetLocator> _targetLocators;
    @Nullable
    private SomeFig liveMapFigure;
    @NotNull
    private final List<Boolean> layerYOrientations;
    private static final boolean DEBUG_DRAWING = false;

    /*
     * WARNING - void declaration
     */
    public PlotTile(@NotNull List<? extends GeomLayer> coreLayers, @NotNull List<? extends GeomLayer> marginalLayers, @NotNull DoubleVector tilesOrigin, @NotNull TileLayoutInfo tileLayoutInfo, @NotNull Theme theme2, @NotNull FrameOfReference frameOfReference, @NotNull Map<MarginSide, ? extends FrameOfReference> marginalFrameByMargin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(coreLayers, (String)"coreLayers");
        Intrinsics.checkNotNullParameter(marginalLayers, (String)"marginalLayers");
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        Intrinsics.checkNotNullParameter((Object)tileLayoutInfo, (String)"tileLayoutInfo");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)frameOfReference, (String)"frameOfReference");
        Intrinsics.checkNotNullParameter(marginalFrameByMargin, (String)"marginalFrameByMargin");
        this.coreLayers = coreLayers;
        this.marginalLayers = marginalLayers;
        this.tilesOrigin = tilesOrigin;
        this.tileLayoutInfo = tileLayoutInfo;
        this.theme = theme2;
        this.frameOfReference = frameOfReference;
        this.marginalFrameByMargin = marginalFrameByMargin;
        this.clipGroup = new GroupComponent();
        this.geomGroup = new GroupComponent();
        this.geomInteractionGroup = new GroupComponent();
        this.transientState = new TransientState();
        this._targetLocators = new ArrayList();
        Iterable iterable = this.coreLayers;
        PlotTile plotTile = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GeomLayer geomLayer2 = (GeomLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.isYOrientation());
        }
        plotTile.layerYOrientations = (List)destination$iv$iv;
        this.moveTo(this.tileLayoutInfo.getAbsoluteBounds(this.tilesOrigin).getOrigin());
    }

    @NotNull
    public final TransientState getTransientState() {
        return this.transientState;
    }

    @Nullable
    public final SomeFig getLiveMapFigure() {
        return this.liveMapFigure;
    }

    @NotNull
    public final List<GeomTargetLocator> getTargetLocators() {
        return this._targetLocators;
    }

    @NotNull
    public final List<Boolean> getLayerYOrientations() {
        return this.layerYOrientations;
    }

    @Override
    protected void buildComponent() {
        Object v0;
        block6: {
            this.add(this.frameOfReference.getBottomGroup());
            this.add(this.clipGroup);
            this.clipGroup.add(this.geomGroup);
            this.geomGroup.moveTo(this.tileLayoutInfo.getGeomContentBounds().getOrigin());
            this.geomGroup.add(this.geomInteractionGroup);
            this.add(this.frameOfReference.getTopGroup());
            DoubleRectangle geomOuterBounds = this.tileLayoutInfo.getGeomOuterBounds();
            this.addFacetLabels(geomOuterBounds, this.theme.facets());
            Iterable $this$firstOrNull$iv = this.coreLayers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GeomLayer p0 = (GeomLayer)element$iv;
                boolean bl = false;
                if (!p0.isLiveMap()) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        GeomLayer liveMapGeomLayer = v0;
        if (liveMapGeomLayer != null) {
            DoubleRectangle realBounds = this.tileLayoutInfo.getAbsoluteOuterGeomBounds(this.tilesOrigin);
            LiveMapProvider.LiveMapData liveMapData = PlotTile.Companion.createCanvasFigure(liveMapGeomLayer, realBounds);
            this.liveMapFigure = liveMapData.getCanvasFigure();
            this._targetLocators.addAll((Collection<GeomTargetLocator>)liveMapData.getTargetLocators());
        } else {
            for (GeomLayer layer : this.coreLayers) {
                LayerTargetCollectorWithLocator layerTargetCollectorWithLocator = new LayerTargetCollectorWithLocator(layer.getGeomKind(), layer.getLocatorLookupSpec(), layer.createContextualMapping());
                this._targetLocators.add(layerTargetCollectorWithLocator);
                SvgComponent layerComponent = this.frameOfReference.buildGeomComponent(layer, layerTargetCollectorWithLocator);
                this.geomInteractionGroup.add(layerComponent.getRootGroup());
                this.frameOfReference.setClip(this.clipGroup);
            }
            Map<MarginSide, List<GeomLayer>> marginalLayersByMargin = MarginalLayerUtil.INSTANCE.marginalLayersByMargin(this.marginalLayers);
            for (Map.Entry<MarginSide, List<GeomLayer>> entry : marginalLayersByMargin.entrySet()) {
                MarginSide margin = entry.getKey();
                List<GeomLayer> layers2 = entry.getValue();
                FrameOfReference marginFrame = (FrameOfReference)MapsKt.getValue(this.marginalFrameByMargin, (Object)((Object)margin));
                for (GeomLayer layer : layers2) {
                    SvgComponent marginComponent = marginFrame.buildGeomComponent(layer, new NullGeomTargetCollector());
                    this.add(marginComponent);
                    marginFrame.setClip(marginComponent);
                }
            }
            this.frameOfReference.repaintFrame();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addFacetLabels(DoubleRectangle geomBounds, FacetsTheme theme2) {
        List<Pair<String, Double>> xLabels = this.tileLayoutInfo.getFacetXLabels();
        if (!((Collection)xLabels).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.tileLayoutInfo.getFacetXLabels();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair2 = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Number)it.getSecond()).doubleValue());
            }
            $this$map$iv = (List)destination$iv$iv;
            FacetedPlotLayout.Companion $i$f$map22 = FacetedPlotLayout.Companion;
            Iterable p0 = $this$map$iv;
            boolean bl = false;
            double totalHeadHeight = $i$f$map22.facetColHeadTotalHeight((List<Double>)p0);
            DoubleVector labelOrig = new DoubleVector(geomBounds.getLeft(), geomBounds.getTop() - totalHeadHeight);
            DoubleVector curLabelOrig = null;
            curLabelOrig = labelOrig;
            Iterable $this$forEach$iv = xLabels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair3 = (Pair)element$iv;
                boolean bl2 = false;
                String xLabel = (String)pair3.component1();
                double labHeight2 = ((Number)pair3.component2()).doubleValue();
                DoubleRectangle labelBounds = new DoubleRectangle(curLabelOrig, new DoubleVector(geomBounds.getWidth(), labHeight2));
                this.addFacetLabBackground(labelBounds, theme2);
                this.addLabelElement(labelBounds, theme2, xLabel, true);
                curLabelOrig = curLabelOrig.add(new DoubleVector(0.0, labHeight2));
            }
        }
        if (this.tileLayoutInfo.getFacetYLabel() != null) {
            Pair<String, Double> pair4 = this.tileLayoutInfo.getFacetYLabel();
            String yLabel = (String)pair4.component1();
            double labWidth = ((Number)pair4.component2()).doubleValue();
            DoubleRectangle labelBounds = new DoubleRectangle(geomBounds.getRight() + (double)3, geomBounds.getTop(), labWidth, geomBounds.getHeight());
            this.addFacetLabBackground(labelBounds, theme2);
            this.addLabelElement(labelBounds, theme2, yLabel, false);
        }
    }

    private final void addFacetLabBackground(DoubleRectangle labelBounds, FacetsTheme facetTheme) {
        if (facetTheme.showStripBackground()) {
            SvgRectElement svgRectElement;
            SvgRectElement $this$addFacetLabBackground_u24lambda_u244 = svgRectElement = new SvgRectElement(labelBounds);
            boolean bl = false;
            $this$addFacetLabBackground_u24lambda_u244.strokeWidth().set(facetTheme.stripStrokeWidth());
            $this$addFacetLabBackground_u24lambda_u244.fillColor().set(facetTheme.stripFill());
            $this$addFacetLabBackground_u24lambda_u244.strokeColor().set(facetTheme.stripColor());
            StrokeDashArraySupport.INSTANCE.apply($this$addFacetLabBackground_u24lambda_u244, facetTheme.stripStrokeWidth(), facetTheme.stripLineType());
            SvgRectElement rect2 = svgRectElement;
            this.add(rect2);
        }
    }

    private final void addLabelElement(DoubleRectangle labelBounds, FacetsTheme theme2, String label2, boolean isColumnLabel) {
        DoubleRectangle textBounds = theme2.stripMargins().shrinkRect(labelBounds);
        DoubleVector textSize = FacetedPlotLayout.Companion.titleSize(label2, theme2);
        LabelSpec labelSpec = PlotLabelSpecFactory.INSTANCE.facetText(theme2);
        double lineHeight = labelSpec.height();
        String className = isColumnLabel ? "x" : "y";
        TextJustification.Companion.TextRotation rotation = isColumnLabel ? null : TextJustification.Companion.TextRotation.CLOCKWISE;
        MultilineLabel lab = new MultilineLabel(label2);
        lab.addClassName("facet-strip-text-" + className);
        Pair<DoubleVector, Text.HorizontalAnchor> pair2 = TextJustification.Companion.applyJustification(textBounds, textSize, lineHeight, theme2.stripTextJustification(), rotation);
        DoubleVector pos = (DoubleVector)pair2.component1();
        Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair2.component2());
        lab.setHorizontalAnchor(hAnchor);
        lab.setLineHeight(lineHeight);
        lab.moveTo(pos);
        TextJustification.Companion.TextRotation textRotation = rotation;
        if (textRotation != null) {
            TextJustification.Companion.TextRotation it = textRotation;
            boolean bl = false;
            lab.rotate(it.getAngle());
        }
        this.add(lab);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile$Companion;", "", "()V", "DEBUG_DRAWING", "", "createCanvasFigure", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LiveMapProvider$LiveMapData;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final LiveMapProvider.LiveMapData createCanvasFigure(GeomLayer layer, DoubleRectangle bounds) {
            Geom geom2 = layer.getGeom();
            Intrinsics.checkNotNull((Object)geom2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.LiveMapGeom");
            return ((LiveMapGeom)geom2).createCanvasFigure(bounds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile$TransientState;", "Lorg/jetbrains/letsPlot/core/plot/builder/ComponentTransientState;", "(Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile;)V", "coreTransientState", "dataBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getDataBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "repaint", "", "repaint$plot_builder", "plot-builder"})
    public final class TransientState
    extends ComponentTransientState {
        @NotNull
        private final ComponentTransientState coreTransientState;

        public TransientState() {
            super(PlotTile.this.tileLayoutInfo.getGeomContentBounds());
            this.coreTransientState = PlotTile.this.frameOfReference.getTransientState();
        }

        @Override
        @NotNull
        public DoubleRectangle getDataBounds() {
            return this.coreTransientState.getDataBounds();
        }

        @Override
        public void repaint$plot_builder() {
            PlotTile.this.geomInteractionGroup.getRootGroup().transform().set(this.getTransform());
            this.coreTransientState.transformView(this.getScale(), this.getOffset());
        }
    }
}

