/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.ScaleBreaksUtil;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.LegendAssemblerUtil;
import org.jetbrains.letsPlot.core.plot.builder.guide.ColorBarComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.ColorBarComponentLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.ColorBarComponentSpec;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBox;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarAssembler;", "", "legendTitle", "", "transformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "scaleMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "colorBarOptions", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarOptions;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarOptions;)V", "createColorBar", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "equalScalesAndOptions", "", "other", "withTitle", "title", "Companion", "plot-builder"})
public final class ColorBarAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String legendTitle;
    @NotNull
    private final DoubleSpan transformedDomain;
    @NotNull
    private final Scale scale;
    @NotNull
    private final ScaleMapper<Color> scaleMapper;
    @NotNull
    private final LegendTheme theme;
    @Nullable
    private ColorBarOptions colorBarOptions;
    private static final boolean DEBUG_DRAWING = false;

    public ColorBarAssembler(@NotNull String legendTitle, @NotNull DoubleSpan transformedDomain, @NotNull Scale scale, @NotNull ScaleMapper<Color> scaleMapper2, @NotNull LegendTheme theme2, @Nullable ColorBarOptions colorBarOptions) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        this.legendTitle = legendTitle;
        this.transformedDomain = transformedDomain;
        this.scale = scale;
        this.scaleMapper = scaleMapper2;
        this.theme = theme2;
        this.colorBarOptions = colorBarOptions;
    }

    @NotNull
    public final LegendBoxInfo createColorBar() {
        ScaleBreaks scaleBreaks;
        Scale scale = this.scale;
        if (!scale.hasBreaks()) {
            scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, this.transformedDomain, 5);
        }
        if ((scaleBreaks = scale.getScaleBreaks()).isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ColorBarComponentSpec spec = Companion.createColorBarSpec(this.legendTitle, this.transformedDomain, scaleBreaks, this.scaleMapper, this.theme, this.colorBarOptions);
        DoubleVector doubleVector = spec.getSize();
        return new LegendBoxInfo(spec, doubleVector){
            final /* synthetic */ ColorBarComponentSpec $spec;
            {
                this.$spec = $spec;
                super($super_call_param$1);
            }

            @NotNull
            public LegendBox createLegendBox() {
                ColorBarComponent c = new ColorBarComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
        };
    }

    public final boolean equalScalesAndOptions(@NotNull ColorBarAssembler other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.transformedDomain, (Object)other.transformedDomain)) {
            return false;
        }
        if (this.scale.getTransform().getClass() != other.scale.getTransform().getClass()) {
            return false;
        }
        if (this.scaleMapper.getClass() != other.scaleMapper.getClass()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorBarOptions, (Object)other.colorBarOptions);
    }

    @NotNull
    public final ColorBarAssembler withTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return new ColorBarAssembler(title, this.transformedDomain, this.scale, this.scaleMapper, this.theme, this.colorBarOptions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createColorBarSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentSpec;", "title", "", "transformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "scaleMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "options", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarOptions;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentSpec createColorBarSpec(@NotNull String title, @NotNull DoubleSpan transformedDomain, @NotNull ScaleBreaks breaks, @NotNull ScaleMapper<Color> scaleMapper2, @NotNull LegendTheme theme2, @Nullable ColorBarOptions options) {
            double d;
            String label2;
            double d2;
            String label3;
            Iterator iterator2;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme2);
            boolean horizontal = legendDirection == LegendDirection.HORIZONTAL;
            ColorBarOptions colorBarOptions = options;
            Double width2 = colorBarOptions != null ? colorBarOptions.getWidth() : null;
            ColorBarOptions colorBarOptions2 = options;
            Double height = colorBarOptions2 != null ? colorBarOptions2.getHeight() : null;
            DoubleVector barSize = ColorBarComponentSpec.Companion.barAbsoluteSize$plot_builder(horizontal, theme2);
            if (width2 != null) {
                barSize = new DoubleVector(width2, barSize.getY());
            } else if (horizontal) {
                iterator2 = ((Iterable)breaks.getLabels()).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                label3 = (String)iterator2.next();
                boolean bl = false;
                d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label3, PlotLabelSpecFactory.INSTANCE.legendItem(theme2)).getX();
                while (iterator2.hasNext()) {
                    label2 = (String)iterator2.next();
                    $i$a$-maxOf-ColorBarAssembler$Companion$createColorBarSpec$labelMaxWidth$1 = false;
                    d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme2)).getX();
                    d2 = Math.max(d2, d);
                }
                double labelMaxWidth = d2;
                barSize = new DoubleVector(Math.max(barSize.getX(), labelMaxWidth * (double)(breaks.getSize() + 1)), barSize.getY());
            }
            if (height != null) {
                barSize = new DoubleVector(barSize.getX(), height);
            } else if (!horizontal) {
                iterator2 = ((Iterable)breaks.getLabels()).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                label3 = (String)iterator2.next();
                boolean bl = false;
                d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label3, PlotLabelSpecFactory.INSTANCE.legendItem(theme2)).getY();
                while (iterator2.hasNext()) {
                    label2 = (String)iterator2.next();
                    $i$a$-maxOf-ColorBarAssembler$Companion$createColorBarSpec$labelMaxHeight$1 = false;
                    d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme2)).getY();
                    d2 = Math.max(d2, d);
                }
                double labelMaxHeight = d2;
                barSize = new DoubleVector(barSize.getX(), Math.max(barSize.getY(), labelMaxHeight * (double)(breaks.getSize() + 1)));
            }
            boolean reverse = !horizontal;
            ColorBarComponentLayout layout = horizontal ? ColorBarComponentLayout.Companion.horizontal(title, transformedDomain, breaks, barSize, reverse, theme2) : ColorBarComponentLayout.Companion.vertical(title, transformedDomain, breaks, barSize, reverse, theme2);
            Object object = options;
            return new ColorBarComponentSpec(title, transformedDomain, breaks, scaleMapper2, object != null && (object = ((ColorBarOptions)object).getBinCount()) != null ? (Integer)object : 20, theme2, layout, reverse);
        }

        public static /* synthetic */ ColorBarComponentSpec createColorBarSpec$default(Companion companion, String string, DoubleSpan doubleSpan, ScaleBreaks scaleBreaks, ScaleMapper scaleMapper2, LegendTheme legendTheme, ColorBarOptions colorBarOptions, int n, Object object) {
            if ((n & 0x20) != 0) {
                colorBarOptions = null;
            }
            return companion.createColorBarSpec(string, doubleSpan, scaleBreaks, scaleMapper2, legendTheme, colorBarOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

