/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007J#\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil;", "", "()V", "addX", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "x", "", "addX$plot_builder", "areEqual", "", "a", "b", "epsilon", "areEqual$plot_builder", "p1", "p2", "bottomEdgeOf", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "distance", "distance$plot_builder", "leftEdgeOf", "liesOnSegment", "c", "polygonContainsCoordinate", "points", "", "coord", "polygonContainsCoordinate$plot_builder", "rightEdgeOf", "subtractX", "subtractX$plot_builder", "topEdgeOf", "ClosestPointChecker", "plot-builder"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();

    private MathUtil() {
    }

    public final boolean polygonContainsCoordinate$plot_builder(@NotNull List<DoubleVector> points, @NotNull DoubleVector coord) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int intersectionCount = 0;
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            double x2;
            DoubleVector start2 = points.get(i - 1);
            DoubleVector end = points.get(i);
            if (start2.getY() >= coord.getY() && end.getY() >= coord.getY() || start2.getY() < coord.getY() && end.getY() < coord.getY() || !((x2 = start2.getX() + (coord.getY() - start2.getY()) * (end.getX() - start2.getX()) / (end.getY() - start2.getY())) <= coord.getX())) continue;
            ++intersectionCount;
        }
        return intersectionCount % 2 != 0;
    }

    public final boolean liesOnSegment(@NotNull DoubleVector p1, @NotNull DoubleVector p2, @NotNull DoubleVector c, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new DoubleSegment(p1, p2).distance(c) < epsilon;
    }

    public final boolean areEqual$plot_builder(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return p1.subtract(p2).length() < epsilon;
    }

    public final boolean areEqual$plot_builder(double a2, double b2, double epsilon) {
        return Math.abs(a2 - b2) < epsilon;
    }

    public final double distance$plot_builder(@NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return new DoubleSegment(p1, p2).length();
    }

    @NotNull
    public final DoubleVector subtractX$plot_builder(@NotNull DoubleVector v, double x2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() - x2, v.getY());
    }

    @NotNull
    public final DoubleVector addX$plot_builder(@NotNull DoubleVector v, double x2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() + x2, v.getY());
    }

    @NotNull
    public final DoubleSegment leftEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getLeft(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment topEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getTop()));
    }

    @NotNull
    public final DoubleSegment rightEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getRight(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment bottomEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getBottom()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0002R\"\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil$ClosestPointChecker;", "", "x", "", "y", "(DD)V", "target", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "<set-?>", "coord", "getCoord", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "distance", "getDistance", "()D", "getTarget", "check", "", "compare", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil$ClosestPointChecker$COMPARISON_RESULT;", "setNewClosestCoord", "", "COMPARISON_RESULT", "plot-builder"})
    public static final class ClosestPointChecker {
        @NotNull
        private final DoubleVector target;
        private double distance;
        @Nullable
        private DoubleVector coord;

        public ClosestPointChecker(@NotNull DoubleVector target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.distance = -1.0;
        }

        @NotNull
        public final DoubleVector getTarget() {
            return this.target;
        }

        public final double getDistance() {
            return this.distance;
        }

        @Nullable
        public final DoubleVector getCoord() {
            return this.coord;
        }

        public ClosestPointChecker(double x2, double y2) {
            this(new DoubleVector(x2, y2));
        }

        public final boolean check(@NotNull DoubleVector coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            COMPARISON_RESULT cmpResult = this.compare(coord);
            return cmpResult == COMPARISON_RESULT.NEW_CLOSER || cmpResult == COMPARISON_RESULT.EQUAL;
        }

        @NotNull
        public final COMPARISON_RESULT compare(@NotNull DoubleVector coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            double newDistance = INSTANCE.distance$plot_builder(this.target, coord);
            if (this.distance < 0.0) {
                this.setNewClosestCoord(coord, newDistance);
                return COMPARISON_RESULT.NEW_CLOSER;
            }
            if (this.distance < newDistance) {
                return COMPARISON_RESULT.NEW_FARTHER;
            }
            if (this.distance == newDistance) {
                return COMPARISON_RESULT.EQUAL;
            }
            this.setNewClosestCoord(coord, newDistance);
            return COMPARISON_RESULT.NEW_CLOSER;
        }

        private final void setNewClosestCoord(DoubleVector coord, double distance) {
            this.distance = distance;
            this.coord = coord;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil$ClosestPointChecker$COMPARISON_RESULT;", "", "(Ljava/lang/String;I)V", "NEW_CLOSER", "NEW_FARTHER", "EQUAL", "plot-builder"})
        public static final class COMPARISON_RESULT
        extends Enum<COMPARISON_RESULT> {
            public static final /* enum */ COMPARISON_RESULT NEW_CLOSER = new COMPARISON_RESULT();
            public static final /* enum */ COMPARISON_RESULT NEW_FARTHER = new COMPARISON_RESULT();
            public static final /* enum */ COMPARISON_RESULT EQUAL = new COMPARISON_RESULT();
            private static final /* synthetic */ COMPARISON_RESULT[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static COMPARISON_RESULT[] values() {
                return (COMPARISON_RESULT[])$VALUES.clone();
            }

            public static COMPARISON_RESULT valueOf(String value2) {
                return Enum.valueOf(COMPARISON_RESULT.class, value2);
            }

            @NotNull
            public static EnumEntries<COMPARISON_RESULT> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = cOMPARISON_RESULTArray = new COMPARISON_RESULT[]{COMPARISON_RESULT.NEW_CLOSER, COMPARISON_RESULT.NEW_FARTHER, COMPARISON_RESULT.EQUAL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

