/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.MathUtil;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00102\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u001eH\u0002J5\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100#\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010$J\u001c\u0010%\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J.\u0010&\u001a\u00020\u00172\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u00070\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u001c\u0010(\u001a\u00020\u00102\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010*\u001a\u00020\u0019H\u0002J0\u0010+\u001a\u00020\u00172\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u001e2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0018\u0010.\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0011H\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander;", "", "space", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;)V", "mySpacedTooltips", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "spacedTooltips", "", "getSpacedTooltips", "()Ljava/util/List;", "analyzeOverlapping", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;", "", "tooltip", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "restrictions", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "checkSideOverlapping", "", "tooltipSide", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "restrictedPart", "intersection", "side", "overlappings", "", "containsAll", "", "map", "keys", "", "(Ljava/util/Map;[Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;)Z", "findVector", "fixOverlapping", "tooltips", "min", "pointsOf", "doubleSegment", "putAllIfGreater", "existingOverlappings", "newOverlappings", "vectorBySide", "overlapping", "Side", "plot-builder"})
public final class VerticalTooltipShiftingExpander {
    @Nullable
    private List<Pair<Integer, DoubleVector>> mySpacedTooltips;

    public VerticalTooltipShiftingExpander(@NotNull DoubleSpan space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
    }

    @Nullable
    public final List<Pair<Integer, DoubleVector>> getSpacedTooltips() {
        return this.mySpacedTooltips;
    }

    public final void fixOverlapping(@NotNull List<Pair<Integer, LayoutManager.PositionedTooltip>> tooltips, @NotNull List<DoubleRectangle> restrictions) {
        Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        this.mySpacedTooltips = new ArrayList();
        for (Pair<Integer, LayoutManager.PositionedTooltip> tooltip : tooltips) {
            Map<Side, Double> overlappings = this.analyzeOverlapping((LayoutManager.PositionedTooltip)tooltip.getSecond(), restrictions);
            if (overlappings.isEmpty()) {
                List<Pair<Integer, DoubleVector>> list2 = this.mySpacedTooltips;
                Intrinsics.checkNotNull(list2);
                list2.add((Pair<Integer, DoubleVector>)new Pair(tooltip.getFirst(), (Object)((LayoutManager.PositionedTooltip)tooltip.getSecond()).getTooltipCoord()));
                continue;
            }
            List<Pair<Integer, DoubleVector>> list3 = this.mySpacedTooltips;
            Intrinsics.checkNotNull(list3);
            list3.add((Pair<Integer, DoubleVector>)new Pair(tooltip.getFirst(), (Object)((LayoutManager.PositionedTooltip)tooltip.getSecond()).getTooltipCoord().add(this.findVector(overlappings))));
        }
    }

    private final Map<Side, Double> analyzeOverlapping(LayoutManager.PositionedTooltip tooltip, List<DoubleRectangle> restrictions) {
        DoubleRectangle tooltipRect = tooltip.rect$plot_builder();
        DoubleSegment topSide = MathUtil.INSTANCE.topEdgeOf(tooltipRect);
        DoubleSegment leftSide = MathUtil.INSTANCE.leftEdgeOf(tooltipRect);
        DoubleSegment bottomSide = MathUtil.INSTANCE.bottomEdgeOf(tooltipRect);
        DoubleSegment rightSide = MathUtil.INSTANCE.rightEdgeOf(tooltipRect);
        HashMap overlappings = new HashMap();
        for (DoubleRectangle restriction : restrictions) {
            DoubleRectangle intersection;
            if (tooltipRect.intersect(restriction) == null) continue;
            HashMap currentOverlappings = new HashMap();
            for (DoubleSegment part : restriction.getParts()) {
                this.checkSideOverlapping(topSide, part, intersection, Side.TOP, currentOverlappings);
                this.checkSideOverlapping(leftSide, part, intersection, Side.LEFT, currentOverlappings);
                this.checkSideOverlapping(bottomSide, part, intersection, Side.BOTTOM, currentOverlappings);
                this.checkSideOverlapping(rightSide, part, intersection, Side.RIGHT, currentOverlappings);
            }
            if (currentOverlappings.isEmpty()) {
                throw new IllegalStateException("Intersection was detected, but no points added");
            }
            if (currentOverlappings.size() == 1) {
                overlappings.putAll(currentOverlappings);
                continue;
            }
            if (currentOverlappings.size() == 2) {
                Side[] sideArray = new Side[]{Side.LEFT, Side.RIGHT};
                if (this.containsAll(currentOverlappings, sideArray)) {
                    if (this.pointsOf(MathUtil.INSTANCE.topEdgeOf(tooltipRect)).contains(intersection.getOrigin())) {
                        ((Map)overlappings).put(Side.TOP, intersection.getDimension().getY());
                        continue;
                    }
                    if (!this.pointsOf(MathUtil.INSTANCE.bottomEdgeOf(tooltipRect)).contains(MathUtil.INSTANCE.bottomEdgeOf(intersection).getStart())) continue;
                    ((Map)overlappings).put(Side.BOTTOM, intersection.getDimension().getY());
                    continue;
                }
                sideArray = new Side[]{Side.TOP, Side.BOTTOM};
                if (this.containsAll(currentOverlappings, sideArray)) {
                    if (this.pointsOf(MathUtil.INSTANCE.leftEdgeOf(tooltipRect)).contains(intersection.getOrigin())) {
                        ((Map)overlappings).put(Side.LEFT, intersection.getDimension().getX());
                        continue;
                    }
                    if (!this.pointsOf(MathUtil.INSTANCE.bottomEdgeOf(tooltipRect)).contains(MathUtil.INSTANCE.rightEdgeOf(intersection).getStart())) continue;
                    ((Map)overlappings).put(Side.RIGHT, intersection.getDimension().getX());
                    continue;
                }
                this.putAllIfGreater(overlappings, currentOverlappings);
                continue;
            }
            this.putAllIfGreater(overlappings, currentOverlappings);
        }
        return overlappings;
    }

    private final void putAllIfGreater(Map<Side, Double> existingOverlappings, Map<Side, Double> newOverlappings) {
        for (Side side : newOverlappings.keySet()) {
            if (existingOverlappings.containsKey((Object)side)) {
                Double d = existingOverlappings.get((Object)side);
                Intrinsics.checkNotNull((Object)d);
                if (!(((Number)d).doubleValue() < ((Number)MapsKt.getValue(newOverlappings, (Object)((Object)side))).doubleValue())) continue;
            }
            existingOverlappings.put(side, (Double)MapsKt.getValue(newOverlappings, (Object)((Object)side)));
        }
    }

    private final List<DoubleVector> pointsOf(DoubleSegment doubleSegment) {
        ArrayList<DoubleVector> points = new ArrayList<DoubleVector>();
        points.add(doubleSegment.getStart());
        points.add(doubleSegment.getEnd());
        return points;
    }

    private final void checkSideOverlapping(DoubleSegment tooltipSide, DoubleSegment restrictedPart, DoubleRectangle intersection, Side side, Map<Side, Double> overlappings) {
        double intersectionLength;
        if (restrictedPart.intersection(tooltipSide) == null) {
            return;
        }
        double d = intersectionLength = side == Side.LEFT || side == Side.RIGHT ? intersection.getDimension().getX() : intersection.getDimension().getY();
        if (!overlappings.containsKey((Object)side)) {
            Double d2 = intersectionLength;
            overlappings.put(side, d2);
        } else {
            Double d3 = overlappings.get((Object)side);
            Intrinsics.checkNotNull((Object)d3);
            overlappings.put(side, Math.max(((Number)d3).doubleValue(), intersectionLength));
        }
    }

    private final DoubleVector findVector(Map<Side, Double> overlappings) {
        if (overlappings.isEmpty()) {
            return DoubleVector.Companion.getZERO();
        }
        if (overlappings.size() == 1) {
            Side side = overlappings.keySet().iterator().next();
            double value2 = ((Number)MapsKt.getValue(overlappings, (Object)((Object)side))).doubleValue();
            return this.vectorBySide(side, value2);
        }
        if (overlappings.containsKey((Object)Side.LEFT)) {
            return this.vectorBySide(Side.LEFT, ((Number)MapsKt.getValue(overlappings, (Object)((Object)Side.LEFT))).doubleValue());
        }
        if (overlappings.containsKey((Object)Side.RIGHT)) {
            return this.vectorBySide(Side.RIGHT, ((Number)MapsKt.getValue(overlappings, (Object)((Object)Side.RIGHT))).doubleValue());
        }
        Side minOverlappedSide = this.min(overlappings);
        return this.vectorBySide(minOverlappedSide, ((Number)MapsKt.getValue(overlappings, (Object)((Object)minOverlappedSide))).doubleValue());
    }

    private final DoubleVector vectorBySide(Side side, double overlapping) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(overlapping, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(-overlapping, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, overlapping);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, -overlapping);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    private final boolean containsAll(Map<Side, Double> map2, Side ... keys) {
        if (map2.size() != keys.length) {
            return false;
        }
        for (Side side : keys) {
            if (map2.containsKey((Object)side)) continue;
            return false;
        }
        return true;
    }

    private final Side min(Map<Side, Double> map2) {
        Side minSide = null;
        for (Side side : map2.keySet()) {
            if (minSide == null) {
                minSide = side;
                continue;
            }
            if (!(((Number)MapsKt.getValue(map2, (Object)((Object)minSide))).doubleValue() > ((Number)MapsKt.getValue(map2, (Object)((Object)side))).doubleValue())) continue;
            minSide = side;
        }
        Side side = minSide;
        Intrinsics.checkNotNull(side);
        return side;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "TOP", "BOTTOM", "plot-builder"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side LEFT = new Side();
        public static final /* enum */ Side RIGHT = new Side();
        public static final /* enum */ Side TOP = new Side();
        public static final /* enum */ Side BOTTOM = new Side();
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value2) {
            return Enum.valueOf(Side.class, value2);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sideArray = new Side[]{Side.LEFT, Side.RIGHT, Side.TOP, Side.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

