/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back.transform.bistro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.OptionsUtil;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.PlotOptions;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.TooltipsOptions;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.TooltipsOptionsKt;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.waterfall.WaterfallPlotOptionsBuilder;
import org.jetbrains.letsPlot.core.spec.conversion.LineTypeOptionConverter;
import org.jetbrains.letsPlot.core.spec.transform.SpecChange;
import org.jetbrains.letsPlot.core.spec.transform.SpecChangeContext;
import org.jetbrains.letsPlot.core.spec.transform.SpecSelector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\fH\u0016J6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J,\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J,\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/WaterfallPlotSpecChange;", "Lorg/jetbrains/letsPlot/core/spec/transform/SpecChange;", "()V", "apply", "", "spec", "", "", "", "ctx", "Lorg/jetbrains/letsPlot/core/spec/transform/SpecChangeContext;", "buildWaterfallPlotSpec", "", "plotSpec", "isApplicable", "", "readBoxTooltipsOptions", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/util/TooltipsOptions;", "bistroSpec", "optionName", "defaultTooltips", "detailedTooltips", "readElementLineOptions", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/waterfall/WaterfallPlotOptionsBuilder$ElementLineOptions;", "option", "defaults", "readElementTextOptions", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/waterfall/WaterfallPlotOptionsBuilder$ElementTextOptions;", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nWaterfallPlotSpecChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterfallPlotSpecChange.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/WaterfallPlotSpecChange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class WaterfallPlotSpecChange
implements SpecChange {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void apply(@NotNull Map<String, Object> spec, @NotNull SpecChangeContext ctx2) {
        String[] stringArray;
        Map map2;
        Map waterfallTheme;
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Map<String, Object> waterfallPlotSpec = this.buildWaterfallPlotSpec(spec);
        Map<String, Object> map3 = spec;
        String string = "layers";
        String[] stringArray2 = waterfallPlotSpec.get("layers");
        if (stringArray2 == null) {
            throw new IllegalStateException("Missing layers in waterfall plot".toString());
        }
        String[] stringArray3 = stringArray2;
        map3.put(string, stringArray3);
        stringArray3 = new String[]{"scales"};
        List<?> list2 = OptionsSelectorKt.getList(waterfallPlotSpec, stringArray3);
        if (list2 == null) {
            throw new IllegalStateException("Missing scales in waterfall plot".toString());
        }
        List<?> waterfallScales = list2;
        String[] stringArray4 = new String[]{"scales"};
        List list3 = OptionsSelectorKt.getList(spec, stringArray4);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List plotScales = list3;
        spec.put("scales", CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)waterfallScales, (Iterable)plotScales)));
        String[] stringArray5 = new String[]{"theme"};
        Map map4 = OptionsSelectorKt.getMap(waterfallPlotSpec, stringArray5);
        if (map4 == null) {
            map4 = waterfallTheme = MapsKt.emptyMap();
        }
        if ((map2 = OptionsSelectorKt.getMap(spec, stringArray = new String[]{"theme"})) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map plotTheme = map2;
        spec.put("theme", MapsKt.toMutableMap((Map)MapsKt.plus((Map)waterfallTheme, (Map)plotTheme)));
        spec.remove("bistro");
    }

    private final Map<String, Object> buildWaterfallPlotSpec(Map<String, Object> plotSpec) {
        String string;
        String[] stringArray = new String[]{"bistro"};
        Map<String, Object> map2 = OptionsSelectorKt.getMap(plotSpec, stringArray);
        if (map2 == null) {
            throw new IllegalStateException("'bistro' not found in PlotSpec".toString());
        }
        Map<String, Object> bistroSpec = map2;
        String[] stringArray2 = new String[]{"data"};
        Map map3 = OptionsSelectorKt.getMap(plotSpec, stringArray2);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        stringArray = new String[]{"x"};
        String string2 = OptionsSelectorKt.getString(bistroSpec, stringArray);
        stringArray = new String[]{"y"};
        String string3 = OptionsSelectorKt.getString(bistroSpec, stringArray);
        stringArray = new String[]{"measure"};
        String string4 = OptionsSelectorKt.getString(bistroSpec, stringArray);
        stringArray = new String[]{"group"};
        String string5 = OptionsSelectorKt.getString(bistroSpec, stringArray);
        stringArray2 = new String[]{"color"};
        String string6 = OptionsSelectorKt.getString(bistroSpec, stringArray2);
        if (string6 == null) {
            string6 = "black";
        }
        if ((string = OptionsSelectorKt.getString(bistroSpec, stringArray2 = new String[]{"fill"})) == null) {
            string = "flow_type";
        }
        stringArray2 = new String[]{"size"};
        Double d = OptionsSelectorKt.getDouble(bistroSpec, stringArray2);
        Double d2 = d != null ? d : 0.0;
        stringArray = new String[]{"alpha"};
        Double d3 = OptionsSelectorKt.getDouble(bistroSpec, stringArray);
        stringArray = new String[]{"linetype"};
        Object object = OptionsSelectorKt.read(bistroSpec, stringArray);
        stringArray2 = new String[]{"width"};
        Double d4 = OptionsSelectorKt.getDouble(bistroSpec, stringArray2);
        double d5 = d4 != null ? d4 : 0.9;
        stringArray2 = new String[]{"show_legend"};
        Boolean bl = OptionsSelectorKt.getBool(bistroSpec, stringArray2);
        Boolean bl2 = bl != null ? bl : false;
        TooltipsOptions tooltipsOptions = this.readBoxTooltipsOptions(bistroSpec, "relative_tooltips", WaterfallPlotOptionsBuilder.Companion.getDEF_RELATIVE_TOOLTIPS(), WaterfallPlotOptionsBuilder.Companion.getDETAILED_RELATIVE_TOOLTIPS());
        TooltipsOptions tooltipsOptions2 = this.readBoxTooltipsOptions(bistroSpec, "absolute_tooltips", WaterfallPlotOptionsBuilder.Companion.getDEF_ABSOLUTE_TOOLTIPS(), WaterfallPlotOptionsBuilder.Companion.getDETAILED_ABSOLUTE_TOOLTIPS());
        stringArray2 = new String[]{"calc_total"};
        Boolean bl3 = OptionsSelectorKt.getBool(bistroSpec, stringArray2);
        boolean bl4 = bl3 != null ? bl3 : true;
        stringArray = new String[]{"total_title"};
        String string7 = OptionsSelectorKt.getString(bistroSpec, stringArray);
        stringArray2 = new String[]{"sorted_value"};
        Boolean bl5 = OptionsSelectorKt.getBool(bistroSpec, stringArray2);
        boolean bl6 = bl5 != null ? bl5 : false;
        stringArray = new String[]{"threshold"};
        Double d6 = OptionsSelectorKt.getDouble(bistroSpec, stringArray);
        stringArray = new String[]{"max_values"};
        Integer n = OptionsSelectorKt.getInt(bistroSpec, stringArray);
        WaterfallPlotOptionsBuilder.ElementLineOptions elementLineOptions = this.readElementLineOptions(bistroSpec, "hline", WaterfallPlotOptionsBuilder.Companion.getDEF_H_LINE());
        stringArray2 = new String[]{"hline_ontop"};
        Boolean bl7 = OptionsSelectorKt.getBool(bistroSpec, stringArray2);
        boolean bl8 = bl7 != null ? bl7 : true;
        WaterfallPlotOptionsBuilder.ElementLineOptions elementLineOptions2 = this.readElementLineOptions(bistroSpec, "connector", WaterfallPlotOptionsBuilder.Companion.getDEF_CONNECTOR());
        WaterfallPlotOptionsBuilder.ElementTextOptions elementTextOptions = this.readElementTextOptions(bistroSpec, "label", WaterfallPlotOptionsBuilder.Companion.getDEF_LABEL());
        stringArray2 = new String[]{"label_format"};
        String string8 = OptionsSelectorKt.getString(bistroSpec, stringArray2);
        if (string8 == null) {
            string8 = ".2~f";
        }
        WaterfallPlotOptionsBuilder waterfallPlotOptionsBuilder = new WaterfallPlotOptionsBuilder(map3, string2, string3, string4, string5, string6, string, d2, d3, object, d5, bl2, tooltipsOptions, tooltipsOptions2, bl4, string7, bl6, d6, n, elementLineOptions, bl8, elementLineOptions2, elementTextOptions, string8);
        PlotOptions waterfallPlotOptions = waterfallPlotOptionsBuilder.build();
        return OptionsUtil.INSTANCE.toSpec(waterfallPlotOptions);
    }

    private final TooltipsOptions readBoxTooltipsOptions(Map<String, ? extends Object> bistroSpec, String optionName, TooltipsOptions defaultTooltips, TooltipsOptions detailedTooltips) {
        Map<String, Object> map2;
        block6: {
            block5: {
                String[] stringArray = new String[]{optionName};
                String string = OptionsSelectorKt.getString(bistroSpec, stringArray);
                if (Intrinsics.areEqual((Object)string, (Object)"none")) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"detailed")) {
                    return detailedTooltips;
                }
                stringArray = new String[]{optionName};
                map2 = OptionsSelectorKt.getMap(bistroSpec, stringArray);
                if (map2 == null) break block5;
                Map<String, Object> tooltipsOptions = map2;
                boolean bl = false;
                TooltipsOptions tooltipsOptions2 = TooltipsOptionsKt.tooltips((Function1<? super TooltipsOptions, Unit>)((Function1)new Function1<TooltipsOptions, Unit>(tooltipsOptions){
                    final /* synthetic */ Map<String, Object> $tooltipsOptions;
                    {
                        this.$tooltipsOptions = $tooltipsOptions;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull TooltipsOptions $this$tooltips) {
                        List list2;
                        Intrinsics.checkNotNullParameter((Object)$this$tooltips, (String)"$this$tooltips");
                        Object object = new String[]{"tooltip_anchor"};
                        $this$tooltips.setAnchor(OptionsSelectorKt.getString(this.$tooltipsOptions, object));
                        object = new String[]{"tooltip_min_width"};
                        $this$tooltips.setMinWidth(OptionsSelectorKt.getDouble(this.$tooltipsOptions, object));
                        object = new String[]{"title"};
                        $this$tooltips.setTitle(OptionsSelectorKt.getString(this.$tooltipsOptions, object));
                        object = new String[]{"disable_splitting"};
                        $this$tooltips.setDisableSplitting(OptionsSelectorKt.getBool(this.$tooltipsOptions, object));
                        Object object2 = new String[]{"lines"};
                        object = OptionsSelectorKt.getList(this.$tooltipsOptions, object2);
                        $this$tooltips.setLines((List<String>)(object instanceof List ? object : null));
                        TooltipsOptions tooltipsOptions = $this$tooltips;
                        String[] stringArray = new String[]{"formats"};
                        object2 = OptionsSelectorKt.getList(this.$tooltipsOptions, stringArray);
                        Object object3 = object2 instanceof List ? object2 : null;
                        if (object3 != null) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            object2 = (Iterable)object3;
                            TooltipsOptions tooltipsOptions2 = tooltipsOptions;
                            boolean $i$f$map = false;
                            void var5_7 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void formatOptions;
                                Map map2 = (Map)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(TooltipsOptions.Companion.format((Function1<? super TooltipsOptions.Format, Unit>)((Function1)new Function1<TooltipsOptions.Format, Unit>((Map<String, String>)formatOptions){
                                    final /* synthetic */ Map<String, String> $formatOptions;
                                    {
                                        this.$formatOptions = $formatOptions;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull TooltipsOptions.Format $this$format) {
                                        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
                                        $this$format.setField(this.$formatOptions.get("field"));
                                        $this$format.setFormat(this.$formatOptions.get("format"));
                                    }
                                })));
                            }
                            list2 = (List)destination$iv$iv;
                            tooltipsOptions = tooltipsOptions2;
                        } else {
                            list2 = null;
                        }
                        tooltipsOptions.setFormats(list2);
                    }
                }));
                map2 = tooltipsOptions2;
                if (tooltipsOptions2 != null) break block6;
            }
            map2 = defaultTooltips;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final WaterfallPlotOptionsBuilder.ElementLineOptions readElementLineOptions(Map<String, ? extends Object> bistroSpec, String option, WaterfallPlotOptionsBuilder.ElementLineOptions defaults) {
        Map<String, Object> map2;
        block7: {
            block6: {
                LineType lineType2;
                String[] stringArray = new String[]{option};
                if (Intrinsics.areEqual((Object)OptionsSelectorKt.getString(bistroSpec, stringArray), (Object)"blank")) {
                    return new WaterfallPlotOptionsBuilder.ElementLineOptions(null, null, null, true, 7, null);
                }
                String[] stringArray2 = new String[]{option};
                map2 = OptionsSelectorKt.getMap(bistroSpec, stringArray2);
                if (map2 == null) break block6;
                Map<String, Object> elementLineSpec = map2;
                boolean bl = false;
                WaterfallPlotOptionsBuilder.ElementLineOptions elementLineOptions = defaults;
                String[] stringArray3 = new String[]{"color"};
                String string = OptionsSelectorKt.getString(elementLineSpec, stringArray3);
                stringArray3 = new String[]{"size"};
                Double d = OptionsSelectorKt.getDouble(elementLineSpec, stringArray3);
                String[] stringArray4 = new String[]{"linetype"};
                Object object = OptionsSelectorKt.read(elementLineSpec, stringArray4);
                if (object != null) {
                    void it;
                    Object object2 = object;
                    Double d2 = d;
                    String string2 = string;
                    WaterfallPlotOptionsBuilder.ElementLineOptions elementLineOptions2 = elementLineOptions;
                    boolean bl2 = false;
                    LineType lineType3 = new LineTypeOptionConverter().apply((Object)it);
                    elementLineOptions = elementLineOptions2;
                    string = string2;
                    d = d2;
                    lineType2 = lineType3;
                } else {
                    lineType2 = null;
                }
                stringArray4 = new String[]{"blank"};
                Boolean bl3 = OptionsSelectorKt.getBool(elementLineSpec, stringArray4);
                boolean bl4 = bl3 != null ? bl3 : false;
                LineType lineType4 = lineType2;
                Double d3 = d;
                String string3 = string;
                WaterfallPlotOptionsBuilder.ElementLineOptions elementLineOptions3 = elementLineOptions.merge(new WaterfallPlotOptionsBuilder.ElementLineOptions(string3, d3, lineType4, bl4));
                map2 = elementLineOptions3;
                if (elementLineOptions3 != null) break block7;
            }
            map2 = defaults;
        }
        return map2;
    }

    private final WaterfallPlotOptionsBuilder.ElementTextOptions readElementTextOptions(Map<String, ? extends Object> bistroSpec, String option, WaterfallPlotOptionsBuilder.ElementTextOptions defaults) {
        Map<String, Object> map2;
        block5: {
            block4: {
                String[] stringArray = new String[]{option};
                if (Intrinsics.areEqual((Object)OptionsSelectorKt.getString(bistroSpec, stringArray), (Object)"blank")) {
                    return new WaterfallPlotOptionsBuilder.ElementTextOptions(null, null, null, null, null, null, null, true, 127, null);
                }
                String[] stringArray2 = new String[]{option};
                map2 = OptionsSelectorKt.getMap(bistroSpec, stringArray2);
                if (map2 == null) break block4;
                Map<String, Object> elementTextSpec = map2;
                boolean bl = false;
                String[] stringArray3 = new String[]{"color"};
                String string = OptionsSelectorKt.getString(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"family"};
                String string2 = OptionsSelectorKt.getString(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"face"};
                String string3 = OptionsSelectorKt.getString(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"size"};
                Double d = OptionsSelectorKt.getDouble(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"angle"};
                Double d2 = OptionsSelectorKt.getDouble(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"hjust"};
                Double d3 = OptionsSelectorKt.getDouble(elementTextSpec, stringArray3);
                stringArray3 = new String[]{"vjust"};
                String[] stringArray4 = new String[]{"blank"};
                Boolean bl2 = OptionsSelectorKt.getBool(elementTextSpec, stringArray4);
                WaterfallPlotOptionsBuilder.ElementTextOptions elementTextOptions = defaults.merge(new WaterfallPlotOptionsBuilder.ElementTextOptions(string, string2, string3, d, d2, d3, OptionsSelectorKt.getDouble(elementTextSpec, stringArray3), bl2 != null ? bl2 : false));
                map2 = elementTextOptions;
                if (elementTextOptions != null) break block5;
            }
            map2 = defaults;
        }
        return map2;
    }

    @Override
    public boolean isApplicable(@NotNull Map<String, ? extends Object> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        String[] stringArray = new String[]{"bistro", "name"};
        return Intrinsics.areEqual((Object)OptionsSelectorKt.getString(spec, stringArray), (Object)"waterfall");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/WaterfallPlotSpecChange$Companion;", "", "()V", "specSelector", "Lorg/jetbrains/letsPlot/core/spec/transform/SpecSelector;", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpecSelector specSelector() {
            return SpecSelector.Companion.root();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

