/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterNotificationServiceKt;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NotificationInfo;
import com.intellij.javascript.nodejs.interpreter.OpenLinkInBrowser;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ+\u0010\r\u001a\u00020\u000b2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/UnresolvedProjectInterpreterNotification;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "currentNotification", "Lcom/intellij/javascript/nodejs/interpreter/NotificationInfo;", "showIfUnresolved", "", "hideIfResolved", "calcNotificationStatus", "consumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "notify", "showNotification", "createDownloadNodeAction", "Lcom/intellij/javascript/nodejs/interpreter/OpenLinkInBrowser;", "isLocalProject", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeInterpreterNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeInterpreterNotificationService.kt\ncom/intellij/javascript/nodejs/interpreter/UnresolvedProjectInterpreterNotification\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n24#2:157\n*S KotlinDebug\n*F\n+ 1 NodeInterpreterNotificationService.kt\ncom/intellij/javascript/nodejs/interpreter/UnresolvedProjectInterpreterNotification\n*L\n105#1:157\n*E\n"})
final class UnresolvedProjectInterpreterNotification {
    @NotNull
    private final Project project;
    @NotNull
    private final NotificationInfo currentNotification;

    public UnresolvedProjectInterpreterNotification(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.currentNotification = new NotificationInfo();
        NodeJsInterpreterManager.getInstance(this.project).addChangeListener(arg_0 -> UnresolvedProjectInterpreterNotification._init_$lambda$0(this, arg_0), parentDisposable);
    }

    public final void showIfUnresolved() {
        if (!this.currentNotification.isShowing()) {
            this.calcNotificationStatus((Function1<? super Boolean, Unit>)((Function1)arg_0 -> UnresolvedProjectInterpreterNotification.showIfUnresolved$lambda$2(this, arg_0)));
        }
    }

    public final void hideIfResolved() {
        if (this.currentNotification.isShowing()) {
            this.calcNotificationStatus((Function1<? super Boolean, Unit>)((Function1)arg_0 -> UnresolvedProjectInterpreterNotification.hideIfResolved$lambda$3(this, arg_0)));
        }
    }

    private final void calcNotificationStatus(Function1<? super Boolean, Unit> consumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> UnresolvedProjectInterpreterNotification.calcNotificationStatus$lambda$5(consumer, this));
    }

    @RequiresEdt
    private final void showNotification() {
        UnresolvedProjectInterpreterNotification $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UnresolvedProjectInterpreterNotification.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Showing notification about unresolved project Node.js interpreter");
        this.currentNotification.hide();
        Object[] objectArray = new Object[]{ApplicationInfo.getInstance().getVersionName()};
        String string = JavaScriptBundle.message("unresolved.project.interpreter.notification.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String content = string;
        Notification notification = NodeInterpreterNotificationServiceKt.getNotificationGroup().createNotification(content, NotificationType.INFORMATION);
        notification.addAction((AnAction)this.createDownloadNodeAction());
        notification.addAction(NodeSettingsConfigurable.createConfigureInterpreterAction(this.project, () -> ((Notification)notification).expire()));
        notification.notify(this.project);
        this.currentNotification.bindTo(notification);
    }

    private final OpenLinkInBrowser createDownloadNodeAction() {
        String string = JavaScriptBundle.message("unresolved.project.interpreter.notification.download.action.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Supplier<String> supplier = JavaScriptBundle.messagePointer("unresolved.project.interpreter.notification.download.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return new OpenLinkInBrowser(string, supplier);
    }

    private final boolean isLocalProject() {
        Object object = ReadAction.compute(() -> UnresolvedProjectInterpreterNotification.isLocalProject$lambda$6(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private static final void _init_$lambda$0(UnresolvedProjectInterpreterNotification this$0, NodeJsInterpreter it) {
        this$0.hideIfResolved();
    }

    private static final void showIfUnresolved$lambda$2$lambda$1(UnresolvedProjectInterpreterNotification this$0) {
        this$0.showNotification();
    }

    private static final Unit showIfUnresolved$lambda$2(UnresolvedProjectInterpreterNotification this$0, boolean it) {
        if (it) {
            ApplicationManager.getApplication().invokeLater(() -> UnresolvedProjectInterpreterNotification.showIfUnresolved$lambda$2$lambda$1(this$0), this$0.project.getDisposed());
        }
        return Unit.INSTANCE;
    }

    private static final Unit hideIfResolved$lambda$3(UnresolvedProjectInterpreterNotification this$0, boolean it) {
        if (!it) {
            this$0.currentNotification.hide();
        }
        return Unit.INSTANCE;
    }

    private static final NodeJsInterpreterRef calcNotificationStatus$lambda$5$lambda$4(UnresolvedProjectInterpreterNotification this$0) {
        return this$0.project.isDisposed() ? null : NodeJsInterpreterManager.getInstance(this$0.project).getInterpreterRef();
    }

    private static final void calcNotificationStatus$lambda$5(Function1 $consumer, UnresolvedProjectInterpreterNotification this$0) {
        NodeJsInterpreterRef interpreterRef = (NodeJsInterpreterRef)ReadAction.compute(() -> UnresolvedProjectInterpreterNotification.calcNotificationStatus$lambda$5$lambda$4(this$0));
        $consumer.invoke((Object)(interpreterRef != null && interpreterRef.resolve(this$0.project) == null && this$0.isLocalProject() ? 1 : 0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean isLocalProject$lambda$6(UnresolvedProjectInterpreterNotification this$0) {
        boolean bl;
        VirtualFile root;
        VirtualFile virtualFile = root = this$0.project.isDisposed() ? null : ProjectUtil.guessProjectDir((Project)this$0.project);
        if (root != null) {
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!WslPath.Companion.isWslUncPath(string)) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }
}

