/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.findUsages.JSQualifiedNameProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.xml.breadcrumbs.XmlLanguageBreadcrumbsInfoProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBreadcrumbsProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{JavascriptLanguage.INSTANCE, JavaScriptSupportLoader.TYPESCRIPT};
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof JSXmlLiteralExpression) {
            return true;
        }
        if (element instanceof JSSwitchStatement) {
            return true;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        if (element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getExpression() instanceof JSIndexedPropertyAccessExpression) {
            return false;
        }
        return !(element instanceof JSExpression) || (assignedTo = JSPsiImplUtils.getInitializedElement((JSExpression)element)) == null;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        JSExpression expression;
        JSExpression methodExpression;
        PsiElement callExpr;
        PsiElement parent;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof JSXmlLiteralExpression) {
            String string = XmlLanguageBreadcrumbsInfoProvider.getInfo((PsiElement)element);
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (element instanceof JSSwitchStatement) {
            JSExpression expression2 = ((JSSwitchStatement)element).getSwitchExpression();
            String expr = expression2 != null ? StringUtil.trimLog((String)expression2.getText(), (int)20) : "...";
            String string = "switch (" + expr + ")";
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && (parent = element.getParent()) instanceof JSArgumentList && (callExpr = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpr).getMethodExpression()) != null) {
            IntRef maxActualChars = new IntRef(methodExpression.getTextLength());
            Object shortened = JSBreadcrumbsProvider.printLeaves(PsiTreeUtil.getDeepestFirst((PsiElement)methodExpression), true, 30, maxActualChars);
            if (maxActualChars.get() > 0) {
                String suffix = JSBreadcrumbsProvider.printLeaves(PsiTreeUtil.getDeepestLast((PsiElement)methodExpression), false, 10, maxActualChars);
                if (maxActualChars.get() > 0) {
                    shortened = (String)shortened + "...";
                }
                shortened = (String)shortened + suffix;
            }
            String string = JavaScriptBundle.message("js.breadcrumbs.callback.for", shortened);
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        String name = null;
        if (!(!(element instanceof JSDefinitionExpression) || (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSThisExpression)) {
            name = ((JSDefinitionExpression)element).getQualifiedName();
        }
        if (name == null && element instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)element).getName();
        }
        if (name != null && (name.startsWith("[Symbol.") || name.indexOf(46) == -1)) {
            name = JSSymbolUtil.quoteIfSpecialPropertyName(name, JSUtils.isPrivateSharpItem(element), '\"');
        }
        if (name == null) {
            name = JSFormatUtil.getAnonymousElementPresentation();
        }
        builder2.append(name);
        if (element instanceof JSFunction || element instanceof JSInitializerOwner && ((JSInitializerOwner)element).getInitializer() instanceof JSFunction) {
            builder2.append("()");
        }
        String string = builder2.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String printLeaves(@NotNull PsiElement leaf, boolean forward, int maxChars, @NotNull IntRef maxActualChars) {
        if (leaf == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        if (maxActualChars == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder();
        while (leaf != null) {
            String append;
            String string = leaf instanceof PsiWhiteSpace ? " " : (append = leaf instanceof PsiComment ? "" : leaf.getText());
            if (result2.length() + append.length() > maxChars || result2.length() > 0 && maxActualChars.get() - leaf.getTextLength() < 0) break;
            if (forward) {
                result2.append(append);
            } else {
                result2.insert(0, append);
            }
            maxActualChars.set(maxActualChars.get() - leaf.getTextLength());
            leaf = forward ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        String string = result2.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(9);
        }
        return element instanceof JSXmlLiteralExpression ? XmlLanguageBreadcrumbsInfoProvider.getTooltip((XmlTag)((XmlTag)element)) : null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element) {
        JSQualifiedNamedElement initializedElement;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(10);
        }
        if (element instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)element)) instanceof JSDefinitionExpression) {
            return initializedElement;
        }
        return element.getParent();
    }

    @NotNull
    public List<? extends Action> getContextActions(final @NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(11);
        }
        List<1> list = Collections.singletonList(new AbstractAction(JavaScriptBundle.message("js.copy.qualified.to.clipboard", new Object[0])){

            @NotNull
            private static PsiElement evaluateElement(@NotNull PsiElement element2) {
                PsiElement resolved;
                PsiReference reference;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof JSXmlLiteralExpression && (reference = element2.getReference()) != null && (resolved = reference.resolve()) != null) {
                    PsiElement psiElement = resolved;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            @Override
            public boolean isEnabled() {
                return !DumbService.isDumb((Project)element.getProject()) && new JSQualifiedNameProvider().getQualifiedName(1.evaluateElement(element)) != null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String qualifiedName = new JSQualifiedNameProvider().getQualifiedName(1.evaluateElement(element));
                if (qualifiedName != null) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(qualifiedName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "evaluateElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "evaluateElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        if (list == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    public boolean isShownByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxActualChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "printLeaves";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printLeaves";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8, 12 -> new IllegalStateException(string);
        };
    }
}

