/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSFlagCommentPlacementInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                int flagStart;
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((flagStart = CharArrayUtil.indexOf((CharSequence)comment.getNode().getChars(), (CharSequence)"@flow", (int)0)) >= 0 && FlowJSAnnotation.findFlowFlagComment(comment.getContainingFile()) != comment) {
                    String message = JavaScriptBundle.message("js.flowjs.flag.comment.placement.inspection.error", new Object[0]);
                    MoveCommentFix fix = new MoveCommentFix((PsiElement)comment);
                    holder.registerProblem((PsiElement)comment, TextRange.from((int)flagStart, (int)"@flow".length()), message, new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/flow/inspections/FlowJSFlagCommentPlacementInspection$1", "visitComment"));
            }
        };
    }

    private static class MoveCommentFix
    extends LocalQuickFixOnPsiElement {
        protected MoveCommentFix(@NotNull PsiElement element) {
            if (element == null) {
                MoveCommentFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.flowjs.flag.comment.placement.inspection.fix", new Object[0]);
            if (string == null) {
                MoveCommentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                MoveCommentFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement anchor;
            if (project == null) {
                MoveCommentFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MoveCommentFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                MoveCommentFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                MoveCommentFix.$$$reportNull$$$0(6);
            }
            PsiElement nonSpaceFirstChild = anchor = file.getFirstChild();
            while (nonSpaceFirstChild instanceof PsiWhiteSpace) {
                nonSpaceFirstChild = nonSpaceFirstChild.getNextSibling();
            }
            while (nonSpaceFirstChild != null && JSPsiImplUtils.isCompilerDirectiveStatement(nonSpaceFirstChild)) {
                nonSpaceFirstChild = nonSpaceFirstChild.getNextSibling();
                while (nonSpaceFirstChild instanceof PsiWhiteSpace) {
                    nonSpaceFirstChild = nonSpaceFirstChild.getNextSibling();
                }
                anchor = nonSpaceFirstChild;
            }
            file.addBefore(MoveCommentFix.getSimpleComment(file.getProject()), anchor);
            MoveCommentFix.updateComment((PsiComment)startElement);
        }

        private static PsiElement getSimpleComment(@NotNull Project project) {
            if (project == null) {
                MoveCommentFix.$$$reportNull$$$0(7);
            }
            ASTNode node = JSChangeUtil.createJSTreeFromText(project, "// @flow", JavaScriptSupportLoader.FLOW_JS);
            assert (node != null);
            return node.getPsi();
        }

        @Nullable
        private static PsiElement createNewComment(@NotNull Project project, @NotNull String newText) {
            ASTNode astNode;
            if (project == null) {
                MoveCommentFix.$$$reportNull$$$0(8);
            }
            if (newText == null) {
                MoveCommentFix.$$$reportNull$$$0(9);
            }
            return (astNode = JSChangeUtil.createJSTreeFromText(project, newText, JavaScriptSupportLoader.FLOW_JS)) != null ? astNode.getPsi() : null;
        }

        private static void updateComment(@NotNull PsiComment comment) {
            if (comment == null) {
                MoveCommentFix.$$$reportNull$$$0(10);
            }
            String commentText = comment.getText();
            commentText = commentText.replace("@flow", "");
            if ((commentText = commentText.replaceAll("[/* \n]", "")).isEmpty()) {
                comment.delete();
            } else {
                String[] elements = comment.getText().split("\n");
                StringBuilder newElement = new StringBuilder();
                for (int i = 0; i < elements.length; ++i) {
                    String element = elements[i];
                    boolean isFlow = false;
                    if (element.contains("@flow")) {
                        element = element.replace("@flow", "");
                        isFlow = true;
                    }
                    if (isFlow && element.replaceAll("[/* ]", "").isEmpty()) continue;
                    newElement.append(element);
                    if (i >= elements.length - 1) continue;
                    newElement.append("\n");
                }
                PsiElement newComment = MoveCommentFix.createNewComment(comment.getProject(), newElement.toString());
                if (newComment != null) {
                    comment.replace(newComment);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/inspections/FlowJSFlagCommentPlacementInspection$MoveCommentFix";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newText";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/inspections/FlowJSFlagCommentPlacementInspection$MoveCommentFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleComment";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewComment";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "updateComment";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

