/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0011H\u0014J4\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLspService;", "Lcom/intellij/lang/javascript/flow/FlowJSServerService;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "config", "Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/lsp/api/LspServer;Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;Lcom/intellij/openapi/project/Project;)V", "getDefinitionOfElement", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "element", "getTypeOfElement", "", "Lcom/intellij/lang/javascript/psi/JSElement;", "getCompletionOfElement", "", "originalFile", "Lcom/intellij/psi/PsiFile;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "text", "getPositionParams", "Lorg/eclipse/lsp4j/DefinitionParams;", "offset", "", "getHoverParams", "Lorg/eclipse/lsp4j/HoverParams;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nFlowJSLspService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowJSLspService.kt\ncom/intellij/lang/javascript/flow/lsp/FlowJSLspService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1187#2,2:106\n1261#2,4:108\n*S KotlinDebug\n*F\n+ 1 FlowJSLspService.kt\ncom/intellij/lang/javascript/flow/lsp/FlowJSLspService\n*L\n73#1:106,2\n73#1:108,4\n*E\n"})
public final class FlowJSLspService
extends FlowJSServerService {
    @NotNull
    private final LspServer lspServer;

    public FlowJSLspService(@NotNull LspServer lspServer, @NotNull FlowJSConfig config, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(config, project);
        this.lspServer = lspServer;
    }

    @Override
    @Nullable
    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        DefinitionParams positionParams = this.getPositionParams(psiFile, document, element.getTextOffset());
        Either either = (Either)this.lspServer.sendRequestSync((int)FlowJSServerService.DEFINITION_TIMEOUT_MILLIS, arg_0 -> FlowJSLspService.getDefinitionOfElement$lambda$0(positionParams, arg_0));
        if (either == null) {
            return null;
        }
        Either definition = either;
        if (((List)definition.getLeft()).size() != 1) {
            return null;
        }
        Location location = (Location)((List)definition.getLeft()).get(0);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(VfsUtil.urlToPath((String)location.getUri()));
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return this.getElementByPosition(file, location.getRange().getStart().getLine(), location.getRange().getStart().getCharacter());
    }

    @Override
    @Nullable
    protected String getTypeOfElement(@NotNull JSElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Intrinsics.checkNotNull((Object)file);
        HoverParams positionParams = this.getHoverParams(file, document2, element.getTextOffset());
        Hover hover = (Hover)this.lspServer.sendRequestSync((int)FlowJSServerService.TYPEOF_TIMEOUT_MILLIS, arg_0 -> FlowJSLspService.getTypeOfElement$lambda$1(positionParams, arg_0));
        if (hover == null) {
            return null;
        }
        Hover hover2 = hover;
        if (((List)hover2.getContents().getLeft()).isEmpty()) {
            return null;
        }
        Either either = (Either)((List)hover2.getContents().getLeft()).get(0);
        return either.getLeft() != null ? (String)either.getLeft() : ((MarkedString)either.getRight()).getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull CompletionParameters parameters, @NotNull String text) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DefinitionParams params = this.getPositionParams(originalFile, document, parameters.getOffset());
        Either either = (Either)this.lspServer.sendRequestSync((int)FlowJSServerService.COMPLETION_TIMEOUT_MILLIS, arg_0 -> FlowJSLspService.getCompletionOfElement$lambda$2(params, arg_0));
        List items = CollectionsKt.emptyList();
        if (either != null) {
            List left = (List)either.getLeft();
            if (left != null) {
                items = left;
            } else {
                CompletionList right = (CompletionList)either.getRight();
                if (right != null) {
                    items = right.getItems();
                }
            }
        }
        Iterable $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            CompletionItem it = (CompletionItem)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getLabel(), (Object)it.getDetail());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final DefinitionParams getPositionParams(PsiFile originalFile, Document document, int offset) {
        VirtualFile virtualFile = originalFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(FlowJSLspServiceKt.toURI(virtualFile));
        Position position = FlowJSLspServiceKt.getPositionByOffset(document, offset);
        return new DefinitionParams(identifier, position);
    }

    private final HoverParams getHoverParams(PsiFile originalFile, Document document, int offset) {
        VirtualFile virtualFile = originalFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(FlowJSLspServiceKt.toURI(virtualFile));
        Position position = FlowJSLspServiceKt.getPositionByOffset(document, offset);
        return new HoverParams(identifier, position);
    }

    private static final CompletableFuture getDefinitionOfElement$lambda$0(DefinitionParams $positionParams, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture completableFuture = it.getTextDocumentService().definition($positionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"definition(...)");
        return completableFuture;
    }

    private static final CompletableFuture getTypeOfElement$lambda$1(HoverParams $positionParams, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture completableFuture = it.getTextDocumentService().hover($positionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"hover(...)");
        return completableFuture;
    }

    private static final CompletableFuture getCompletionOfElement$lambda$2(DefinitionParams $params, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture completableFuture = it.getTextDocumentService().completion(new CompletionParams($params.getTextDocument(), $params.getPosition()));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
        return completableFuture;
    }
}

