/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSAmdUtil {
    public static final String REQUIRE_DATA_MAIN_KEY = "js.require.data.main";
    public static final String REQUIRE_BASE_URL_KEY = "jsRequireBaseUrl";
    public static final String REQUIRE_PATH_ALIASES = "jsRequirePathAliases";
    private static final Key<CachedValue<AmdLoaderCallOnPointers>> IS_INSIDE_AMD_DEFINE = Key.create((String)"Javascript.Modules.Amd.Inside.Define");

    public static Collection<VirtualFile> getBaseDirectories(@NotNull PsiElement context2) {
        String name;
        VirtualFile file;
        VirtualFile parent;
        if (context2 == null) {
            JSAmdUtil.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = parent = (file = PsiUtilCore.getVirtualFile((PsiElement)context2)) == null ? null : file.getParent();
        if (parent == null) {
            return Collections.emptyList();
        }
        String componentName = null;
        if (context2 instanceof JSLiteralExpression && ((JSLiteralExpression)context2).isQuotedLiteral() && PathUtil.isValidFileName((String)(name = StringUtil.unquoteString((String)context2.getText())))) {
            componentName = name;
        }
        return JSAmdUtil.getBaseDirectories(componentName, context2.getProject(), JSResolveUtil.getResolveScope(context2), parent);
    }

    @NotNull
    public static Collection<VirtualFile> getBaseDirectories(@Nullable String moduleName, @NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull VirtualFile contextDirectory) {
        if (project == null) {
            JSAmdUtil.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            JSAmdUtil.$$$reportNull$$$0(2);
        }
        if (contextDirectory == null) {
            JSAmdUtil.$$$reportNull$$$0(3);
        }
        Ref candidateBasePaths = Ref.create(new ArrayList());
        Ref closestHtmlFileDir = Ref.create(null);
        FileBasedIndex.getInstance().processValues(JSCustomSingleEntriesIndex.INDEX_ID, (Object)REQUIRE_DATA_MAIN_KEY, null, (file, value) -> {
            VirtualFile closest = (VirtualFile)closestHtmlFileDir.get();
            boolean search = true;
            boolean overwriteIfFound = false;
            if (closest != null) {
                int compare = JSAmdUtil.compareClosenessesToContext(file, closest, contextDirectory);
                if (compare < 0) {
                    overwriteIfFound = true;
                } else if (compare > 0) {
                    search = false;
                }
            }
            if (search) {
                VirtualFile path2;
                VirtualFile parent;
                if (!((String)value).endsWith(".js")) {
                    value = (String)value + ".js";
                }
                VirtualFile virtualFile = parent = (path2 = file.getParent().findFileByRelativePath((String)value)) == null ? null : path2.getParent();
                if (parent != null && parent.isDirectory()) {
                    closestHtmlFileDir.set((Object)file);
                    if (overwriteIfFound) {
                        ((ArrayList)candidateBasePaths.get()).clear();
                    }
                    ((ArrayList)candidateBasePaths.get()).add(parent);
                }
            }
            return true;
        }, scope2);
        HashMap baseUrls = new HashMap();
        StubIndex.getInstance().processElements(JSAmdBaseUrlIndex.KEY, (Object)REQUIRE_BASE_URL_KEY, project, scope2, JSImplicitElementProvider.class, provider -> {
            Collection<JSImplicitElement> elements;
            JSElementIndexingData data = provider.getIndexingData();
            Collection<JSImplicitElement> collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement element : elements) {
                    if (!REQUIRE_BASE_URL_KEY.equals(element.getName()) || !"abu".equals(element.getUserString())) continue;
                    baseUrls.put(provider.getContainingFile().getVirtualFile(), element.getUserStringData());
                }
            }
            return true;
        });
        for (Map.Entry entry : baseUrls.entrySet()) {
            VirtualFile[] includingFiles;
            VirtualFile file2 = (VirtualFile)entry.getKey();
            String value2 = (String)entry.getValue();
            VirtualFile closest = (VirtualFile)closestHtmlFileDir.get();
            boolean overwriteIfFound = false;
            if (closest != null) {
                int compare = JSAmdUtil.compareClosenessesToContext(file2, closest, contextDirectory);
                if (compare < 0) {
                    overwriteIfFound = true;
                } else if (compare > 0) continue;
            }
            for (VirtualFile includingFile : includingFiles = FileIncludeManager.getManager((Project)project).getIncludingFiles(file2, false)) {
                VirtualFile baseDir;
                if (!FileTypeRegistry.getInstance().isFileOfType(includingFile, (FileType)HtmlFileType.INSTANCE) || (baseDir = includingFile.getParent().findFileByRelativePath(value2)) == null || !baseDir.isDirectory()) continue;
                closestHtmlFileDir.set((Object)baseDir);
                if (overwriteIfFound) {
                    ((ArrayList)candidateBasePaths.get()).clear();
                    overwriteIfFound = false;
                }
                ((ArrayList)candidateBasePaths.get()).add(baseDir);
            }
        }
        FileIndexFacade facade = FileIndexFacade.getInstance((Project)project);
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>((Collection)candidateBasePaths.get());
        if (moduleName != null) {
            for (VirtualFile parentDir = contextDirectory; parentDir != null && facade.isInContent(parentDir); parentDir = parentDir.getParent()) {
                VirtualFile dir = parentDir.findChild("bower_components");
                if (dir == null || (dir = dir.findChild(moduleName)) == null) continue;
                results.add(dir);
            }
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            JSAmdUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    static int compareClosenessesToContext(@NotNull VirtualFile dir1, @NotNull VirtualFile dir2, @NotNull VirtualFile context2) {
        if (dir1 == null) {
            JSAmdUtil.$$$reportNull$$$0(5);
        }
        if (dir2 == null) {
            JSAmdUtil.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSAmdUtil.$$$reportNull$$$0(7);
        }
        VirtualFile ancestor1 = VfsUtilCore.getCommonAncestor((VirtualFile)dir1, (VirtualFile)context2);
        VirtualFile ancestor2 = VfsUtilCore.getCommonAncestor((VirtualFile)dir2, (VirtualFile)context2);
        if (ancestor1 == null) {
            return ancestor2 == null ? 0 : 1;
        }
        if (ancestor2 == null) {
            return -1;
        }
        return VfsUtilCore.isAncestor((VirtualFile)ancestor1, (VirtualFile)ancestor2, (boolean)true) ? 1 : (VfsUtilCore.isAncestor((VirtualFile)ancestor2, (VirtualFile)ancestor1, (boolean)true) ? -1 : 0);
    }

    public static String correctPathWithAliases(@NotNull PsiElement element) {
        if (element == null) {
            JSAmdUtil.$$$reportNull$$$0(8);
        }
        VirtualFile containingFile = element.getContainingFile().getVirtualFile();
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(element);
        String[] exactAlias = new String[1];
        HashSet relativeVariants = new HashSet();
        StubIndex.getInstance().processElements(JSAmdRequirePathIndex.KEY, (Object)REQUIRE_PATH_ALIASES, element.getProject(), scope2, JSImplicitElementProvider.class, provider -> {
            Collection<JSImplicitElement> elements;
            JSElementIndexingData data = provider.getIndexingData();
            Collection<JSImplicitElement> collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                VirtualFile file = provider.getContainingFile().getVirtualFile();
                for (JSImplicitElement element1 : elements) {
                    if (!REQUIRE_PATH_ALIASES.equals(element1.getName()) || !"arp".equals(element1.getUserString())) continue;
                    String value = element1.getUserStringData();
                    if (containingFile.equals(file)) {
                        exactAlias[0] = value;
                        return false;
                    }
                    String relative = VfsUtilCore.getRelativePath((VirtualFile)containingFile, (VirtualFile)file, (char)'/');
                    if (relative != null) {
                        if (".".equals(relative) || "/".equals(relative) || relative.isEmpty()) {
                            relativeVariants.add(value);
                        } else {
                            relativeVariants.add(value + "/" + relative);
                        }
                    }
                    return true;
                }
            }
            return true;
        });
        if (exactAlias[0] != null) {
            return exactAlias[0];
        }
        if (!relativeVariants.isEmpty()) {
            String variant = (String)relativeVariants.iterator().next();
            if (relativeVariants.size() > 1) {
                ArrayList<String> list = new ArrayList<String>(relativeVariants);
                list.sort(Comparator.comparingInt(o -> o.split("/").length));
                variant = (String)list.get(0);
            }
            return variant;
        }
        return null;
    }

    @NotNull
    public static Pair<Boolean, String> isFromAmdModuleReturn(@NotNull PsiElement element) {
        if (element == null) {
            JSAmdUtil.$$$reportNull$$$0(9);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            Pair pair = Pair.create((Object)false, null);
            if (pair == null) {
                JSAmdUtil.$$$reportNull$$$0(10);
            }
            return pair;
        }
        JSCallExpression parentDefine = (JSCallExpression)PsiTreeUtil.findFirstContext((PsiElement)element, (boolean)false, element1 -> element1 instanceof JSCallExpression && ((JSCallExpression)element1).isDefineCall());
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        if (parentDefine != null && namespace != null) {
            String name = StringUtil.unquoteString((String)namespace.getName());
            if ("exports".equals(name)) {
                Pair pair = Pair.create((Object)true, null);
                if (pair == null) {
                    JSAmdUtil.$$$reportNull$$$0(11);
                }
                return pair;
            }
            String moduleNamespace = JSAmdPsiUtil.getNamespaceFromExplicitModuleName(parentDefine);
            if (name.equals(moduleNamespace)) {
                Pair pair = Pair.create((Object)true, (Object)JSAmdPsiUtil.getExplicitModuleName(parentDefine));
                if (pair == null) {
                    JSAmdUtil.$$$reportNull$$$0(12);
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)true, null);
        if (pair == null) {
            JSAmdUtil.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @Nullable
    public static AmdLoaderCall findWrappingDefineOrRequireCallback(@NotNull PsiElement element, boolean onlyDefine) {
        boolean isDefine;
        JSReferenceExpression methodExpression;
        PsiElement possibleCallback;
        if (element == null) {
            JSAmdUtil.$$$reportNull$$$0(14);
        }
        if ((possibleCallback = PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> element1 instanceof JSFunctionExpression)) == null) {
            return null;
        }
        PsiElement parent = possibleCallback.getParent();
        Supplier<AmdLoaderCall> goUp = () -> {
            if (parent instanceof PsiFile || parent == null) {
                return null;
            }
            return JSAmdUtil.findWrappingDefineOrRequireCallback(possibleCallback == element ? parent : possibleCallback, false);
        };
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)parent, JSArgumentList.class);
        if (argumentList == null) {
            return goUp.get();
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        AmdLoaderCallParametersChecker checker = new AmdLoaderCallParametersChecker(arguments);
        if (!checker.isCorrect()) {
            return goUp.get();
        }
        JSCallExpression possibleCall = (JSCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSCallExpression.class);
        if (possibleCall != null && (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)possibleCall.getMethodExpression(), JSReferenceExpression.class)) != null && methodExpression.getQualifier() == null && ((isDefine = "define".equals(methodExpression.getReferenceName())) || !onlyDefine && "require".equals(methodExpression.getReferenceName()))) {
            if (!(isDefine || checker.getArray() != null && checker.getRequireParameter() == null)) {
                return goUp.get();
            }
            return new AmdLoaderCall(possibleCall, checker.getCallbackExpression(), isDefine, checker.getArray(), checker.getRequireParameter());
        }
        return goUp.get();
    }

    public static AmdLoaderCallOnPointers getCachedWrappingAmdDefinition(@NotNull PsiElement element) {
        if (element == null) {
            JSAmdUtil.$$$reportNull$$$0(15);
        }
        CachedValueProvider provider = () -> {
            AmdLoaderCall call = JSAmdUtil.findWrappingDefineOrRequireCallback(element, false);
            return new CachedValueProvider.Result((Object)(call == null ? null : call.wrapInPointers()), new Object[]{element.getContainingFile()});
        };
        return (AmdLoaderCallOnPointers)CachedValuesManager.getManager((Project)element.getProject()).getCachedValue((UserDataHolder)element, IS_INSIDE_AMD_DEFINE, provider, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDirectory";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir2";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectories";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isFromAmdModuleReturn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirectories";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareClosenessesToContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "correctPathWithAliases";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFromAmdModuleReturn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findWrappingDefineOrRequireCallback";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedWrappingAmdDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static class AmdLoaderCall {
        private final JSCallExpression myCallExpression;
        private final JSFunctionExpression myCallBackExpression;
        private final boolean myDefinesModule;
        @Nullable
        private final JSArrayLiteralExpression myModulesArray;
        @Nullable
        private final JSParameter myRequireSugaredParameter;

        public AmdLoaderCall(JSCallExpression expression, JSFunctionExpression backExpression, boolean definesModule, @Nullable JSArrayLiteralExpression modulesArray, @Nullable JSParameter requireSugaredParameter) {
            this.myCallExpression = expression;
            this.myCallBackExpression = backExpression;
            this.myDefinesModule = definesModule;
            this.myModulesArray = modulesArray;
            this.myRequireSugaredParameter = requireSugaredParameter;
        }

        public boolean isValid() {
            return this.myCallExpression != null && this.myCallBackExpression != null;
        }

        public JSCallExpression getCallExpression() {
            return this.myCallExpression;
        }

        public JSFunctionExpression getCallBackExpression() {
            return this.myCallBackExpression;
        }

        public boolean isDefinesModule() {
            return this.myDefinesModule;
        }

        @Nullable
        public JSArrayLiteralExpression getModulesArray() {
            return this.myModulesArray;
        }

        @Nullable
        public JSParameter getRequireSugaredParameter() {
            return this.myRequireSugaredParameter;
        }

        public AmdLoaderCallOnPointers wrapInPointers() {
            SmartPointerManager instance = SmartPointerManager.getInstance((Project)this.myCallExpression.getProject());
            return new PointerVersion((SmartPsiElementPointer<JSCallExpression>)instance.createSmartPsiElementPointer((PsiElement)this.myCallExpression), (SmartPsiElementPointer<JSFunctionExpression>)instance.createSmartPsiElementPointer((PsiElement)this.myCallBackExpression), this.myDefinesModule, (SmartPsiElementPointer<JSArrayLiteralExpression>)(this.myModulesArray == null ? null : instance.createSmartPsiElementPointer((PsiElement)this.myModulesArray)), this.myRequireSugaredParameter == null ? null : instance.createSmartPsiElementPointer((PsiElement)this.myRequireSugaredParameter));
        }

        private static final class PointerVersion
        implements AmdLoaderCallOnPointers {
            @NotNull
            private final SmartPsiElementPointer<JSCallExpression> myCallPointer;
            @NotNull
            private final SmartPsiElementPointer<JSFunctionExpression> myCallbackPointer;
            private final boolean myDefinesModule;
            @Nullable
            private final SmartPsiElementPointer<JSArrayLiteralExpression> myArrayPointer;
            @Nullable
            private final SmartPsiElementPointer<JSParameter> myRequireSugaredPointer;

            private PointerVersion(@NotNull SmartPsiElementPointer<JSCallExpression> pointer, @NotNull SmartPsiElementPointer<JSFunctionExpression> callbackPointer, boolean module, @Nullable SmartPsiElementPointer<JSArrayLiteralExpression> arrayPointer, @Nullable SmartPsiElementPointer<JSParameter> sugaredPointer) {
                if (pointer == null) {
                    PointerVersion.$$$reportNull$$$0(0);
                }
                if (callbackPointer == null) {
                    PointerVersion.$$$reportNull$$$0(1);
                }
                this.myCallPointer = pointer;
                this.myCallbackPointer = callbackPointer;
                this.myDefinesModule = module;
                this.myArrayPointer = arrayPointer;
                this.myRequireSugaredPointer = sugaredPointer;
            }

            @Override
            public AmdLoaderCall toCall() {
                return new AmdLoaderCall((JSCallExpression)this.myCallPointer.getElement(), (JSFunctionExpression)this.myCallbackPointer.getElement(), this.myDefinesModule, this.myArrayPointer == null ? null : (JSArrayLiteralExpression)this.myArrayPointer.getElement(), this.myRequireSugaredPointer == null ? null : (JSParameter)this.myRequireSugaredPointer.getElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pointer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callbackPointer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil$AmdLoaderCall$PointerVersion";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class AmdLoaderCallParametersChecker {
        private boolean myIsCorrect;
        private JSArrayLiteralExpression myArray;
        private JSParameter myRequireParameter;
        private JSFunctionExpression myCallbackExpression;

        public AmdLoaderCallParametersChecker(JSExpression[] arguments) {
            Processor callBackChecker = expression -> {
                this.myCallbackExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
                if (this.myCallbackExpression == null) {
                    return false;
                }
                JSParameter[] parameters = this.myCallbackExpression.getParameterVariables();
                if (parameters.length > 0) {
                    this.myRequireParameter = parameters[0];
                }
                return true;
            };
            Predicate<JSExpression> moduleIdProcessor = expression -> {
                JSLiteralExpression moduleId = (JSLiteralExpression)ObjectUtils.tryCast((Object)expression, JSLiteralExpression.class);
                if (moduleId == null) {
                    return false;
                }
                return moduleId.isQuotedLiteral();
            };
            Processor<JSExpression> modulesArrayProcessor = new Processor<JSExpression>(){

                public boolean process(JSExpression expression) {
                    myArray = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)expression, JSArrayLiteralExpression.class);
                    return myArray != null && this.checkNumberOfParameters();
                }

                private boolean checkNumberOfParameters() {
                    return myCallbackExpression.getAttributeList() == null || myArray.getExpressions().length >= myCallbackExpression.getAttributeList().getAttributes().length;
                }
            };
            if (arguments.length == 1) {
                callBackChecker.process((Object)arguments[0]);
                this.myIsCorrect = this.myCallbackExpression != null;
                return;
            }
            if (arguments.length == 2) {
                if (!callBackChecker.process((Object)arguments[1])) {
                    return;
                }
                if (arguments[0] instanceof JSLiteralExpression) {
                    if (moduleIdProcessor.test(arguments[0])) {
                        this.myIsCorrect = true;
                    }
                } else if (arguments[0] instanceof JSArrayLiteralExpression) {
                    this.myRequireParameter = null;
                    this.myIsCorrect = modulesArrayProcessor.process((Object)arguments[0]);
                }
            } else if (arguments.length == 3) {
                if (!(callBackChecker.process((Object)arguments[2]) && modulesArrayProcessor.process((Object)arguments[1]) && moduleIdProcessor.test(arguments[0]))) {
                    return;
                }
                this.myIsCorrect = this.myCallbackExpression != null;
                this.myRequireParameter = null;
            }
        }

        public boolean isCorrect() {
            return this.myIsCorrect;
        }

        public JSArrayLiteralExpression getArray() {
            return this.myArray;
        }

        public JSParameter getRequireParameter() {
            return this.myRequireParameter;
        }

        public JSFunctionExpression getCallbackExpression() {
            return this.myCallbackExpression;
        }
    }

    public static interface AmdLoaderCallOnPointers {
        public AmdLoaderCall toCall();
    }
}

